/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette2;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;

public class DependencyManager
implements Disposable {
    private final Project myProject;
    private final Set<String> myMissingLibraries;
    private final List<DependencyChangeListener> myListeners;
    private Module myModule;
    private Palette myPalette;
    private boolean myUseAndroidXDependencies;
    private boolean myRegisteredForDependencyUpdates;
    private boolean myNotifyAlways;

    public DependencyManager(@NotNull Project project) {
        if (project == null) {
            DependencyManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myMissingLibraries = new HashSet<String>();
        this.myListeners = new ArrayList<DependencyChangeListener>(2);
        this.myPalette = Palette.EMPTY;
    }

    public void addDependencyChangeListener(@NotNull DependencyChangeListener listener2) {
        if (listener2 == null) {
            DependencyManager.$$$reportNull$$$0(1);
        }
        this.myListeners.add(listener2);
    }

    public void setPalette(@NotNull Palette palette, @NotNull Module module) {
        if (palette == null) {
            DependencyManager.$$$reportNull$$$0(2);
        }
        if (module == null) {
            DependencyManager.$$$reportNull$$$0(3);
        }
        this.myPalette = palette;
        this.myModule = module;
        this.checkForRelevantDependencyChanges();
        this.registerDependencyUpdates();
    }

    public boolean useAndroidXDependencies() {
        return this.myUseAndroidXDependencies;
    }

    public boolean needsLibraryLoad(@NotNull Palette.Item item) {
        if (item == null) {
            DependencyManager.$$$reportNull$$$0(4);
        }
        return this.myMissingLibraries.contains(item.getGradleCoordinateId());
    }

    public boolean dependsOn(@NotNull GoogleMavenArtifactId artifactId) {
        if (artifactId == null) {
            DependencyManager.$$$reportNull$$$0(5);
        }
        return DependencyManagementUtil.dependsOn(this.myModule, artifactId);
    }

    public void setNotifyAlways(boolean notifyAlways) {
        this.myNotifyAlways = notifyAlways;
    }

    public void dispose() {
    }

    private boolean checkForRelevantDependencyChanges() {
        return this.checkForNewMissingDependencies() | this.checkForNewAndroidXDependencies();
    }

    private boolean checkForNewAndroidXDependencies() {
        boolean useAndroidX = this.computeUseAndroidXDependencies();
        if (useAndroidX == this.myUseAndroidXDependencies) {
            return false;
        }
        this.myUseAndroidXDependencies = useAndroidX;
        return true;
    }

    private boolean checkForNewMissingDependencies() {
        Set missing = Collections.emptySet();
        if (this.myModule != null && !this.myModule.isDisposed()) {
            AndroidModuleSystem moduleSystem = ProjectSystemService.getInstance(this.myProject).getProjectSystem().getModuleSystem(this.myModule);
            missing = this.myPalette.getGradleCoordinateIds().stream().map(id -> GradleCoordinate.parseCoordinateString((String)(id + ":+"))).filter(Objects::nonNull).filter(coordinate -> moduleSystem.getRegisteredDependency((GradleCoordinate)coordinate) == null).map(coordinate -> coordinate.getId()).filter(Objects::nonNull).collect(Collectors.toSet());
            if (this.myMissingLibraries.equals(missing)) {
                return false;
            }
        }
        this.myMissingLibraries.clear();
        this.myMissingLibraries.addAll(missing);
        return true;
    }

    private void registerDependencyUpdates() {
        if (this.myRegisteredForDependencyUpdates) {
            return;
        }
        this.myRegisteredForDependencyUpdates = true;
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
            if (result2 == ProjectSystemSyncManager.SyncResult.SUCCESS && this.checkForRelevantDependencyChanges() || this.myNotifyAlways) {
                this.myListeners.forEach(listener2 -> listener2.onDependenciesChanged());
            }
        });
    }

    public void ensureLibraryIsIncluded(@NotNull Palette.Item item) {
        GradleCoordinate coordinate;
        if (item == null) {
            DependencyManager.$$$reportNull$$$0(6);
        }
        if (this.needsLibraryLoad(item) && (coordinate = GradleCoordinate.parseCoordinateString((String)(item.getGradleCoordinateId() + ":+"))) != null) {
            DependencyManagementUtil.addDependencies(this.myModule, Collections.singletonList(coordinate), true);
        }
    }

    private boolean computeUseAndroidXDependencies() {
        if (MigrateToAndroidxUtil.hasAndroidxProperty(this.myProject)) {
            return MigrateToAndroidxUtil.isAndroidx(this.myProject);
        }
        if (DependencyManagementUtil.dependsOnAndroidx(this.myModule)) {
            return true;
        }
        return !DependencyManagementUtil.dependsOnOldSupportLib(this.myModule) && (Boolean)StudioFlags.NELE_USE_ANDROIDX_DEFAULT.get() != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "palette";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/palette2/DependencyManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addDependencyChangeListener";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setPalette";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "needsLibraryLoad";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "dependsOn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureLibraryIsIncluded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface DependencyChangeListener {
        public void onDependenciesChanged();
    }
}

