/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette2;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.uibuilder.palette.NlPaletteModel;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette2.CategoryListModel;
import com.android.tools.idea.uibuilder.palette2.DependencyManager;
import com.android.tools.idea.uibuilder.palette2.ItemListModel;
import com.android.tools.idea.uibuilder.palette2.PatternFilter;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class DataModel {
    public static final Palette.Group COMMON = new Palette.Group("Common");
    public static final Palette.Group RESULTS = new Palette.Group("All Results");
    public static final String FAVORITE_ITEMS = "Palette.Favorite.items";
    private final CategoryListModel myListModel;
    private final ItemListModel myItemModel;
    private final Condition<Palette.Item> myFilterCondition;
    private final PatternFilter myFilterPattern;
    private final DependencyManager myDependencyManager;
    private final List<String> myFavoriteItems;
    private NlLayoutType myLayoutType;
    private Palette myPalette;
    private Palette.Group myCurrentSelectedGroup;

    public DataModel(@NotNull DependencyManager dependencyManager) {
        if (dependencyManager == null) {
            DataModel.$$$reportNull$$$0(0);
        }
        this.myListModel = new CategoryListModel();
        this.myItemModel = new ItemListModel();
        this.myFavoriteItems = DataModel.readFavoriteItems();
        this.myDependencyManager = dependencyManager;
        this.myLayoutType = NlLayoutType.UNKNOWN;
        this.myPalette = Palette.EMPTY;
        this.myCurrentSelectedGroup = COMMON;
        this.myDependencyManager.addDependencyChangeListener(() -> this.onDependenciesChanged());
        this.myFilterPattern = new PatternFilter();
        Condition androidxFilter = item -> {
            boolean isOldSupportLibTag;
            String tagName = item.getTagName();
            boolean isAndroidxTag = tagName.startsWith("androidx") || tagName.startsWith("com.google.android.material");
            boolean bl = isOldSupportLibTag = !isAndroidxTag && tagName.startsWith("android.support.");
            if (!isAndroidxTag && !isOldSupportLibTag) {
                return true;
            }
            return this.myDependencyManager.useAndroidXDependencies() ? isAndroidxTag : isOldSupportLibTag;
        };
        this.myFilterCondition = Conditions.and((Condition)androidxFilter, (Condition)this.myFilterPattern);
    }

    @NotNull
    public CategoryListModel getCategoryListModel() {
        CategoryListModel categoryListModel = this.myListModel;
        if (categoryListModel == null) {
            DataModel.$$$reportNull$$$0(1);
        }
        return categoryListModel;
    }

    @NotNull
    public ItemListModel getItemListModel() {
        ItemListModel itemListModel = this.myItemModel;
        if (itemListModel == null) {
            DataModel.$$$reportNull$$$0(2);
        }
        return itemListModel;
    }

    public void setLayoutType(@NotNull AndroidFacet facet, @NotNull NlLayoutType layoutType) {
        if (facet == null) {
            DataModel.$$$reportNull$$$0(3);
        }
        if (layoutType == null) {
            DataModel.$$$reportNull$$$0(4);
        }
        if (this.myLayoutType.equals((Object)layoutType)) {
            return;
        }
        NlPaletteModel paletteModel = NlPaletteModel.get(facet);
        this.myPalette = paletteModel.getPalette(layoutType);
        this.myLayoutType = layoutType;
        this.myDependencyManager.setPalette(this.myPalette, facet.getModule());
        this.update();
    }

    public void setFilterPattern(@NotNull String pattern) {
        if (pattern == null) {
            DataModel.$$$reportNull$$$0(5);
        }
        if (this.myFilterPattern.setPattern(pattern)) {
            this.update();
        }
    }

    public boolean hasFilterPattern() {
        return this.myFilterPattern.hasPattern();
    }

    public int getMatchCount() {
        return this.myListModel.getMatchCountAt(0);
    }

    public void categorySelectionChanged(@NotNull Palette.Group selectedGroup) {
        if (selectedGroup == null) {
            DataModel.$$$reportNull$$$0(6);
        }
        this.createFilteredItems(selectedGroup);
        this.myCurrentSelectedGroup = selectedGroup;
    }

    public boolean isFavoriteItem(@NotNull Palette.Item item) {
        if (item == null) {
            DataModel.$$$reportNull$$$0(7);
        }
        return this.myFavoriteItems.contains(item.getId());
    }

    public void addFavoriteItem(@NotNull Palette.Item item) {
        if (item == null) {
            DataModel.$$$reportNull$$$0(8);
        }
        if (this.myFavoriteItems.contains(item.getId())) {
            return;
        }
        this.myFavoriteItems.add(item.getId());
        PropertiesComponent.getInstance().setValues(FAVORITE_ITEMS, ArrayUtil.toStringArray(this.myFavoriteItems));
        this.update();
    }

    public void removeFavoriteItem(@NotNull Palette.Item item) {
        if (item == null) {
            DataModel.$$$reportNull$$$0(9);
        }
        if (!this.myFavoriteItems.contains(item.getId())) {
            return;
        }
        this.myFavoriteItems.remove(item.getId());
        PropertiesComponent.getInstance().setValues(FAVORITE_ITEMS, ArrayUtil.toStringArray(this.myFavoriteItems));
        this.update();
        if (this.myCurrentSelectedGroup == COMMON) {
            this.createFilteredItems(COMMON);
        }
    }

    @NotNull
    Palette getPalette() {
        Palette palette = this.myPalette;
        if (palette == null) {
            DataModel.$$$reportNull$$$0(10);
        }
        return palette;
    }

    @NotNull
    private static List<String> readFavoriteItems() {
        Object[] favorites = PropertiesComponent.getInstance().getValues(FAVORITE_ITEMS);
        if (favorites == null) {
            favorites = new String[]{"TextView", "Button", "ImageView", SdkConstants.RECYCLER_VIEW.oldName(), SdkConstants.RECYCLER_VIEW.newName(), "fragment", "ScrollView", "Switch"};
        }
        ArrayList arrayList = Lists.newArrayList((Object[])favorites);
        if (arrayList == null) {
            DataModel.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private void update() {
        final boolean isUserSearch = this.myFilterPattern.hasPattern();
        final ArrayList<Palette.Group> groups = new ArrayList<Palette.Group>();
        final ArrayList<Integer> matchCounts = isUserSearch ? new ArrayList<Integer>() : Collections.emptyList();
        groups.add(isUserSearch ? RESULTS : COMMON);
        if (isUserSearch) {
            matchCounts.add(0);
        }
        this.myPalette.accept(new Palette.Visitor(){
            private Palette.Group currentGroup;
            private int matchCount;
            {
                this.currentGroup = isUserSearch ? RESULTS : COMMON;
            }

            @Override
            public void visit(@NotNull Palette.Group group) {
                if (group == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.currentGroup = group;
                this.matchCount = 0;
            }

            @Override
            public void visit(@NotNull Palette.Item item) {
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.currentGroup.equals(item.getParent()) && DataModel.this.myFilterCondition.value((Object)item)) {
                    ++this.matchCount;
                }
            }

            @Override
            public void visitAfter(@NotNull Palette.Group group) {
                if (group == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.matchCount > 0) {
                    groups.add(group);
                    if (isUserSearch) {
                        matchCounts.add(this.matchCount);
                        matchCounts.set(0, (Integer)matchCounts.get(0) + this.matchCount);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette2/DataModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAfter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.updateCategoryModel(groups, matchCounts);
    }

    private void onDependenciesChanged() {
        this.update();
        this.categorySelectionChanged(this.myCurrentSelectedGroup);
    }

    private void updateCategoryModel(@NotNull List<Palette.Group> groups, @NotNull List<Integer> matchCounts) {
        if (groups == null) {
            DataModel.$$$reportNull$$$0(12);
        }
        if (matchCounts == null) {
            DataModel.$$$reportNull$$$0(13);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.myListModel.update(groups, matchCounts));
    }

    private void createFilteredItems(@NotNull Palette.Group selectedGroup) {
        if (selectedGroup == null) {
            DataModel.$$$reportNull$$$0(14);
        }
        ArrayList<Palette.Item> items2 = new ArrayList<Palette.Item>();
        Palette.Visitor visitor = item -> {
            if (this.myFilterCondition.value((Object)item)) {
                items2.add(item);
            }
        };
        if (selectedGroup != COMMON && selectedGroup != RESULTS) {
            selectedGroup.accept(visitor);
        } else if (this.myListModel.getSize() <= 1 || selectedGroup == RESULTS) {
            this.myPalette.accept(visitor);
        } else {
            for (String id : this.myFavoriteItems) {
                Palette.Item item2 = this.myPalette.getItemById(id);
                if (item2 == null) continue;
                visitor.visit(item2);
            }
        }
        this.updateItemModel(items2);
    }

    private void updateItemModel(@NotNull List<Palette.Item> items2) {
        if (items2 == null) {
            DataModel.$$$reportNull$$$0(15);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.myItemModel.update(items2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyManager";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette2/DataModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedGroup";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchCounts";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette2/DataModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategoryListModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemListModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPalette";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readFavoriteItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setLayoutType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFilterPattern";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "categorySelectionChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFavoriteItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFavoriteItem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFavoriteItem";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateCategoryModel";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFilteredItems";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateItemModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

