/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline.utils;

import com.android.tools.idea.uibuilder.handlers.motion.timeline.utils.LinearCurveFit;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.utils.MonotonicCurveFit;

public abstract class CurveFit {
    public static final int SPLINE = 0;
    public static final int LINEAR = 1;
    public static final int CONSTANT = 2;

    public static CurveFit get(int type, double[] time2, double[][] y) {
        if (time2.length == 1) {
            type = 2;
        }
        switch (type) {
            case 0: {
                return new MonotonicCurveFit(time2, y);
            }
            case 2: {
                return new Constant(time2[0], y[0]);
            }
        }
        return new LinearCurveFit(time2, y);
    }

    public abstract void getPos(double var1, double[] var3);

    public abstract void getPos(double var1, float[] var3);

    public abstract double getPos(double var1, int var3);

    public abstract void getSlope(double var1, double[] var3);

    public abstract double getSlope(double var1, int var3);

    public abstract double[] getTimePoints();

    static class Constant
    extends CurveFit {
        double mTime;
        double[] mValue;

        Constant(double time2, double[] value2) {
            this.mTime = time2;
            this.mValue = value2;
        }

        @Override
        public void getPos(double t, double[] v) {
            System.arraycopy(this.mValue, 0, v, 0, this.mValue.length);
        }

        @Override
        public void getPos(double t, float[] v) {
            for (int i2 = 0; i2 < this.mValue.length; ++i2) {
                v[i2] = (float)this.mValue[i2];
            }
        }

        @Override
        public double getPos(double t, int j) {
            return this.mValue[j];
        }

        @Override
        public void getSlope(double t, double[] v) {
            for (int i2 = 0; i2 < this.mValue.length; ++i2) {
                v[i2] = 0.0;
            }
        }

        @Override
        public double getSlope(double t, int j) {
            return 0.0;
        }

        @Override
        public double[] getTimePoints() {
            return new double[]{this.mTime};
        }
    }
}

