/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property2.api.PropertiesModel;
import com.android.tools.idea.common.property2.api.PropertiesModelListener;
import com.android.tools.idea.common.property2.api.PropertiesTable;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutPropertyProvider;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionPropertyItem;
import com.android.tools.idea.uibuilder.handlers.motion.property2.TimelineListener;
import com.android.tools.idea.uibuilder.handlers.motion.property2.TimelineOwner;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutAttributesModel
implements PropertiesModel<MotionPropertyItem>,
Disposable {
    private final List<PropertiesModelListener> myListeners;
    private final MotionLayoutPropertyProvider myPropertyProvider;
    private DesignSurface mySurface;
    private DesignSurfaceListener mySurfaceListener;
    private TimelineOwner myTimeline;
    private TimelineListener myTimelineListener;
    private PropertiesTable<MotionPropertyItem> myPropertiesTable;

    public MotionLayoutAttributesModel(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MotionLayoutAttributesModel.$$$reportNull$$$0(0);
        }
        this.myListeners = new ArrayList<PropertiesModelListener>();
        this.myPropertyProvider = new MotionLayoutPropertyProvider();
        this.myPropertiesTable = PropertiesTable.Companion.emptyTable();
        this.mySurfaceListener = new PropertiesDesignSurfaceListener();
        this.myTimelineListener = new PropertiesTimelineListener();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void dispose() {
        this.setSurface(null);
        this.setTimeline(null);
    }

    @Nullable
    public DesignSurface getSurface() {
        return this.mySurface;
    }

    public void setSurface(@Nullable DesignSurface surface) {
        if (surface == this.mySurface) {
            return;
        }
        if (this.mySurface != null) {
            this.mySurface.removeListener(this.mySurfaceListener);
        }
        this.mySurface = surface;
        if (this.mySurface != null) {
            this.mySurface.addListener(this.mySurfaceListener);
        }
    }

    private void setTimeline(@Nullable TimelineOwner timeline) {
        if (timeline == this.myTimeline) {
            return;
        }
        if (this.myTimeline != null) {
            this.myTimeline.removeTimeLineListener(this.myTimelineListener);
        }
        this.myTimeline = timeline;
        if (this.myTimeline != null) {
            this.myTimeline.addTimelineListener(this.myTimelineListener);
        }
    }

    @Override
    @NotNull
    public PropertiesTable<MotionPropertyItem> getProperties() {
        PropertiesTable<MotionPropertyItem> propertiesTable = this.myPropertiesTable;
        if (propertiesTable == null) {
            MotionLayoutAttributesModel.$$$reportNull$$$0(1);
        }
        return propertiesTable;
    }

    @Override
    public void deactivate() {
        this.myPropertiesTable = PropertiesTable.Companion.emptyTable();
    }

    @Override
    public void addListener(@NotNull PropertiesModelListener listener2) {
        if (listener2 == null) {
            MotionLayoutAttributesModel.$$$reportNull$$$0(2);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull PropertiesModelListener listener2) {
        if (listener2 == null) {
            MotionLayoutAttributesModel.$$$reportNull$$$0(3);
        }
        this.myListeners.remove(listener2);
    }

    private void designSelectionUpdate(@NotNull DesignSurface surface, @NotNull List<NlComponent> selection) {
        if (surface == null) {
            MotionLayoutAttributesModel.$$$reportNull$$$0(4);
        }
        if (selection == null) {
            MotionLayoutAttributesModel.$$$reportNull$$$0(5);
        }
        if (surface != this.mySurface) {
            return;
        }
        if (selection.isEmpty()) {
            this.setTimeline(null);
            return;
        }
        NlComponent component = selection.get(0);
        Object property2 = component.getClientProperty("Timeline");
        if (property2 instanceof TimelineOwner) {
            this.setTimeline((TimelineOwner)property2);
            return;
        }
        NlComponent parent = component.getParent();
        Object object = property2 = parent != null ? parent.getClientProperty("Timeline") : null;
        if (property2 instanceof TimelineOwner) {
            this.setTimeline((TimelineOwner)property2);
        } else {
            this.setTimeline(null);
        }
    }

    private void displayKeyFrame(@Nullable MotionSceneModel.KeyFrame keyFrame) {
        if (keyFrame != null) {
            this.myPropertiesTable = this.myPropertyProvider.getProperties(keyFrame);
            this.myListeners.forEach(listener2 -> listener2.propertiesGenerated(this));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/property2/MotionLayoutAttributesModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/property2/MotionLayoutAttributesModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "designSelectionUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PropertiesTimelineListener
    implements TimelineListener {
        private PropertiesTimelineListener() {
        }

        @Override
        public void updateSelection(@Nullable MotionSceneModel.KeyFrame keyFrame) {
            MotionLayoutAttributesModel.this.displayKeyFrame(keyFrame);
        }
    }

    private class PropertiesDesignSurfaceListener
    implements DesignSurfaceListener {
        private PropertiesDesignSurfaceListener() {
        }

        @Override
        public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
            if (surface == null) {
                PropertiesDesignSurfaceListener.$$$reportNull$$$0(0);
            }
            if (newSelection == null) {
                PropertiesDesignSurfaceListener.$$$reportNull$$$0(1);
            }
            MotionLayoutAttributesModel.this.designSelectionUpdate(surface, newSelection);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "surface";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newSelection";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/handlers/motion/property2/MotionLayoutAttributesModel$PropertiesDesignSurfaceListener";
            objectArray[2] = "componentSelectionChanged";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

