/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.attributeEditor;

import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.CustomAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.EasingCurve;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.EditorUtils;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.NewCustomAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.TagPanel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TimeLineIcons;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class AttributeTagPanel
extends TagPanel {
    public KeyAttrTableModel myKeyAttrTableModel = new KeyAttrTableModel();
    MotionSceneModel.KeyFrame myKeyframe;
    JBPopupMenu myPopupMenu = new JBPopupMenu("Add Attribute");
    ArrayList<CustomAttributePanel> myCustomAttributePanels = new ArrayList();
    GridBagConstraints gbc = new GridBagConstraints();
    public HashMap<EditorUtils.AttributesNamesHolder, Object> myAttributes;
    public ArrayList<EditorUtils.AttributesNamesHolder> myAttributesNames;
    EasingCurve myEasingCurve;
    public ActionListener myAddItemAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = ((JMenuItem)e.getSource()).getText();
            if ("Custom...".equals(s)) {
                NewCustomAttributePanel newAttributePanel = new NewCustomAttributePanel();
                newAttributePanel.show();
                if (newAttributePanel.isOK()) {
                    String attributeName = newAttributePanel.getAttributeName();
                    String value2 = newAttributePanel.getInitialValue();
                    MotionSceneModel.CustomAttributes.Type type = newAttributePanel.getType();
                    if (StringUtil.isNotEmpty((String)attributeName)) {
                        AttributeTagPanel.this.myKeyframe.createCustomAttribute(attributeName, type, value2);
                    }
                }
                return;
            }
            EditorUtils.AttributesNamesHolder holder = new EditorUtils.AttributesNamesHolder(s);
            String[] def = AttributeTagPanel.this.myKeyframe.getDefault(s);
            String value3 = def != null && def.length > 0 ? def[0] : "";
            AttributeTagPanel.this.myKeyframe.setValue(s, value3);
            AttributeTagPanel.this.myAttributes.put(holder, value3);
            AttributeTagPanel.this.myAttributesNames.add(holder);
            AttributeTagPanel.this.myKeyAttrTableModel.fireTableRowsInserted(AttributeTagPanel.this.myAttributesNames.size() - 1, AttributeTagPanel.this.myAttributesNames.size());
        }
    };

    public AttributeTagPanel(MotionLayoutAttributePanel panel2) {
        super(panel2);
        this.myBasePanel = panel2;
        this.myTable = new JBTable((TableModel)this.myKeyAttrTableModel);
        this.myRemoveTagButton = EditorUtils.makeButton(TimeLineIcons.REMOVE_TAG);
        this.setup();
        this.myTable.setSelectionMode(0);
        this.myTable.setDefaultRenderer(EditorUtils.AttributesNamesHolder.class, new EditorUtils.AttributesNamesCellRenderer());
        this.myTable.setDefaultRenderer(String.class, new EditorUtils.AttributesValueCellRenderer());
        this.myPopupMenu.add(new JMenuItem("test1"));
        this.myAddRemovePanel.myAddButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AttributeTagPanel.this.myPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.myAddRemovePanel.myRemoveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AttributeTagPanel.this.deleteAttr(AttributeTagPanel.this.myTable.getSelectedRow());
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 2;
        this.gbc.fill = 1;
        this.add((Component)this.myTitle, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.weightx = 0.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 13;
        this.add((Component)this.myRemoveTagButton, this.gbc);
        this.gbc.gridwidth = 2;
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 1;
        this.add((Component)this.myTable, this.gbc);
        ++this.gbc.gridy;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.add((Component)this.myAddRemovePanel, this.gbc);
    }

    @Override
    protected void deleteAttr(int selection) {
        if (this.myKeyframe.deleteAttribute(this.myKeyAttrTableModel.getValueAt(selection, 0).toString())) {
            this.myKeyAttrTableModel.removeRow(selection);
        }
    }

    @Override
    protected void deleteTag() {
        if (this.myKeyframe.deleteTag()) {
            this.setVisible(false);
            this.myBasePanel.clearSelectedKeyframe();
        }
    }

    private void setupPopup(MotionSceneModel.KeyFrame keyframe) {
        this.myPopupMenu.removeAll();
        String[] names = keyframe.getPossibleAttr();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        keyframe.fill(attributes);
        Set<String> keys = attributes.keySet();
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (keys.contains(names[i2])) continue;
            JMenuItem menuItem = new JMenuItem(names[i2]);
            menuItem.addActionListener(this.myAddItemAction);
            this.myPopupMenu.add(menuItem);
        }
    }

    private void setEasing(String points) {
        for (int i2 = 0; i2 < this.myAttributesNames.size(); ++i2) {
            if (!"transitionEasing".equals(this.myAttributesNames.get(i2).toString())) continue;
            this.myAttributes.put(this.myAttributesNames.get(i2), points);
            this.myKeyAttrTableModel.fireTableCellUpdated(i2, 1);
        }
    }

    private void saveEasing(String value2) {
        this.myBasePanel.myCurrentKeyframe.setValue("transitionEasing", value2);
    }

    public void setKeyFrame(MotionSceneModel.KeyFrame keyframe) {
        String easing;
        this.myKeyAttrTableModel.setKeyFrame(keyframe);
        this.myAddRemovePanel.myAddButton.setVisible(keyframe != null);
        this.setVisible(keyframe != null);
        if (keyframe == null) {
            return;
        }
        this.setupPopup(keyframe);
        if (this.myEasingCurve != null) {
            this.remove(this.myEasingCurve);
            this.myEasingCurve = null;
        }
        if ((easing = keyframe.getEasingCurve()) != null) {
            this.myEasingCurve = new EasingCurve();
            this.myEasingCurve.setControlPoints(easing);
            this.myEasingCurve.setPreferredSize(new Dimension(200, JBUI.scale((int)200)));
            this.myEasingCurve.addActionListener(e -> this.setEasing(this.myEasingCurve.getControlPoints()));
            this.myEasingCurve.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    AttributeTagPanel.this.saveEasing(AttributeTagPanel.this.myEasingCurve.getControlPoints());
                }
            });
            ++this.gbc.gridy;
            this.gbc.gridwidth = 2;
            this.gbc.fill = 1;
            this.add((Component)this.myEasingCurve, this.gbc);
        }
        for (CustomAttributePanel panel2 : this.myCustomAttributePanels) {
            this.remove(panel2);
        }
        if (keyframe instanceof MotionSceneModel.KeyAttributes) {
            MotionSceneModel.KeyAttributes ka = (MotionSceneModel.KeyAttributes)keyframe;
            for (MotionSceneModel.CustomAttributes attributes : ka.getCustomAttributes()) {
                CustomAttributePanel cap = new CustomAttributePanel(this.myBasePanel);
                cap.setTag(attributes);
                this.myCustomAttributePanels.add(cap);
                ++this.gbc.gridy;
                this.gbc.gridwidth = 2;
                this.gbc.fill = 1;
                this.add((Component)cap, this.gbc);
            }
        }
    }

    class KeyAttrTableModel
    extends AbstractTableModel {
        KeyAttrTableModel() {
        }

        @Override
        public int getRowCount() {
            if (AttributeTagPanel.this.myAttributes == null) {
                return 0;
            }
            return AttributeTagPanel.this.myAttributes.size();
        }

        public void removeRow(int rowIndex) {
            if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
                throw new ArrayIndexOutOfBoundsException(rowIndex);
            }
            EditorUtils.AttributesNamesHolder holder = AttributeTagPanel.this.myAttributesNames.get(rowIndex);
            AttributeTagPanel.this.myAttributesNames.remove(rowIndex);
            AttributeTagPanel.this.myAttributes.remove(holder);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Name" : "Value";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 1 ? String.class : EditorUtils.AttributesNamesHolder.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (AttributeTagPanel.this.myAttributesNames == null || AttributeTagPanel.this.myAttributes.size() < rowIndex) {
                return null;
            }
            if (columnIndex == 0) {
                return AttributeTagPanel.this.myAttributesNames.get(rowIndex);
            }
            return AttributeTagPanel.this.myAttributes.get(AttributeTagPanel.this.myAttributesNames.get(rowIndex));
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            AttributeTagPanel.this.myAttributes.put(AttributeTagPanel.this.myAttributesNames.get(rowIndex), aValue);
            if (AttributeTagPanel.this.myBasePanel.myCurrentKeyframe == null) {
                return;
            }
            String key = this.getValueAt(rowIndex, 0).toString();
            AttributeTagPanel.this.myBasePanel.myCurrentKeyframe.setValue(key, aValue.toString());
        }

        public void setKeyFrame(MotionSceneModel.KeyFrame keyframe) {
            AttributeTagPanel.this.myKeyframe = keyframe;
            if (AttributeTagPanel.this.myAttributes == null) {
                AttributeTagPanel.this.myAttributes = new HashMap();
                AttributeTagPanel.this.myAttributesNames = new ArrayList();
            } else {
                AttributeTagPanel.this.myAttributes.clear();
                AttributeTagPanel.this.myAttributesNames.clear();
            }
            if (keyframe != null) {
                String name;
                HashMap<String, Object> tmp = new HashMap<String, Object>();
                keyframe.fill(tmp);
                ArrayList<String> attributesNames = new ArrayList<String>(tmp.keySet());
                attributesNames.sort(EditorUtils.compareAttributes);
                for (String s : attributesNames) {
                    EditorUtils.AttributesNamesHolder holder = new EditorUtils.AttributesNamesHolder(s);
                    AttributeTagPanel.this.myAttributesNames.add(holder);
                    AttributeTagPanel.this.myAttributes.put(holder, tmp.get(s));
                }
                switch (name = keyframe.getName()) {
                    case "KeyCycle": {
                        name = "Cycle";
                        break;
                    }
                    case "KeyAttribute": {
                        name = "Attributes";
                        break;
                    }
                    case "KeyPosition": {
                        name = "Position";
                    }
                }
                AttributeTagPanel.this.myTitle.setText(name);
            }
            this.fireTableDataChanged();
        }
    }
}

