/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintSceneInteraction;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentDelegate;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutTimelinePanel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

class MotionLayoutSceneInteraction
extends ConstraintSceneInteraction {
    private NlComponent myPrimary;
    int startX;
    int startY;
    NlComponent selected;
    private MotionLayoutComponentHelper myMotionHelper;
    private Object myKeyframe;

    public MotionLayoutSceneInteraction(@NotNull SceneView sceneView, @NotNull NlComponent primary) {
        if (sceneView == null) {
            MotionLayoutSceneInteraction.$$$reportNull$$$0(0);
        }
        if (primary == null) {
            MotionLayoutSceneInteraction.$$$reportNull$$$0(1);
        }
        super(sceneView, primary);
        this.myPrimary = primary;
        if (primary.getParent() != null) {
            this.myPrimary = this.myPrimary.getParent();
        }
    }

    private void useComponent(@NotNull NlComponent component) {
        if (component == null) {
            MotionLayoutSceneInteraction.$$$reportNull$$$0(2);
        }
        this.selected = component;
        NlComponent transitionLayoutComponent = null;
        if (NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.MOTION_LAYOUT)) {
            transitionLayoutComponent = component;
        } else {
            NlComponent parent = this.selected.getParent();
            if (parent != null && NlComponentHelperKt.isOrHasSuperclass(parent, SdkConstants.MOTION_LAYOUT)) {
                transitionLayoutComponent = parent;
            }
        }
        this.myMotionHelper = transitionLayoutComponent != null ? new MotionLayoutComponentHelper(transitionLayoutComponent) : null;
    }

    MotionLayoutTimelinePanel.State getState() {
        MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(this.myPrimary);
        if (panel2 != null) {
            if (panel2.getCurrentState() == MotionLayoutTimelinePanel.State.TL_UNKNOWN) {
                panel2.updateState();
            }
            return panel2.getCurrentState();
        }
        return MotionLayoutTimelinePanel.State.TL_UNKNOWN;
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int startMask) {
        this.myKeyframe = null;
        if (this.getState() == MotionLayoutTimelinePanel.State.TL_TRANSITION) {
            NlComponent component;
            this.selected = component = Coordinates.findComponent(this.mySceneView, x, y);
            if (component != null) {
                this.mySceneView.getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)component));
                this.useComponent(component);
                MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(this.selected);
                MotionSceneModel.KeyFrame keyFrame = panel2.getSelectedKeyframe();
                if (keyFrame != null) {
                    ResourceReference reference2;
                    ResourceIdManager manager = ResourceIdManager.get(component.getModel().getModule());
                    Integer resolved = manager.getCompiledId(reference2 = new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, component.getId()));
                    if (resolved == null && component.getDelegate() != null && component.getDelegate() instanceof MotionLayoutComponentDelegate) {
                        ((MotionLayoutComponentDelegate)component.getDelegate()).updateIds(component);
                        reference2 = new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, component.getId());
                        resolved = manager.getOrGenerateId(reference2);
                    }
                    this.myKeyframe = this.myMotionHelper.getKeyframe(2, resolved, keyFrame.getFramePosition());
                } else {
                    Object view = NlComponentHelperKt.getViewInfo(this.selected).getViewObject();
                    float fx = Coordinates.getAndroidX(this.mySceneView, x);
                    float fy = Coordinates.getAndroidY(this.mySceneView, y);
                    this.myKeyframe = this.myMotionHelper.getKeyframeAtLocation(view, fx, fy);
                }
                if (this.myKeyframe != null) {
                    float progress = (float)keyFrame.getFramePosition() / 100.0f;
                    panel2.setTimelineProgress(progress);
                }
            }
            this.startX = x;
            this.startY = y;
        } else {
            super.begin(x, y, startMask);
        }
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        if (this.getState() == MotionLayoutTimelinePanel.State.TL_TRANSITION) {
            if (this.selected != null && this.myKeyframe != null) {
                String[] positionAttributes = new String[]{"percentX", "percentY"};
                float[] positionsValues = new float[2];
                ViewInfo info = NlComponentHelperKt.getViewInfo(this.selected);
                if (info != null) {
                    float fx = Coordinates.getAndroidX(this.mySceneView, x);
                    float fy = Coordinates.getAndroidY(this.mySceneView, y);
                    Object view = info.getViewObject();
                    if (this.myMotionHelper.getPositionKeyframe(this.myKeyframe, view, fx, fy, positionAttributes, positionsValues)) {
                        this.myMotionHelper.setKeyframe(this.myKeyframe, positionAttributes[0], Float.valueOf(positionsValues[0]));
                        this.myMotionHelper.setKeyframe(this.myKeyframe, positionAttributes[1], Float.valueOf(positionsValues[1]));
                        this.myMotionHelper.setKeyframe(this.myKeyframe, "drawPath", 4);
                        this.myPrimary.getModel().notifyLiveUpdate(false);
                    }
                }
            }
        } else {
            super.update(x, y, modifiers);
        }
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean canceled) {
        if (this.getState() == MotionLayoutTimelinePanel.State.TL_TRANSITION) {
            if (this.selected != null && this.myKeyframe != null) {
                MotionLayoutTimelinePanel panel2 = MotionLayoutHandler.getTimeline(this.selected);
                ViewInfo info = NlComponentHelperKt.getViewInfo(this.selected);
                if (info != null) {
                    float[] positionsValues;
                    String[] positionAttributes;
                    float fx = Coordinates.getAndroidX(this.mySceneView, x);
                    float fy = Coordinates.getAndroidY(this.mySceneView, y);
                    Object view = info.getViewObject();
                    if (this.myMotionHelper.getPositionKeyframe(this.myKeyframe, view, fx, fy, positionAttributes = new String[]{"percentX", "percentY"}, positionsValues = new float[2])) {
                        HashMap<String, String> values2 = new HashMap<String, String>();
                        values2.put(positionAttributes[0], Float.toString(positionsValues[0]));
                        values2.put(positionAttributes[1], Float.toString(positionsValues[1]));
                        panel2.setKeyframeAttributes(values2);
                    }
                }
            }
        } else {
            super.end(x, y, modifiers, canceled);
        }
        this.myKeyframe = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/MotionLayoutSceneInteraction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "useComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

