/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.targets;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.NonPlaceholderDragTarget;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.uibuilder.handlers.linear.draw.DrawLinearPlaceholder;
import com.android.tools.idea.uibuilder.handlers.linear.draw.DrawLinearSeparator;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.google.common.collect.ImmutableList;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearSeparatorTarget
extends BaseTarget
implements Notch.Provider,
NonPlaceholderDragTarget {
    private static final boolean DEBUG = false;
    private final boolean myLayoutVertical;
    private final boolean myAtEnd;
    private boolean myIsHighlight;
    private int myHighLightSize;
    @Nullable
    private SceneComponent myParent;
    private boolean myCanDisplayPlaceholderAfter;

    public LinearSeparatorTarget(boolean layoutVertical, boolean atEnd) {
        this.myLayoutVertical = layoutVertical;
        this.myAtEnd = atEnd;
    }

    @Override
    public int getPreferenceLevel() {
        return 30;
    }

    @Override
    public boolean layout(@NotNull SceneContext context, int l, int t, int r, int b) {
        if (context == null) {
            LinearSeparatorTarget.$$$reportNull$$$0(0);
        }
        this.myParent = this.myComponent.getParent();
        assert (this.myParent != null) : "This target cannot be added to a root component";
        NlComponent nlComponent = this.myComponent.getNlComponent();
        if (this.myLayoutVertical) {
            int parentMin = this.myParent.getDrawY() + 1;
            int parentMax = parentMin + this.myParent.getDrawHeight() - 2;
            this.myLeft = this.myParent.getDrawX();
            this.myRight = this.myLeft + (float)this.myParent.getDrawWidth();
            float y = context.pxToDp(NlComponentHelperKt.getY(nlComponent)) + (this.myAtEnd ? context.pxToDp(NlComponentHelperKt.getH(nlComponent)) : 0.0f);
            this.myTop = this.myBottom = Math.max((float)parentMin, Math.min((float)parentMax, y));
            this.myCanDisplayPlaceholderAfter = this.myComponent.getDrawY() + this.myComponent.getDrawHeight() < parentMax;
        } else {
            int parentMin = this.myParent.getDrawX() + 1;
            int parentMax = parentMin + this.myParent.getDrawWidth() - 2;
            float x = context.pxToDp(NlComponentHelperKt.getX(nlComponent)) + (this.myAtEnd ? context.pxToDp(NlComponentHelperKt.getW(nlComponent)) : 0.0f);
            this.myLeft = this.myRight = Math.max((float)parentMin, Math.min((float)parentMax, x));
            this.myTop = this.myParent.getDrawY();
            this.myBottom = this.myTop + (float)this.myParent.getDrawHeight();
            this.myCanDisplayPlaceholderAfter = this.myComponent.getDrawX() + this.myComponent.getDrawWidth() < parentMax;
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            LinearSeparatorTarget.$$$reportNull$$$0(1);
        }
        if (sceneContext == null) {
            LinearSeparatorTarget.$$$reportNull$$$0(2);
        }
        if (this.myComponent.isDragging() || this.myParent == null) {
            return;
        }
        if (this.myIsHighlight) {
            DrawLinearPlaceholder.add(list, sceneContext, this.myLayoutVertical, this.myAtEnd && this.myCanDisplayPlaceholderAfter, this.myHighLightSize, this.myLeft, this.myTop, this.myRight, this.myBottom);
        } else {
            DrawLinearSeparator.add(list, sceneContext, this.myLayoutVertical, this.myLeft, this.myTop, this.myRight, this.myBottom);
        }
    }

    @Override
    public void addHit(@NotNull SceneContext transform2, @NotNull ScenePicker picker) {
        if (transform2 == null) {
            LinearSeparatorTarget.$$$reportNull$$$0(3);
        }
        if (picker == null) {
            LinearSeparatorTarget.$$$reportNull$$$0(4);
        }
        picker.addRect(this, 10, transform2.getSwingXDip(this.myLeft), transform2.getSwingYDip(this.myTop), transform2.getSwingXDip(this.myRight) + 1, transform2.getSwingYDip(this.myBottom) + 1);
    }

    private void drawDebug(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            LinearSeparatorTarget.$$$reportNull$$$0(5);
        }
        if (sceneContext == null) {
            LinearSeparatorTarget.$$$reportNull$$$0(6);
        }
        list.addLine(sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, (Color)(this.myIsHighlight ? JBColor.GREEN : JBColor.RED));
        list.addLine(sceneContext, this.myLeft, this.myBottom, this.myRight, this.myTop, (Color)(this.myIsHighlight ? JBColor.GREEN : JBColor.RED));
        if (this.myLayoutVertical) {
            list.addRect(sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom + (float)this.myHighLightSize, JBColor.MAGENTA);
        } else {
            list.addRect(sceneContext, this.myLeft, this.myTop, this.myRight + (float)this.myHighLightSize, this.myBottom, JBColor.MAGENTA);
        }
    }

    public void setHighlight(boolean isHighlight) {
        this.setHighlight(isHighlight, 5, 5);
    }

    public void setHighlight(boolean isHighlight, int width, int height) {
        this.myIsHighlight = isHighlight;
        this.myHighLightSize = this.myLayoutVertical ? height : width;
    }

    public boolean isAtEnd() {
        return this.myAtEnd;
    }

    @Override
    public void fill(@NotNull SceneComponent owner, @NotNull SceneComponent snappableComponent, @NotNull ImmutableList.Builder<Notch> notchesBuilder) {
        if (owner == null) {
            LinearSeparatorTarget.$$$reportNull$$$0(7);
        }
        if (snappableComponent == null) {
            LinearSeparatorTarget.$$$reportNull$$$0(8);
        }
        if (notchesBuilder == null) {
            LinearSeparatorTarget.$$$reportNull$$$0(9);
        }
        if (this.myLayoutVertical) {
            int value2 = owner.getDrawY();
            int displayValue = owner.getDrawY();
            if (this.myAtEnd) {
                if (this.myCanDisplayPlaceholderAfter) {
                    value2 += owner.getDrawHeight();
                    displayValue += owner.getDrawHeight();
                } else {
                    value2 += owner.getDrawHeight() - snappableComponent.getDrawHeight() / 2;
                    displayValue += owner.getDrawHeight() - snappableComponent.getDrawHeight() / 2;
                }
            } else {
                value2 = (int)((float)value2 - ((float)snappableComponent.getDrawHeight() / 2.0f + 0.5f));
            }
            Notch.Vertical notch2 = new Notch.Vertical(owner, value2, displayValue);
            notch2.setGap(owner.getDrawHeight() / 2);
            notch2.setTarget(this);
            notchesBuilder.add((Object)notch2);
        } else {
            int value3 = owner.getDrawX();
            int displayValue = owner.getDrawX();
            if (this.myAtEnd) {
                if (this.myCanDisplayPlaceholderAfter) {
                    value3 += owner.getDrawWidth();
                    displayValue += owner.getDrawWidth();
                } else {
                    value3 += owner.getDrawWidth() - snappableComponent.getDrawWidth() / 2;
                    displayValue += owner.getDrawWidth() - snappableComponent.getDrawWidth() / 2;
                }
            } else {
                value3 = (int)((float)value3 - ((float)snappableComponent.getDrawWidth() / 2.0f + 0.5f));
            }
            Notch.Horizontal notch3 = new Notch.Horizontal(owner, value3, displayValue);
            notch3.setGap(owner.getDrawWidth() / 2);
            notch3.setTarget(this);
            notchesBuilder.add((Object)notch3);
        }
    }

    public int getInsertionIndex() {
        NlComponent parent;
        NlComponent before = !this.isAtEnd() ? this.myComponent.getNlComponent() : null;
        NlComponent nlComponent = parent = before != null ? before.getParent() : null;
        if (parent != null) {
            return parent.getChildren().indexOf(before);
        }
        return -1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " highlighted: " + this.myIsHighlight + " vertical: " + this.myLayoutVertical;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snappableComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notchesBuilder";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/linear/targets/LinearSeparatorTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addHit";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "drawDebug";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fill";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

