/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.grid.CellInfo;
import com.android.tools.idea.uibuilder.handlers.grid.GridBarriers;
import com.android.tools.idea.uibuilder.handlers.grid.InsetsAttributes;
import com.android.tools.idea.uibuilder.model.Insets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000e*\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"MARGIN_ATTRIBUTES", "Lcom/android/tools/idea/uibuilder/handlers/grid/InsetsAttributes;", "PADDING_ATTRIBUTES", "UNDEFINED_COLUMN", "", "UNDEFINED_ROW", "getGridBarriers", "Lcom/android/tools/idea/uibuilder/handlers/grid/GridBarriers;", "gridComponent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "getPxValue", "nlComponent", "Lcom/android/tools/idea/common/model/NlComponent;", "value", "", "retrieveCellData", "Lcom/android/tools/idea/uibuilder/handlers/grid/CellInfo;", "isSupportLibrary", "", "retrieveInsets", "Lcom/android/tools/idea/uibuilder/model/Insets;", "attrs", "retrieveMargins", "retrievePaddings", "getLiveAndroidAttribute", "androidAttribute", "intellij.android.designer"})
public final class GridUtilsKt {
    private static final int UNDEFINED_ROW = -1;
    private static final int UNDEFINED_COLUMN = -1;
    private static final InsetsAttributes PADDING_ATTRIBUTES = new InsetsAttributes("padding", (Pair<String, String>)new Pair((Object)"paddingStart", (Object)"paddingLeft"), "paddingTop", (Pair<String, String>)new Pair((Object)"paddingEnd", (Object)"paddingRight"), "paddingBottom");
    private static final InsetsAttributes MARGIN_ATTRIBUTES = new InsetsAttributes("layout_margin", (Pair<String, String>)new Pair((Object)"layout_marginStart", (Object)"layout_marginLeft"), "layout_marginTop", (Pair<String, String>)new Pair((Object)"layout_marginEnd", (Object)"layout_marginRight"), "layout_marginBottom");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GridBarriers getGridBarriers(@NotNull SceneComponent gridComponent) {
        Integer n;
        Integer[] integerArray;
        void var26_43;
        int cellBottom;
        int cellRight;
        int cellTop;
        Object marginInsets;
        Object cellData;
        Intrinsics.checkParameterIsNotNull((Object)gridComponent, (String)"gridComponent");
        NlComponent nlComponent = gridComponent.getNlComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent, (String)"gridComponent.nlComponent");
        boolean isSupportLibrary = SdkConstants.GRID_LAYOUT_V7.isEquals(nlComponent.getTagName());
        Function1<Integer, Integer> toDp$ = new Function1<Integer, Integer>(gridComponent){
            final /* synthetic */ SceneComponent $gridComponent;

            public final int invoke(int $receiver) {
                Scene scene = this.$gridComponent.getScene();
                Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"gridComponent.scene");
                return Coordinates.pxToDp(scene.getDesignSurface(), $receiver);
            }
            {
                this.$gridComponent = sceneComponent;
                super(1);
            }
        };
        NlComponent nlComponent2 = gridComponent.getAuthoritativeNlComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent2, (String)"gridComponent.authoritativeNlComponent");
        Insets padding = GridUtilsKt.retrievePaddings(nlComponent2);
        int left = gridComponent.getDrawX() + toDp$.invoke(padding.left);
        int top = gridComponent.getDrawY() + toDp$.invoke(padding.top);
        int right = gridComponent.getDrawX() + gridComponent.getDrawWidth() - toDp$.invoke(padding.right);
        int bottom = gridComponent.getDrawY() + gridComponent.getDrawHeight() - toDp$.invoke(padding.bottom);
        List<SceneComponent> children = gridComponent.getChildren();
        HashMap rowMap = new HashMap();
        HashMap columnMap = new HashMap();
        int previousRow = 0;
        int previousColumn = -1;
        Iterator<SceneComponent> iterator = children.iterator();
        while (iterator.hasNext()) {
            Integer n2;
            Integer n3;
            Object object;
            Map map2;
            SceneComponent child;
            SceneComponent sceneComponent = child = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"child");
            NlComponent nlComponent3 = sceneComponent.getAuthoritativeNlComponent();
            Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent3, (String)"child.authoritativeNlComponent");
            cellData = GridUtilsKt.retrieveCellData(nlComponent3, isSupportLibrary);
            if (((CellInfo)cellData).getColumn() == -1) {
                ((CellInfo)cellData).setColumn(previousColumn + 1);
            }
            if (((CellInfo)cellData).getRow() == -1) {
                ((CellInfo)cellData).setRow(previousRow);
            }
            NlComponent nlComponent4 = child.getAuthoritativeNlComponent();
            Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent4, (String)"child.authoritativeNlComponent");
            marginInsets = GridUtilsKt.retrieveMargins(nlComponent4);
            int cellLeft = child.getDrawX() - toDp$.invoke(((Insets)marginInsets).left);
            cellTop = child.getDrawY() - toDp$.invoke(((Insets)marginInsets).top);
            cellRight = child.getDrawX() + child.getDrawWidth() + toDp$.invoke(((Insets)marginInsets).right);
            cellBottom = child.getDrawY() + child.getDrawHeight() + toDp$.invoke(((Insets)marginInsets).bottom);
            if (((CellInfo)cellData).getColumn() != 0) {
                map2 = columnMap;
                object = ((CellInfo)cellData).getColumn();
                Integer n4 = (Integer)columnMap.get(((CellInfo)cellData).getColumn());
                if (n4 == null) {
                    n4 = Integer.MAX_VALUE;
                }
                int n5 = n4;
                n3 = Math.min(cellLeft, n5);
                map2.put(object, n3);
            }
            if (((CellInfo)cellData).getRow() != 0) {
                map2 = rowMap;
                object = ((CellInfo)cellData).getRow();
                Integer n6 = (Integer)rowMap.get(((CellInfo)cellData).getRow());
                if (n6 == null) {
                    n6 = Integer.MAX_VALUE;
                }
                int n7 = n6;
                n3 = Math.min(cellTop, n7);
                map2.put(object, n3);
            }
            if (((CellInfo)cellData).getColumn() != -1 && ((CellInfo)cellData).getColumnSpan() != 0) {
                int rightIndex = ((CellInfo)cellData).getColumn() + ((CellInfo)cellData).getColumnSpan();
                object = columnMap;
                n3 = rightIndex;
                Integer n8 = (Integer)columnMap.get(rightIndex);
                if (n8 == null) {
                    n8 = Integer.MIN_VALUE;
                }
                int n9 = n8;
                n2 = Math.max(cellRight, n9);
                object.put(n3, n2);
            }
            if (((CellInfo)cellData).getRow() != -1 && ((CellInfo)cellData).getRowSpan() != 0) {
                int bottomIndex = ((CellInfo)cellData).getRow() + ((CellInfo)cellData).getRowSpan();
                object = rowMap;
                n3 = bottomIndex;
                Integer n10 = (Integer)rowMap.get(bottomIndex);
                if (n10 == null) {
                    n10 = Integer.MIN_VALUE;
                }
                int n11 = n10;
                n2 = Math.max(cellBottom, n11);
                object.put(n3, n2);
            }
            previousRow = ((CellInfo)cellData).getRow();
            previousColumn = ((CellInfo)cellData).getColumn();
        }
        Set set = columnMap.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"columnMap.keys");
        Integer n12 = (Integer)CollectionsKt.max((Iterable)set);
        int columnCount = n12 != null ? n12 + 1 : 1;
        Set set2 = rowMap.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"rowMap.keys");
        Integer n13 = (Integer)CollectionsKt.max((Iterable)set2);
        int rowCount = n13 != null ? n13 + 1 : 1;
        cellData = columnMap;
        marginInsets = 0;
        Integer cellLeft = left;
        cellData.put(marginInsets, cellLeft);
        cellData = columnMap;
        marginInsets = columnCount;
        cellLeft = right;
        cellData.put(marginInsets, cellLeft);
        cellData = rowMap;
        marginInsets = 0;
        cellLeft = top;
        cellData.put(marginInsets, cellLeft);
        cellData = rowMap;
        marginInsets = rowCount;
        cellLeft = bottom;
        cellData.put(marginInsets, cellLeft);
        int size$iv = columnCount + 1;
        Integer[] result$iv = new Integer[size$iv];
        cellTop = 0;
        cellRight = result$iv.length;
        while (cellTop < cellRight) {
            void it;
            void i$iv;
            cellBottom = i$iv;
            var26_43 = i$iv;
            integerArray = result$iv;
            boolean bl = false;
            Integer n14 = (Integer)columnMap.get((int)it);
            if (n14 == null) {
                n14 = Integer.MIN_VALUE;
            }
            integerArray[var26_43] = n = n14;
            ++i$iv;
        }
        Integer[] columnArray = result$iv;
        int size$iv2 = rowCount + 1;
        Integer[] result$iv2 = new Integer[size$iv2];
        cellRight = 0;
        int n15 = result$iv2.length;
        while (cellRight < n15) {
            void it;
            void i$iv;
            void bl = i$iv;
            var26_43 = i$iv;
            integerArray = result$iv2;
            boolean bl2 = false;
            Integer n16 = (Integer)rowMap.get((int)it);
            if (n16 == null) {
                n16 = Integer.MIN_VALUE;
            }
            integerArray[var26_43] = n = n16;
            ++i$iv;
        }
        Integer[] rowArray = result$iv2;
        return new GridBarriers(left, top, right, bottom, rowArray, columnArray);
    }

    private static final CellInfo retrieveCellData(NlComponent nlComponent, boolean isSupportLibrary) {
        String namespace = isSupportLibrary ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
        Function2 getAttribute2 = (Function2)new Function2<String, Integer, Integer>(nlComponent, namespace){
            final /* synthetic */ NlComponent $nlComponent;
            final /* synthetic */ String $namespace;

            public final int invoke(@NotNull String name, int defaultValue) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Object object = this.$nlComponent.getLiveAttribute(this.$namespace, name);
                return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : defaultValue;
            }
            {
                this.$nlComponent = nlComponent;
                this.$namespace = string;
                super(2);
            }
        };
        return new CellInfo(((Number)getAttribute2.invoke((Object)"layout_row", (Object)-1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_column", (Object)-1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_rowSpan", (Object)1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_columnSpan", (Object)1)).intValue());
    }

    private static final String getLiveAndroidAttribute(@NotNull NlComponent $receiver, String androidAttribute) {
        return $receiver.getLiveAttribute("http://schemas.android.com/apk/res/android", androidAttribute);
    }

    private static final Insets retrieveMargins(NlComponent nlComponent) {
        return GridUtilsKt.retrieveInsets(nlComponent, MARGIN_ATTRIBUTES);
    }

    private static final Insets retrievePaddings(NlComponent nlComponent) {
        return GridUtilsKt.retrieveInsets(nlComponent, PADDING_ATTRIBUTES);
    }

    private static final Insets retrieveInsets(NlComponent nlComponent, InsetsAttributes attrs) {
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        String valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getAll());
        if (valueString != null) {
            int padding;
            left = padding = GridUtilsKt.getPxValue(nlComponent, valueString);
            top = padding;
            right = padding;
            bottom = padding;
        } else {
            String string = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getLeft().getFirst());
            if (string == null) {
                string = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getLeft().getSecond());
            }
            valueString = string;
            left = GridUtilsKt.getPxValue(nlComponent, valueString);
            valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getTop());
            top = GridUtilsKt.getPxValue(nlComponent, valueString);
            String string2 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getRight().getFirst());
            if (string2 == null) {
                string2 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getRight().getSecond());
            }
            valueString = string2;
            right = GridUtilsKt.getPxValue(nlComponent, valueString);
            valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getBottom());
            bottom = GridUtilsKt.getPxValue(nlComponent, valueString);
        }
        return new Insets(left, top, right, bottom);
    }

    private static final int getPxValue(NlComponent nlComponent, String value2) {
        if (value2 != null) {
            NlModel nlModel = nlComponent.getModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)nlModel, (String)"nlComponent.model");
            Configuration configuration = nlModel.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"nlComponent.model.configuration");
            Configuration configuration2 = configuration;
            ResourceResolver resourceResolver = configuration2.getResourceResolver();
            if (resourceResolver != null) {
                Integer n = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, value2, configuration2);
                return n != null ? n : 0;
            }
        }
        return 0;
    }
}

