/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.frame;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.frame.FrameDragTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\"\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/frame/FrameDragHandler;", "Lcom/android/tools/idea/uibuilder/api/DragHandler;", "editor", "Lcom/android/tools/idea/uibuilder/api/ViewEditor;", "handler", "Lcom/android/tools/idea/uibuilder/api/ViewGroupHandler;", "layout", "Lcom/android/tools/idea/common/scene/SceneComponent;", "components", "", "Lcom/android/tools/idea/common/model/NlComponent;", "type", "Lcom/android/tools/idea/common/api/DragType;", "(Lcom/android/tools/idea/uibuilder/api/ViewEditor;Lcom/android/tools/idea/uibuilder/api/ViewGroupHandler;Lcom/android/tools/idea/common/scene/SceneComponent;Ljava/util/List;Lcom/android/tools/idea/common/api/DragType;)V", "component", "dragTarget", "Lcom/android/tools/idea/uibuilder/handlers/frame/FrameDragTarget;", "cancel", "", "commit", "x", "", "y", "modifiers", "insertType", "Lcom/android/tools/idea/common/api/InsertType;", "start", "update", "", "intellij.android.designer"})
public final class FrameDragHandler
extends DragHandler {
    private final SceneComponent component;
    private final FrameDragTarget dragTarget;

    @Override
    public void start(int x, int y, int modifiers) {
        super.start(x, y, modifiers);
        if (this.component == null) {
            return;
        }
        this.dragTarget.mouseDown(x, y);
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String result2 = super.update(x, y, modifiers);
        if (this.component == null) {
            return "undefined";
        }
        int dx = x + this.startX - this.component.getDrawWidth() / 2;
        int dy = y + this.startY - this.component.getDrawHeight() / 2;
        this.dragTarget.mouseDrag(dx, dy, CollectionsKt.emptyList());
        return result2;
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)insertType), (String)"insertType");
        if (this.component != null) {
            this.dragTarget.cancel();
            SceneComponent sceneComponent = this.layout;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"layout");
            sceneComponent.getScene().removeComponent(this.component);
            SceneComponent sceneComponent2 = this.layout;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"layout");
            this.editor.insertChildren(sceneComponent2.getNlComponent(), this.components, -1, insertType);
            SceneComponent sceneComponent3 = this.layout;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"layout");
            sceneComponent3.getScene().checkRequestLayoutStatus();
        }
    }

    @Override
    public void cancel() {
        if (this.component != null) {
            SceneComponent sceneComponent = this.layout;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"layout");
            sceneComponent.getScene().removeComponent(this.component);
        }
        this.dragTarget.cancel();
    }

    public FrameDragHandler(@NotNull ViewEditor editor2, @NotNull ViewGroupHandler handler, @NotNull SceneComponent layout2, @NotNull List<? extends NlComponent> components, @NotNull DragType type) {
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)layout2, (String)"layout");
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        super(editor2, handler, layout2, components, type);
        this.dragTarget = new FrameDragTarget();
        if (components.size() == 1) {
            NlComponent selectedNlCmponent = components.get(0);
            this.component = new TemporarySceneComponent(layout2.getScene(), selectedNlCmponent);
            this.component.setSize(editor2.pxToDp(NlComponentHelperKt.getW(selectedNlCmponent)), editor2.pxToDp(NlComponentHelperKt.getH(selectedNlCmponent)), false);
            this.component.setTargetProvider(new TargetProvider(){

                @NotNull
                public final List<FrameDragTarget> createTargets(@NotNull SceneComponent it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return CollectionsKt.listOf((Object)dragTarget);
                }
            });
            this.component.setDrawState(SceneComponent.DrawState.DRAG);
            layout2.addChild(this.component);
        } else {
            this.component = null;
        }
    }
}

