/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.ActionTarget;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.graphics.NlIcon;
import com.google.common.collect.ImmutableList;
import icons.StudioIcons;
import java.util.List;

public class BaseLineActionTarget
extends ActionTarget {
    private static final NlIcon BASELINE_ICON = new NlIcon(StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED_CONSTRAINT);

    public BaseLineActionTarget() {
        super(BASELINE_ICON, c -> c.setShowBaseline(!c.canShowBaseline()));
    }

    @Override
    public void mouseDown(int x, int y) {
        SceneComponent c = this.getComponent();
        boolean baseline = !this.myComponent.canShowBaseline();
        this.myComponent.setShowBaseline(baseline);
        if (baseline) {
            ImmutableList<Target> targets = this.myComponent.getTargets();
            for (Target t : targets) {
                AnchorTarget at;
                if (!(t instanceof AnchorTarget) || (at = (AnchorTarget)t).getType() != AnchorTarget.Type.BASELINE) continue;
                this.myComponent.getScene().setHitTarget(at);
                at.mouseDown((int)at.getCenterX(), (int)at.getCenterY());
                at.mouseDrag(x, y, (List<Target>)this.myComponent.getTargets());
            }
        }
        this.myComponent.getScene().needsRebuildList();
        this.myComponent.getScene().repaint();
    }

    @Override
    public String getToolTipText() {
        return "Edit Baseline";
    }
}

