/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawAnimatedFrame;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnection;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConstraintLayoutDecorator
extends SceneDecorator {
    private static final String[] LEFT_DIR = new String[]{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"};
    private static final String[] RIGHT_DIR = new String[]{"layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf"};
    private static final String[] TOP_DIR = new String[]{"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"};
    private static final String[] BOTTOM_DIR = new String[]{"layout_constraintBottom_toBottomOf", "layout_constraintBottom_toTopOf"};
    private static final String[] LEFT_DIR_RTL = new String[]{"layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"};
    private static final String[] RIGHT_DIR_RTL = new String[]{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf"};
    private static final String[][] ourConnections = new String[][]{LEFT_DIR, RIGHT_DIR, TOP_DIR, BOTTOM_DIR};
    private static final String[][] ourConnections_rtl = new String[][]{LEFT_DIR_RTL, RIGHT_DIR_RTL, TOP_DIR, BOTTOM_DIR};
    private static final String BASELINE = "BASELINE";
    private static final String[] BASELINE_DIR = new String[]{"layout_constraintBaseline_toBaselineOf"};
    private static final String BASELINE_TYPE = "BASELINE_TYPE";
    private static final String[][] MARGIN_ATTR_LTR = new String[][]{{"layout_marginStart", "layout_marginLeft"}, {"layout_marginEnd", "layout_marginRight"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[][] MARGIN_ATTR_RTL = new String[][]{{"layout_marginEnd", "layout_marginLeft"}, {"layout_marginStart", "layout_marginRight"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[] BIAS_ATTR = new String[]{"layout_constraintHorizontal_bias", "layout_constraintHorizontal_bias", "layout_constraintVertical_bias", "layout_constraintVertical_bias"};
    private static final boolean[] FLIP_BIAS = new boolean[]{true, false, false, true};
    private static final ConnectionType[] DIR_TABLE = new ConnectionType[]{ConnectionType.SAME, ConnectionType.BACKWARD, ConnectionType.SAME, ConnectionType.BACKWARD};
    private static final String[] ourDirections = new String[]{"LEFT", "RIGHT", "TOP", "BOTTOM"};
    private static final String[] ourChainDirections = new String[]{"CHAIN_LEFT", "CHAIN_RIGHT", "CHAIN_TOP", "CHAIN_BOTTOM"};
    private static final String[] ourDirectionsType = new String[]{"LEFT_TYPE", "RIGHT_TYPE", "TOP_TYPE", "BOTTOM_TYPE"};
    private static final boolean[] isLeftRight = new boolean[]{true, true, false, false};
    private static final int[] ourOppositeDirection = new int[]{1, 0, 3, 2};

    private static void convert(@NotNull SceneContext sceneContext, Rectangle rect) {
        if (sceneContext == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(0);
        }
        rect.x = sceneContext.getSwingXDip(rect.x);
        rect.y = sceneContext.getSwingYDip(rect.y);
        rect.width = sceneContext.getSwingDimensionDip(rect.width);
        rect.height = sceneContext.getSwingDimensionDip(rect.height);
    }

    private static void gatherProperties(@NotNull SceneComponent component, @NotNull SceneComponent child) {
        boolean rtl;
        if (component == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(1);
        }
        if (child == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(2);
        }
        String[][] connections = (rtl = component.getScene().isInRTL()) ? ourConnections_rtl : ourConnections;
        for (int i2 = 0; i2 < ourDirections.length; ++i2) {
            ConstraintLayoutDecorator.getConnection(component, child, connections[i2], ourDirections[i2], ourDirectionsType[i2]);
        }
        ConstraintLayoutDecorator.getConnection(component, child, BASELINE_DIR, BASELINE, BASELINE_TYPE);
    }

    private static void getConnection(SceneComponent component, SceneComponent child, String[] atributes, String dir, String dirType) {
        String id = null;
        ConnectionType type = ConnectionType.SAME;
        for (int i2 = 0; i2 < atributes.length; ++i2) {
            id = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", atributes[i2]);
            type = DIR_TABLE[i2];
            if (id != null) break;
        }
        if (id == null) {
            child.myCache.put(dir, id);
            child.myCache.put(dirType, (Object)ConnectionType.SAME);
            return;
        }
        if (id.equalsIgnoreCase("parent")) {
            child.myCache.put(dir, component);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        String cleanId = NlComponent.extractId(id);
        if (cleanId == null) {
            child.myCache.put(dir, id);
            child.myCache.put(dirType, (Object)ConnectionType.SAME);
            return;
        }
        if (cleanId.equals(component.getId())) {
            child.myCache.put(dir, component);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        for (SceneComponent con : component.getChildren()) {
            if (!cleanId.equals(con.getId())) continue;
            child.myCache.put(dir, con);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        child.myCache.put(dirType, (Object)ConnectionType.SAME);
    }

    @Override
    protected void addBackground(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        if (list == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(3);
        }
        if (sceneContext == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(4);
        }
        if (component == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(5);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildListChildren(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component;
        List<SceneComponent> children;
        if (list == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(6);
        }
        if (sceneContext == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(7);
        }
        if (sceneComponent == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(8);
        }
        if (!(children = component.getChildren()).isEmpty()) {
            for (SceneComponent child : component.getChildren()) {
                ConstraintLayoutDecorator.gatherProperties((SceneComponent)component, child);
            }
            Rectangle rect = new Rectangle();
            component.fillRect(rect);
            DisplayList.UNClip unClip = null;
            if (!((Boolean)StudioFlags.NELE_DRAG_PLACEHOLDER.get()).booleanValue()) {
                unClip = list.addClip(sceneContext, rect);
            }
            Scene scene = component.getScene();
            boolean showAllConstraints = ConstraintLayoutHandler.getVisualProperty("ConstraintLayoutPreferenceShowAllConstraints");
            List<NlComponent> selection = scene.getSelection();
            for (SceneComponent child : children) {
                child.buildDisplayList(time2, list, sceneContext);
                if (SceneLayer.SHOW_ON_HOVER && sceneContext.showOnlySelection() || (!showAllConstraints || scene.getRoot() != component) && !selection.contains(child.getNlComponent())) continue;
                ConstraintLayoutDecorator.buildListConnections(list, time2, sceneContext, (SceneComponent)component, child);
            }
            if (unClip != null) {
                list.add(unClip);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void buildListConnections(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent constraintComponent, @NotNull SceneComponent sceneComponent) {
        long changeStart;
        int i2;
        void child;
        if (list == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(9);
        }
        if (sceneContext == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(10);
        }
        if (constraintComponent == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(11);
        }
        if (sceneComponent == null) {
            ConstraintLayoutDecorator.$$$reportNull$$$0(12);
        }
        Rectangle dest_rect = new Rectangle();
        Rectangle source_rect = new Rectangle();
        child.fillDrawRect(time2, source_rect);
        ConstraintLayoutDecorator.convert(sceneContext, source_rect);
        ConnectionStatus connectStatus = new ConnectionStatus();
        List<NlComponent> selection = constraintComponent.getScene().getSelection();
        boolean fade = ConstraintLayoutHandler.getVisualProperty("ConstraintLayoutPreferenceFadeUnselected");
        if (fade && selection.isEmpty()) {
            fade = false;
        }
        if (fade && selection.contains(constraintComponent.getNlComponent()) && selection.size() == 1) {
            fade = false;
        }
        boolean viewSelected = selection.contains(child.getNlComponent());
        connectStatus.getConnectionInfo(child.getNlComponent(), viewSelected);
        ConnectionType[] connectionTypes = new ConnectionType[ourDirections.length];
        SceneComponent[] connectionTo = new SceneComponent[ourDirections.length];
        for (i2 = 0; i2 < ourDirections.length; ++i2) {
            connectionTypes[i2] = (ConnectionType)((Object)child.myCache.get(ourDirectionsType[i2]));
            Object obj = child.myCache.get(ourDirections[i2]);
            connectionTo[i2] = obj instanceof SceneComponent ? (SceneComponent)obj : null;
        }
        for (i2 = 0; i2 < ourDirections.length; ++i2) {
            boolean overlap;
            boolean shift;
            String biasString;
            int connect;
            ConnectionType type = connectionTypes[i2];
            SceneComponent sc = connectionTo[i2];
            int destType = 0;
            if (sc == null) continue;
            sc.fillDrawRect(time2, dest_rect);
            ConstraintLayoutDecorator.convert(sceneContext, dest_rect);
            int n = connect = type == ConnectionType.SAME ? i2 : ourOppositeDirection[i2];
            if (child.getParent().equals(sc)) {
                destType = 1;
            } else if (SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEqualsIgnoreCase(NlComponentHelperKt.getComponentClassName(sc.getNlComponent())) || SdkConstants.CONSTRAINT_LAYOUT_BARRIER.isEqualsIgnoreCase(NlComponentHelperKt.getComponentClassName(sc.getNlComponent()))) {
                destType = 2;
            }
            int connectType = 1;
            if (connectionTo[ourOppositeDirection[i2]] != null) {
                connectType = 2;
                if (connectionTo[ourOppositeDirection[i2]] == sc && destType != 1) {
                    connectType = connectionTypes[ourOppositeDirection[i2]] != type ? 4 : 6;
                }
            }
            SceneComponent toComponentsTo = (SceneComponent)sc.myCache.get(ourDirections[connect]);
            if (type == ConnectionType.BACKWARD && toComponentsTo == child && sc.myCache.get(ourDirectionsType[connect]) == ConnectionType.BACKWARD) {
                connectType = 3;
                if (sc.myCache.containsKey(ourChainDirections[ourOppositeDirection[i2]])) continue;
            }
            int margin = 0;
            int marginDistance = 0;
            boolean isMarginReference = false;
            float bias = 0.5f;
            boolean rtl = constraintComponent.getScene().isInRTL();
            String[] margin_attr = rtl ? MARGIN_ATTR_RTL[i2] : MARGIN_ATTR_LTR[i2];
            String marginString = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", margin_attr[0]);
            if (marginString == null && margin_attr.length > 1) {
                marginString = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", margin_attr[1]);
            }
            if (marginString == null) {
                if (i2 == 0) {
                    marginString = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart");
                } else if (i2 == 1) {
                    marginString = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
                }
            }
            if (marginString != null) {
                if (marginString.startsWith("@")) {
                    isMarginReference = true;
                }
                margin = ConstraintUtilities.getDpValue(child.getAuthoritativeNlComponent(), marginString);
                marginDistance = sceneContext.getSwingDimensionDip(margin);
            }
            if ((biasString = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", BIAS_ATTR[i2])) != null) {
                try {
                    bias = Float.parseFloat(biasString);
                    if (FLIP_BIAS[i2]) {
                        bias = 1.0f - bias;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean bl = shift = toComponentsTo != null;
            if (destType == 2) {
                connect = ourOppositeDirection[i2];
            }
            changeStart = connectStatus.getTime(i2);
            int previousMode = connectStatus.getPreviousMode(i2);
            int currentMode = connectStatus.getCurrentMode(i2);
            if (currentMode == 0 && fade) {
                currentMode = 1;
            }
            int x1 = ConstraintLayoutDecorator.getX(source_rect, i2);
            int x2 = ConstraintLayoutDecorator.getX(dest_rect, connect);
            int y1 = ConstraintLayoutDecorator.getY(source_rect, i2);
            int y2 = ConstraintLayoutDecorator.getY(dest_rect, connect);
            boolean bl2 = overlap = i2 != connect && (isLeftRight[i2] && Math.abs(x1 - x2) < 4 && Math.abs(y1 - y2) < dest_rect.height / 2 || !isLeftRight[i2] && Math.abs(y1 - y2) < 4 && Math.abs(x1 - x2) < dest_rect.width / 2);
            if (overlap) {
                connectType = 7;
            }
            if (!ConstraintLayoutHandler.getVisualProperty("ConstraintLayoutPreferenceShowMargins")) {
                margin = 0;
                marginDistance = 0;
            }
            DrawConnection.buildDisplayList(list, connectType, source_rect, i2, dest_rect, connect, destType, shift, margin, marginDistance, isMarginReference, Float.valueOf(bias), previousMode, currentMode, changeStart);
            if (currentMode != 6) continue;
            if (destType == 2) {
                int over_size_line = 3000;
                dest_rect.grow(connect < 2 ? 1 : over_size_line, connect < 2 ? over_size_line : 1);
            }
            DrawAnimatedFrame.add(list, dest_rect, connect);
        }
        SceneComponent baseLineConnection = (SceneComponent)child.myCache.get(BASELINE);
        if (baseLineConnection != null) {
            baseLineConnection.fillDrawRect(time2, dest_rect);
            ConstraintLayoutDecorator.convert(sceneContext, dest_rect);
            int dest_offset = sceneContext.getSwingDimensionDip(baseLineConnection.getBaseline());
            int source_offset = sceneContext.getSwingDimensionDip(child.getBaseline());
            source_rect.y += source_offset;
            source_rect.height = 0;
            dest_rect.y += dest_offset;
            dest_rect.height = 0;
            changeStart = connectStatus.getTime(4);
            int previousMode = connectStatus.getPreviousMode(4);
            int currentMode = connectStatus.getCurrentMode(4);
            if (currentMode == 0 && fade) {
                currentMode = 1;
            }
            DrawConnection.buildDisplayList(list, 5, source_rect, 5, dest_rect, 5, 0, false, 0, 0, false, Float.valueOf(0.0f), previousMode, currentMode, changeStart);
        }
    }

    private static int getX(Rectangle rectangle, int direction) {
        switch (direction) {
            case 0: {
                return rectangle.x;
            }
            case 1: {
                return rectangle.x + rectangle.width + 1;
            }
            case 2: {
                return rectangle.x + rectangle.width / 2;
            }
            case 3: {
                return rectangle.x + rectangle.width / 2;
            }
        }
        return 0;
    }

    private static int getY(Rectangle rectangle, int direction) {
        switch (direction) {
            case 0: {
                return rectangle.y + rectangle.height / 2;
            }
            case 1: {
                return rectangle.y + rectangle.height / 2;
            }
            case 2: {
                return rectangle.y;
            }
            case 3: {
                return rectangle.y + rectangle.height + 1;
            }
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintComponent";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/draw/ConstraintLayoutDecorator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "gatherProperties";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addBackground";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "buildListChildren";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "buildListConnections";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ConnectionStatus {
        static String[] connectTypes = new String[]{"left", "right", "north", "bottom", "baseline"};
        public static final int DIRECTION_BASELINE = 4;
        int[] mPrevious = new int[connectTypes.length];
        int[] mCurrent = new int[connectTypes.length];
        long[] time = new long[connectTypes.length];
        DecoratorUtilities.ViewStates componentPrevState;
        DecoratorUtilities.ViewStates componentCurrentState;
        Long componentChangeStateTime;
        boolean mSelected = true;

        ConnectionStatus() {
        }

        void getConnectionInfo(NlComponent c, boolean isSelected) {
            this.componentPrevState = DecoratorUtilities.getTimedChange_prev(c, "view");
            this.componentCurrentState = DecoratorUtilities.getTimedChange_value(c, "view");
            this.componentChangeStateTime = DecoratorUtilities.getTimedChange_time(c, "drawState");
            this.mSelected = isSelected;
            for (int i2 = 0; i2 < connectTypes.length; ++i2) {
                DecoratorUtilities.ViewStates current;
                String type = connectTypes[i2];
                if (this.componentCurrentState != DecoratorUtilities.ViewStates.SELECTED && (current = DecoratorUtilities.getTimedChange_value(c, type)) == DecoratorUtilities.ViewStates.SELECTED) {
                    long t = this.componentChangeStateTime != null ? this.componentChangeStateTime : System.nanoTime();
                    DecoratorUtilities.setTimeChange(c, type, t, current, DecoratorUtilities.ViewStates.NORMAL);
                }
                DecoratorUtilities.ViewStates prev = DecoratorUtilities.getTimedChange_prev(c, type);
                current = DecoratorUtilities.getTimedChange_value(c, type);
                Long event = DecoratorUtilities.getTimedChange_time(c, type);
                if (event != null) {
                    this.time[i2] = event;
                    this.mPrevious[i2] = prev.getVal();
                    this.mCurrent[i2] = current.getVal();
                    continue;
                }
                this.time[i2] = -1L;
            }
        }

        int getPreviousMode(int direction) {
            if (this.time[direction] == -1L) {
                if (this.componentPrevState == DecoratorUtilities.ViewStates.NORMAL) {
                    return 0;
                }
                return this.mCurrent[direction];
            }
            return this.mPrevious[direction];
        }

        int getCurrentMode(int direction) {
            if (this.time[direction] == -1L) {
                if (this.mSelected) {
                    return 2;
                }
                return this.mCurrent[direction];
            }
            return this.mCurrent[direction];
        }

        long getTime(int direction) {
            if (this.time[direction] == -1L) {
                return this.componentChangeStateTime == null ? 0L : this.componentChangeStateTime;
            }
            return this.time[direction];
        }
    }

    static enum ConnectionType {
        SAME,
        BACKWARD;

    }
}

