/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.animation;

import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ViewTransform;
import java.awt.Graphics2D;

public abstract class Animation {
    private int mDuration = 400;
    private long mStart = 0L;
    private long mDelay = 0L;
    private double mProgress = 0.0;
    private boolean mLoop = false;

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public void setDelay(int delay) {
        this.mDelay = delay;
    }

    public void setLoop(boolean loop) {
        this.mLoop = loop;
    }

    public void setProgress(double progress) {
        this.mProgress = progress;
    }

    public double getProgress() {
        return this.mProgress;
    }

    public void start() {
        this.mStart = System.currentTimeMillis() + this.mDelay;
    }

    public void reset() {
        this.mStart = 0L;
    }

    public boolean step() {
        long current = System.currentTimeMillis();
        if (this.mStart == 0L || current - this.mStart < 0L) {
            this.mProgress = 0.0;
        } else {
            if (current - this.mStart > (long)this.mDuration) {
                if (this.mLoop) {
                    this.mProgress = 0.0;
                    this.start();
                    return true;
                }
                this.mProgress = 1.0;
                return false;
            }
            this.mProgress = (double)(current - this.mStart) / (double)this.mDuration;
        }
        return true;
    }

    public static int getPulsatingAlpha(double progress) {
        progress *= 2.0;
        int start = 0;
        int end = 255;
        if (progress > 1.0) {
            start = 255;
            end = 0;
            progress -= 1.0;
        }
        return (int)Animation.EaseInOutinterpolator(progress, start, end);
    }

    public static double EaseInOutinterpolator(double progress, double begin, double end) {
        double change = (end - begin) / 2.0;
        if ((progress *= 2.0) < 1.0) {
            return change * progress * progress + begin;
        }
        return -change * ((progress -= 1.0) * (progress - 2.0) - 1.0) + begin;
    }

    public abstract void onPaint(ViewTransform var1, Graphics2D var2);
}

