/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.handlers.constraint.SingleWidgetView;
import com.android.tools.idea.uibuilder.handlers.constraint.WidgetConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.BlueprintColorSet;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetConstraintPanel
extends AdtSecondaryPanel
implements CustomPanel {
    private static final String HORIZONTAL_TOOL_TIP_TEXT = "Horizontal Bias";
    private static final String VERTICAL_TOOL_TIP_TEXT = "Vertical Bias";
    private static final Color mSliderColor = new JBColor(0xC9C9C9, 2369063);
    private static final JBDimension PANEL_DIMENSION = JBUI.size((int)201, (int)215);
    @NotNull
    private final SingleWidgetView mMain;
    private final JSlider mVerticalSlider;
    private final JSlider mHorizontalSlider;
    private static final int UNCONNECTED = -1;
    private static final int SLIDER_DEFAULT = 50;
    public static final String VERTICAL_BIAS_SLIDER = "verticalBiasSlider";
    public static final String HORIZONTAL_BIAS_SLIDER = "horizontalBiasSlider";
    private final WidgetConstraintModel myWidgetModel;
    @NotNull
    MouseListener mDoubleClickListener;

    public WidgetConstraintPanel(@NotNull List<NlComponent> components) {
        if (components == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(0);
        }
        super(null);
        this.mVerticalSlider = new JSlider(1);
        this.mHorizontalSlider = new JSlider(0);
        this.myWidgetModel = new WidgetConstraintModel(() -> this.configureUI());
        this.mDoubleClickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ((JSlider)e.getSource()).setValue(50);
                }
            }
        };
        InspectorColorSet colorSet = new InspectorColorSet();
        this.mMain = new SingleWidgetView(colorSet, this.myWidgetModel);
        this.mMain.setOpaque(false);
        this.setPreferredSize((Dimension)PANEL_DIMENSION);
        this.mVerticalSlider.setMajorTickSpacing(50);
        this.mHorizontalSlider.setMajorTickSpacing(50);
        this.mHorizontalSlider.setToolTipText(HORIZONTAL_TOOL_TIP_TEXT);
        this.mVerticalSlider.setToolTipText(VERTICAL_TOOL_TIP_TEXT);
        this.mVerticalSlider.setName(VERTICAL_BIAS_SLIDER);
        this.mHorizontalSlider.setName(HORIZONTAL_BIAS_SLIDER);
        this.myWidgetModel.setComponent(components.isEmpty() ? null : components.get(0));
        this.add(this.mVerticalSlider);
        this.add(this.mMain);
        this.add(this.mHorizontalSlider);
        this.mVerticalSlider.setUI(new WidgetSliderUI(this.mVerticalSlider, colorSet));
        this.mHorizontalSlider.setUI(new WidgetSliderUI(this.mHorizontalSlider, colorSet));
        this.mHorizontalSlider.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.mVerticalSlider.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.mHorizontalSlider.setForeground(mSliderColor);
        this.mVerticalSlider.setForeground(mSliderColor);
        this.mHorizontalSlider.addChangeListener(e -> this.myWidgetModel.setHorizontalBias(this.mHorizontalSlider.getValue()));
        this.mVerticalSlider.addChangeListener(e -> this.myWidgetModel.setVerticalBias(this.mVerticalSlider.getValue()));
        this.mHorizontalSlider.addMouseListener(this.mDoubleClickListener);
        this.mVerticalSlider.addMouseListener(this.mDoubleClickListener);
        this.configureUI();
    }

    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        Dimension mainSize = this.mMain.getPreferredSize();
        Dimension HSliderSize = this.mHorizontalSlider.getPreferredSize();
        Dimension VSliderSize = this.mVerticalSlider.getPreferredSize();
        int mainX = (width - mainSize.width) / 2;
        int mainY = (height - mainSize.height) / 2;
        this.mMain.setBounds(mainX, mainY, mainSize.width, mainSize.height);
        this.mHorizontalSlider.setBounds((width - HSliderSize.width) / 2, mainY + mainSize.height, HSliderSize.width, HSliderSize.height);
        this.mVerticalSlider.setBounds(mainX - VSliderSize.width, (height - VSliderSize.height) / 2, VSliderSize.width, VSliderSize.height);
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        WidgetConstraintPanel widgetConstraintPanel = this;
        if (widgetConstraintPanel == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(1);
        }
        return widgetConstraintPanel;
    }

    @Override
    public void useComponent(@Nullable NlComponent component) {
        this.myWidgetModel.setComponent(component);
    }

    @Override
    public void refresh() {
        this.configureUI();
    }

    private void configureUI() {
        float bias;
        boolean showHorizontalSlider;
        if (this.myWidgetModel.getComponent() == null) {
            return;
        }
        int top = this.myWidgetModel.getMargin(2);
        int left = this.myWidgetModel.getMargin(0);
        int right = this.myWidgetModel.getMargin(1);
        int bottom = this.myWidgetModel.getMargin(3);
        String ratioString = this.myWidgetModel.getRatioString();
        boolean baseline = this.myWidgetModel.hasBaseline();
        boolean showVerticalSlider = bottom != -1 && top != -1;
        boolean bl = showHorizontalSlider = left != -1 && right != -1;
        if (showHorizontalSlider) {
            bias = this.myWidgetModel.getHorizontalBias();
            this.mHorizontalSlider.setValue((int)(bias * 100.0f));
        }
        if (showVerticalSlider) {
            bias = this.myWidgetModel.getVerticalBias();
            this.mVerticalSlider.setValue(100 - (int)(bias * 100.0f));
        }
        this.mVerticalSlider.setEnabled(showVerticalSlider);
        this.mHorizontalSlider.setEnabled(showHorizontalSlider);
        this.mHorizontalSlider.invalidate();
        this.mVerticalSlider.invalidate();
        this.mVerticalSlider.setToolTipText(showVerticalSlider ? VERTICAL_TOOL_TIP_TEXT : null);
        this.mHorizontalSlider.setToolTipText(showHorizontalSlider ? HORIZONTAL_TOOL_TIP_TEXT : null);
        int widthValue = this.myWidgetModel.convertFromNL("layout_width");
        int heightValue = this.myWidgetModel.convertFromNL("layout_height");
        this.mMain.configureUi(bottom, top, left, right, baseline, widthValue, heightValue, ratioString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class WidgetSliderUI
    extends BasicSliderUI {
        private static final JBDimension THUMB_SIZE = JBUI.size((int)18);
        private static final int TRACK_THICKNESS = JBUI.scale((int)5);
        private static final int ARC_SIZE = JBUI.scale((int)2);
        private static final int SLIDER_LENGTH = 120;
        private static final Dimension V_SIZE = new Dimension(WidgetSliderUI.THUMB_SIZE.width, 120);
        private static final Dimension H_SIZE = new Dimension(120, WidgetSliderUI.THUMB_SIZE.height);
        @NotNull
        private static Font SMALL_FONT = new Font("Helvetica", 0, JBUI.scaleFontSize((float)10.0f));
        private ColorSet mColorSet;

        WidgetSliderUI(JSlider s, ColorSet colorSet) {
            super(s);
            this.mColorSet = colorSet;
        }

        @Override
        public Dimension getPreferredHorizontalSize() {
            return H_SIZE;
        }

        @Override
        public Dimension getPreferredVerticalSize() {
            return V_SIZE;
        }

        @Override
        @NotNull
        protected Dimension getThumbSize() {
            JBDimension jBDimension = THUMB_SIZE;
            if (jBDimension == null) {
                WidgetSliderUI.$$$reportNull$$$0(0);
            }
            return jBDimension;
        }

        @Override
        public void paintTrack(Graphics g) {
            if (this.slider.isEnabled()) {
                g.setColor(this.slider.getForeground());
                int trackThickness = TRACK_THICKNESS;
                if (this.slider.getOrientation() == 1) {
                    int offset = this.trackRect.width / 2 - trackThickness / 2;
                    g.fillRoundRect(this.trackRect.x + offset, this.trackRect.y, trackThickness, this.trackRect.height, ARC_SIZE, ARC_SIZE);
                } else {
                    int offset = this.trackRect.height / 2 - trackThickness / 2;
                    g.fillRoundRect(this.trackRect.x, this.trackRect.y + offset, this.trackRect.width, trackThickness, ARC_SIZE, ARC_SIZE);
                }
            }
        }

        @Override
        protected Color getShadowColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        protected Color getHighlightColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        @NotNull
        protected Color getFocusColor() {
            JBColor jBColor = JBColor.BLACK;
            if (jBColor == null) {
                WidgetSliderUI.$$$reportNull$$$0(1);
            }
            return jBColor;
        }

        @Override
        public void paintThumb(Graphics g) {
            String percentText = this.slider.getOrientation() == 1 ? Integer.toString(100 - this.slider.getValue()) : Integer.toString(this.slider.getValue());
            if (!this.slider.isEnabled()) {
                return;
            }
            g.setColor(this.mColorSet.getInspectorFillColor().brighter());
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fillRoundRect(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width - 1, this.thumbRect.height - 1, this.thumbRect.width, this.thumbRect.height);
            g.setColor(StudioColorsKt.getBorder());
            g.drawRoundRect(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width - 1, this.thumbRect.height - 1, this.thumbRect.width, this.thumbRect.height);
            g.setColor(this.mColorSet.getInspectorStrokeColor());
            int x = this.thumbRect.x + this.thumbRect.width / 2;
            int y = this.thumbRect.y + this.thumbRect.height / 2;
            g.setFont(SMALL_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(percentText, g);
            double tw = bounds.getWidth();
            g.setColor(this.mColorSet.getInspectorStrokeColor());
            g.drawString(percentText, (int)((double)x - tw / 2.0), y + fm.getAscent() / 2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel$WidgetSliderUI";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThumbSize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFocusColor";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class InspectorColorSet
    extends BlueprintColorSet {
        InspectorColorSet() {
            this.mDrawBackground = false;
            this.mDrawWidgetInfos = true;
            this.mInspectorBackgroundColor = StudioColorsKt.getSecondaryPanelBackground();
            this.mInspectorFillColor = StudioColorsKt.getSecondaryPanelBackground();
            this.mInspectorHighlightsStrokeColor = new JBColor(0xB0B0B0, 7303537);
            this.mInspectorStrokeColor = new JBColor(0x8A8A8A, 0x808080);
            this.mInspectorConstraintColor = new JBColor(4489688, 4751560);
        }
    }
}

