/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchor;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.GuiUtils;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetConstraintModel {
    private static final String[][] ourConstraintString_ltr = new String[][]{{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static final String[][] ourConstraintString_rtl = new String[][]{{"layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static final String[][] ourMarginString_ltr = new String[][]{{"layout_marginLeft", "layout_marginStart"}, {"layout_marginRight", "layout_marginEnd"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[][] ourMarginString_rtl = new String[][]{{"layout_marginLeft", "layout_marginEnd"}, {"layout_marginRight", "layout_marginStart"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[][] ourDeleteAttributes = new String[][]{{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_marginLeft", "layout_marginStart", "layout_constraintHorizontal_bias"}, {"layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_marginRight", "layout_marginEnd", "layout_constraintHorizontal_bias"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_marginTop", "layout_constraintVertical_bias"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_marginBottom", "layout_constraintVertical_bias"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static final String[][] ourDeleteNamespace = new String[][]{{"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto"}};
    public static final int CONNECTION_LEFT = 0;
    public static final int CONNECTION_RIGHT = 1;
    public static final int CONNECTION_TOP = 2;
    public static final int CONNECTION_BOTTOM = 3;
    public static final int CONNECTION_BASELINE = 4;
    private static final int DELAY_BEFORE_COMMIT = 400;
    private boolean myIsInCallback;
    private Runnable myUpdateCallback;
    @Nullable
    private NlComponent myComponent;
    @NotNull
    private final ChangeListener myChangeLiveListener;
    @Nullable
    private ComponentModification myModification;
    @NotNull
    private final Timer myTimer;

    private void fireUIUpdate() {
        if (this.myUpdateCallback != null) {
            GuiUtils.invokeLaterIfNeeded(() -> {
                this.myIsInCallback = true;
                this.myUpdateCallback.run();
                this.myIsInCallback = false;
            }, (ModalityState)ModalityState.any());
        }
    }

    public WidgetConstraintModel(@NotNull Runnable modelUpdateCallback) {
        if (modelUpdateCallback == null) {
            WidgetConstraintModel.$$$reportNull$$$0(0);
        }
        this.myIsInCallback = false;
        this.myChangeLiveListener = e -> this.fireUIUpdate();
        this.myTimer = new Timer(400, c -> {
            if (this.myModification != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WidgetConstraintModel.this.myModification.commit();
                        WidgetConstraintModel.this.myModification = null;
                    }
                });
            }
        });
        this.myUpdateCallback = modelUpdateCallback;
    }

    void setUpdateCallback(@NotNull Runnable modelUpdateCallback) {
        if (modelUpdateCallback == null) {
            WidgetConstraintModel.$$$reportNull$$$0(1);
        }
        this.myUpdateCallback = modelUpdateCallback;
    }

    public int getMargin(int type) {
        if (this.myComponent == null) {
            return 0;
        }
        boolean rtl = ConstraintUtilities.isInRTL(this.myComponent);
        String[][] marginsAttr = rtl ? ourMarginString_rtl : ourMarginString_ltr;
        String marginString = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", marginsAttr[type][0]);
        for (int i2 = 1; marginString == null && marginsAttr[type].length > i2; ++i2) {
            marginString = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", marginsAttr[type][i2]);
        }
        int margin = 0;
        if (marginString != null) {
            margin = ConstraintUtilities.getDpValue(this.myComponent, marginString);
        }
        String[][] ourConstraintString = rtl ? ourConstraintString_rtl : ourConstraintString_ltr;
        String connection = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", ourConstraintString[type][0]);
        for (int i3 = 1; connection == null && i3 < ourConstraintString[type].length; ++i3) {
            connection = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", ourConstraintString[type][i3]);
        }
        if (connection == null) {
            margin = -1;
        }
        return margin;
    }

    public boolean hasBaseline() {
        return this.myComponent != null && this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
    }

    public void setComponent(@Nullable NlComponent component) {
        if (this.myComponent != null) {
            this.myComponent.removeLiveChangeListener(this.myChangeLiveListener);
        }
        NlComponent nlComponent = this.myComponent = WidgetConstraintModel.isApplicable(component) ? component : null;
        if (this.myComponent != null) {
            this.myComponent.addLiveChangeListener(this.myChangeLiveListener);
            this.fireUIUpdate();
        }
    }

    @Nullable
    public NlComponent getComponent() {
        return this.myComponent;
    }

    @Nullable
    public String getRatioString() {
        return this.myComponent == null ? null : this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintDimensionRatio");
    }

    private static boolean isApplicable(@Nullable NlComponent component) {
        if (component == null) {
            return false;
        }
        NlComponent parent = component.getParent();
        return parent != null && NlComponentHelperKt.isOrHasSuperclass(parent, SdkConstants.CONSTRAINT_LAYOUT);
    }

    public void killConstraint(@NotNull ConstraintAnchor.Type type) {
        if (type == null) {
            WidgetConstraintModel.$$$reportNull$$$0(2);
        }
        switch (type) {
            case LEFT: {
                this.removeAttribute(0);
                break;
            }
            case TOP: {
                this.removeAttribute(2);
                break;
            }
            case RIGHT: {
                this.removeAttribute(1);
                break;
            }
            case BOTTOM: {
                this.removeAttribute(3);
                break;
            }
            case BASELINE: {
                this.removeAttribute(4);
                break;
            }
        }
    }

    private void removeAttribute(int type) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        String label = "Constraint Disconnected";
        String[] attribute = ourDeleteAttributes[type];
        String[] namespace = ourDeleteNamespace[type];
        ComponentModification modification = new ComponentModification(this.myComponent, label);
        for (int i2 = 0; i2 < attribute.length; ++i2) {
            modification.setAttribute(namespace[i2], attribute[i2], null);
        }
        ConstraintComponentUtilities.ensureHorizontalPosition(this.myComponent, modification);
        ConstraintComponentUtilities.ensureVerticalPosition(this.myComponent, modification);
        modification.apply();
        modification.commit();
    }

    public void setHorizontalBias(int biasPercent) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        float bias = (float)biasPercent / 100.0f;
        String biasString = biasPercent == 50 ? null : Float.toString(bias);
        NlComponent chain = WidgetConstraintModel.findHorizontalChainHead(this.myComponent);
        if (chain != null && chain != this.myComponent) {
            this.setAttribute(chain, "http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", biasString);
        } else {
            this.setSherpaAttribute("layout_constraintHorizontal_bias", biasString);
        }
    }

    public void setVerticalBias(int biasPercent) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        float bias = 1.0f - (float)biasPercent / 100.0f;
        String biasString = biasPercent == 50 ? null : Float.toString(bias);
        NlComponent chain = WidgetConstraintModel.findVerticalChainHead(this.myComponent);
        if (chain != null && chain != this.myComponent) {
            this.setAttribute(chain, "http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", biasString);
        } else {
            this.setSherpaAttribute("layout_constraintVertical_bias", biasString);
        }
    }

    public float getVerticalBias() {
        String verticalBias = this.getVerticalBiasString();
        return WidgetConstraintModel.parseBiasStringFloat(verticalBias);
    }

    public float getHorizontalBias() {
        String horizontalBias = this.getHorizontalBiasString();
        return WidgetConstraintModel.parseBiasStringFloat(horizontalBias);
    }

    @Nullable
    public String getVerticalBiasString() {
        if (this.myComponent == null) {
            return null;
        }
        NlComponent source = WidgetConstraintModel.findVerticalChainHead(this.myComponent);
        if (source == null) {
            source = this.myComponent;
        }
        return source.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias");
    }

    @Nullable
    public String getHorizontalBiasString() {
        if (this.myComponent == null) {
            return null;
        }
        NlComponent source = WidgetConstraintModel.findHorizontalChainHead(this.myComponent);
        if (source == null) {
            source = this.myComponent;
        }
        return source.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias");
    }

    private static float parseBiasStringFloat(@Nullable String string) {
        if (string != null && !string.isEmpty()) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.5f;
    }

    private int getDimension(@NotNull String attribute) {
        if (attribute == null) {
            WidgetConstraintModel.$$$reportNull$$$0(3);
        }
        if (this.myComponent == null) {
            return 0;
        }
        String v = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute);
        if ("wrap_content".equalsIgnoreCase(v)) {
            return -1;
        }
        return ConstraintUtilities.getDpValue(this.myComponent, v);
    }

    private void setDimension(@Nullable String attribute, int currentValue) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        attribute = ConstraintComponentUtilities.mapStartEndStrings(this.myComponent, attribute);
        String marginString = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute);
        int marginValue = -1;
        if (marginString != null) {
            marginValue = ConstraintComponentUtilities.getDpValue(this.myComponent, this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute));
        }
        if (marginValue != -1 && marginValue == currentValue) {
            this.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginString);
        } else {
            String marginY = String.format("%ddp", currentValue);
            this.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginY);
        }
    }

    private void setAndroidAttribute(@NotNull String attribute, @Nullable String value2) {
        if (attribute == null) {
            WidgetConstraintModel.$$$reportNull$$$0(4);
        }
        this.setAttribute("http://schemas.android.com/apk/res/android", attribute, value2);
    }

    private void setSherpaAttribute(@NotNull String attribute, @Nullable String value2) {
        if (attribute == null) {
            WidgetConstraintModel.$$$reportNull$$$0(5);
        }
        this.setAttribute("http://schemas.android.com/apk/res-auto", attribute, value2);
    }

    private void setAttribute(@NotNull String nameSpace, @NotNull String attribute, @Nullable String value2) {
        if (nameSpace == null) {
            WidgetConstraintModel.$$$reportNull$$$0(6);
        }
        if (attribute == null) {
            WidgetConstraintModel.$$$reportNull$$$0(7);
        }
        if (this.myComponent != null) {
            this.setAttribute(this.myComponent, nameSpace, attribute, value2);
        }
    }

    private void setAttribute(@NotNull NlComponent component, @NotNull String nameSpace, @NotNull String attribute, @Nullable String value2) {
        if (component == null) {
            WidgetConstraintModel.$$$reportNull$$$0(8);
        }
        if (nameSpace == null) {
            WidgetConstraintModel.$$$reportNull$$$0(9);
        }
        if (attribute == null) {
            WidgetConstraintModel.$$$reportNull$$$0(10);
        }
        NlModel model = component.getModel();
        if (this.myModification == null || this.myModification.getComponent() != component) {
            this.myModification = new ComponentModification(component, "Change Widget");
        }
        this.myModification.setAttribute(nameSpace, attribute, value2);
        this.myModification.apply();
        model.notifyLiveUpdate(false);
        this.myTimer.setRepeats(false);
        this.myTimer.restart();
    }

    public int convertFromNL(@NotNull String attribute) {
        if (attribute == null) {
            WidgetConstraintModel.$$$reportNull$$$0(11);
        }
        if (this.myComponent == null) {
            return 2;
        }
        int dimen = this.getDimension(attribute);
        switch (dimen) {
            default: {
                return 0;
            }
            case -1: {
                return 2;
            }
            case 0: 
        }
        return 1;
    }

    @Nullable
    public static NlComponent findHorizontalChainHead(@NotNull NlComponent component) {
        if (component == null) {
            WidgetConstraintModel.$$$reportNull$$$0(12);
        }
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourRightAttributes, ConstraintComponentUtilities.ourLeftAttributes, component) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourLeftAttributes, ConstraintComponentUtilities.ourRightAttributes, component)) {
            return ConstraintComponentUtilities.findChainHead(component, ConstraintComponentUtilities.ourLeftAttributes, ConstraintComponentUtilities.ourRightAttributes);
        }
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes, component) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourEndAttributes, ConstraintComponentUtilities.ourStartAttributes, component)) {
            return ConstraintComponentUtilities.findChainHead(component, ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes);
        }
        return null;
    }

    @Nullable
    public static NlComponent findVerticalChainHead(@NotNull NlComponent component) {
        if (component == null) {
            WidgetConstraintModel.$$$reportNull$$$0(13);
        }
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourBottomAttributes, ConstraintComponentUtilities.ourTopAttributes, component) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBottomAttributes, component)) {
            return ConstraintComponentUtilities.findChainHead(component, ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBottomAttributes);
        }
        return null;
    }

    public void setAspect(String aspect) {
        this.setSherpaAttribute("layout_constraintDimensionRatio", aspect);
    }

    public void setTopMargin(int margin) {
        this.setDimension("layout_marginTop", margin);
    }

    public void setLeftMargin(int margin) {
        this.setDimension("layout_marginStart", margin);
        this.setDimension("layout_marginLeft", margin);
    }

    public void setRightMargin(int margin) {
        this.setDimension("layout_marginEnd", margin);
        this.setDimension("layout_marginRight", margin);
    }

    public void setBottomMargin(int margin) {
        this.setDimension("layout_marginBottom", margin);
    }

    public void killBaselineConstraint() {
        this.killConstraint(ConstraintAnchor.Type.BASELINE);
    }

    public void setHorizontalConstraint(int horizontalConstraint) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        String width = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        assert (width != null);
        if (width.endsWith("dp") && !width.equals("0dp")) {
            this.myComponent.putClientProperty("layout_width", width);
        }
        switch (horizontalConstraint) {
            case 1: {
                this.setAndroidAttribute("layout_width", "0dp");
                break;
            }
            case 0: {
                String oldValue = (String)this.myComponent.getClientProperty("layout_width");
                if (oldValue == null) {
                    oldValue = Coordinates.pxToDp(this.myComponent.getModel(), NlComponentHelperKt.getW(this.myComponent)) + "dp";
                }
                this.setAndroidAttribute("layout_width", oldValue);
                break;
            }
            case 2: {
                this.setAndroidAttribute("layout_width", "wrap_content");
            }
        }
    }

    public void setVerticalConstraint(int verticalConstraint) {
        if (this.myComponent == null || this.myIsInCallback) {
            return;
        }
        String height = this.myComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        assert (height != null);
        if (height.endsWith("dp") && !height.equals("0dp")) {
            this.myComponent.putClientProperty("layout_height", height);
        }
        switch (verticalConstraint) {
            case 1: {
                this.setAndroidAttribute("layout_height", "0dp");
                break;
            }
            case 0: {
                String oldValue = (String)this.myComponent.getClientProperty("layout_height");
                if (oldValue == null) {
                    oldValue = Coordinates.pxToDp(this.myComponent.getModel(), NlComponentHelperKt.getH(this.myComponent)) + "dp";
                }
                this.setAndroidAttribute("layout_height", oldValue);
                break;
            }
            case 2: {
                this.setAndroidAttribute("layout_height", "wrap_content");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelUpdateCallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameSpace";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpdateCallback";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "killConstraint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDimension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setAndroidAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setSherpaAttribute";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setAttribute";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "convertFromNL";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findHorizontalChainHead";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "findVerticalChainHead";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

