/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class ConstraintUtilities {
    private static HashMap<String, Integer> alignmentMap_ltr = new HashMap();
    private static HashMap<String, Integer> alignmentMap_rtl = new HashMap();
    static String[] mode = new String[]{"0", "1", "2", "3", "center", "START", "END"};

    public static int getAlignment(String s, boolean rtl) {
        HashMap<String, Integer> alignmentMap;
        HashMap<String, Integer> hashMap = alignmentMap = rtl ? alignmentMap_rtl : alignmentMap_ltr;
        if (alignmentMap.containsKey(s)) {
            return alignmentMap.get(s);
        }
        return 5;
    }

    static int getMargin(@NotNull NlComponent component, @NotNull String attr) {
        String margin;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(0);
        }
        if (attr == null) {
            ConstraintUtilities.$$$reportNull$$$0(1);
        }
        if ((margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", attr)) == null) {
            if (attr == "layout_marginStart") {
                margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
            } else if (attr == "layout_marginEnd") {
                margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
            }
        }
        if (margin != null) {
            return ConstraintUtilities.getDpValue(component, margin);
        }
        return 0;
    }

    public static boolean isInRTL(@NotNull NlComponent component) {
        Configuration configuration;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(2);
        }
        if ((configuration = component.getModel().getConfiguration()) == null) {
            return false;
        }
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier == null) {
            return false;
        }
        return qualifier.getValue() == LayoutDirection.RTL;
    }

    public static int getDpValue(@NotNull NlComponent component, String value2) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(3);
        }
        if (value2 != null && (resourceResolver = (configuration = component.getModel().getConfiguration()).getResourceResolver()) != null) {
            Integer px = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, value2, configuration);
            return px == null ? 0 : Coordinates.pxToDp(component.getModel(), (int)px);
        }
        return 0;
    }

    @NotNull
    static String resolveStringResource(@NotNull NlComponent component, @NotNull String text) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(4);
        }
        if (text == null) {
            ConstraintUtilities.$$$reportNull$$$0(5);
        }
        if ((resourceResolver = (configuration = component.getModel().getConfiguration()).getResourceResolver()) != null) {
            String string = ResourceHelper.resolveStringValue((RenderResources)resourceResolver, text);
            if (string == null) {
                ConstraintUtilities.$$$reportNull$$$0(6);
            }
            return string;
        }
        if ("" == null) {
            ConstraintUtilities.$$$reportNull$$$0(7);
        }
        return "";
    }

    @NotNull
    public static String getResolvedText(@NotNull NlComponent component) {
        String text;
        if (component == null) {
            ConstraintUtilities.$$$reportNull$$$0(8);
        }
        if ((text = component.getAttribute("http://schemas.android.com/tools", "text")) != null) {
            if (text.startsWith("@")) {
                if (!text.startsWith("@sample/") && !text.startsWith("@tools:sample/")) {
                    String string = ConstraintUtilities.resolveStringResource(component, text);
                    if (string == null) {
                        ConstraintUtilities.$$$reportNull$$$0(9);
                    }
                    return string;
                }
                if ("" == null) {
                    ConstraintUtilities.$$$reportNull$$$0(10);
                }
                return "";
            }
            String string = text;
            if (string == null) {
                ConstraintUtilities.$$$reportNull$$$0(11);
            }
            return string;
        }
        text = component.getAttribute("http://schemas.android.com/apk/res/android", "text");
        if (text != null) {
            if (text.startsWith("@")) {
                String string = ConstraintUtilities.resolveStringResource(component, text);
                if (string == null) {
                    ConstraintUtilities.$$$reportNull$$$0(12);
                }
                return string;
            }
            String string = text;
            if (string == null) {
                ConstraintUtilities.$$$reportNull$$$0(13);
            }
            return string;
        }
        if ("" == null) {
            ConstraintUtilities.$$$reportNull$$$0(14);
        }
        return "";
    }

    static {
        alignmentMap_rtl.put("center", 4);
        alignmentMap_rtl.put("textStart", 2);
        alignmentMap_rtl.put("textEnd", 3);
        alignmentMap_rtl.put("viewStart", 6);
        alignmentMap_rtl.put("viewEnd", 5);
        alignmentMap_ltr.put("center", 4);
        alignmentMap_ltr.put("textStart", 2);
        alignmentMap_ltr.put("textEnd", 3);
        alignmentMap_ltr.put("viewStart", 5);
        alignmentMap_ltr.put("viewEnd", 6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveStringResource";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMargin";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInRTL";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDpValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveStringResource";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

