/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import android.view.View;
import android.view.ViewGroup;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;

public final class ScrollViewScrollHandler
implements ScrollHandler {
    private final int myMaxScrollableSize;
    private final int myScrollUnitSize;
    private final int myStartScrollPosition;
    @NotNull
    private final IntConsumer myScrollSetter;
    @NotNull
    private final IntSupplier myScrollGetter;
    @NotNull
    private final Runnable myScrollHandler;

    ScrollViewScrollHandler(int maxScrollableSize, int scrollUnitSize, @NotNull IntConsumer scrollSetter, @NotNull IntSupplier scrollGetter, @NotNull Runnable scrollHandler) {
        if (scrollSetter == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(0);
        }
        if (scrollGetter == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(1);
        }
        if (scrollHandler == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(2);
        }
        this.myMaxScrollableSize = maxScrollableSize;
        this.myScrollUnitSize = scrollUnitSize;
        this.myScrollSetter = scrollSetter;
        this.myScrollGetter = scrollGetter;
        this.myStartScrollPosition = scrollGetter.getAsInt();
        this.myScrollHandler = scrollHandler;
    }

    @NotNull
    public static ScrollViewScrollHandler createHandler(@NotNull View view, int maxScrollableSize, int scrollUnitSize, @NotNull Orientation orientation) {
        if (view == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(3);
        }
        if (orientation == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(4);
        }
        ScrollViewScrollHandler scrollViewScrollHandler = new ScrollViewScrollHandler(maxScrollableSize, scrollUnitSize, orientation == Orientation.VERTICAL ? arg_0 -> ((View)view).setScrollY(arg_0) : arg_0 -> ((View)view).setScrollX(arg_0), orientation == Orientation.VERTICAL ? () -> ((View)view).getScrollY() : () -> ((View)view).getScrollX(), () -> ScrollViewScrollHandler.handleScrolling(view));
        if (scrollViewScrollHandler == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(5);
        }
        return scrollViewScrollHandler;
    }

    private static void handleScrolling(@NotNull View view) {
        if (view == null) {
            ScrollViewScrollHandler.$$$reportNull$$$0(6);
        }
        int scrollPosX = view.getScrollX();
        int scrollPosY = view.getScrollY();
        if (scrollPosX != 0 || scrollPosY != 0) {
            if (view.isNestedScrollingEnabled()) {
                int[] consumed = new int[2];
                int axis = scrollPosX != 0 ? 1 : 0;
                if (view.startNestedScroll(axis |= scrollPosY != 0 ? 2 : 0)) {
                    view.dispatchNestedPreScroll(scrollPosX, scrollPosY, consumed, null);
                    view.dispatchNestedScroll(consumed[0], consumed[1], scrollPosX, scrollPosY, null);
                    view.stopNestedScroll();
                    scrollPosX -= consumed[0];
                    scrollPosY -= consumed[1];
                }
            }
            if (scrollPosX != 0 || scrollPosY != 0) {
                view.scrollTo(scrollPosX, scrollPosY);
            }
        }
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup group = (ViewGroup)view;
        for (int i2 = 0; i2 < group.getChildCount(); ++i2) {
            View child = group.getChildAt(i2);
            ScrollViewScrollHandler.handleScrolling(child);
        }
    }

    @Override
    public int update(int scrollAmount) {
        int currentScrollPosition = this.myScrollGetter.getAsInt();
        int newScrollPos = Math.min(this.myMaxScrollableSize, Math.max(0, this.myStartScrollPosition + scrollAmount * this.myScrollUnitSize));
        if (newScrollPos == currentScrollPosition) {
            return 0;
        }
        this.myScrollSetter.accept(newScrollPos);
        this.myScrollHandler.run();
        return newScrollPos - currentScrollPosition;
    }

    @Override
    public void commit(int scrollAmount) {
        this.update(scrollAmount);
    }

    @Override
    public boolean canScroll(int scrollAmount) {
        if (this.myScrollGetter.getAsInt() == 0 && scrollAmount < 0) {
            return false;
        }
        return this.myScrollGetter.getAsInt() != this.myMaxScrollableSize || scrollAmount <= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollSetter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollGetter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollHandler";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/api/ScrollViewScrollHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/api/ScrollViewScrollHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleScrolling";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

