/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.adaptiveicon;

import com.android.resources.Density;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class DensityMenuAction
extends DropDownAction {
    private static final Density[] DENSITIES = new Density[]{Density.MEDIUM, Density.HIGH, Density.XHIGH, Density.XXHIGH, Density.XXXHIGH};
    private final NlModel myModel;

    public DensityMenuAction(@NotNull NlModel model) {
        if (model == null) {
            DensityMenuAction.$$$reportNull$$$0(0);
        }
        super("", "Device Screen Density", null);
        this.myModel = model;
        for (Density density : DENSITIES) {
            this.add(new SetDensityAction(this.myModel, density));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DensityMenuAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        int currentValue = this.myModel.getConfiguration().getDensity().getDpiValue();
        for (int i2 = 0; i2 < DENSITIES.length; ++i2) {
            if (DENSITIES[i2].getDpiValue() < currentValue && i2 != DENSITIES.length - 1) continue;
            e.getPresentation().setText(DENSITIES[i2].getResourceValue());
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/adaptiveicon/DensityMenuAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SetDensityAction
    extends AnAction {
        private final NlModel myModel;
        private final Density myDensity;

        private SetDensityAction(@NotNull NlModel model, @NotNull Density density) {
            if (model == null) {
                SetDensityAction.$$$reportNull$$$0(0);
            }
            if (density == null) {
                SetDensityAction.$$$reportNull$$$0(1);
            }
            super(density.getResourceValue());
            this.myModel = model;
            this.myDensity = density;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SetDensityAction.$$$reportNull$$$0(2);
            }
            NlModelHelperKt.overrideConfigurationDensity(this.myModel, this.myDensity);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "density";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/adaptiveicon/DensityMenuAction$SetDensityAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

