/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.editor.NlEditor;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.util.NlTreeDumper;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.uibuilder.editor.NlPreviewManager;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import icons.StudioIcons;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateLayoutTestSkeletonAction
extends AnAction {
    private static final Pattern XML_PROLOG = Pattern.compile("^<\\?xml version.*$");

    public GenerateLayoutTestSkeletonAction() {
        super("Generate LayoutTest Skeleton");
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(0);
        }
        event.getPresentation().setEnabled(GenerateLayoutTestSkeletonAction.getModel(event.getProject()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        NlModel model;
        if (event == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(1);
        }
        if ((model = GenerateLayoutTestSkeletonAction.getModel(event.getProject())) == null) {
            return;
        }
        int option = Messages.showDialog((Project)model.getProject(), (String)"Generate LayoutTest skeleton with the current layout components.", (String)"Generate LayoutTest Skeleton", (String[])new String[]{"Copy to Clipboard", "Cancel"}, (int)0, (Icon)StudioIcons.Shell.Filetree.ANDROID_TEST_ROOT);
        if (option == 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(GenerateLayoutTestSkeletonAction.generateModelFixture(model)));
        }
    }

    @Nullable
    private static NlModel getModel(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        DesignSurface surface = GenerateLayoutTestSkeletonAction.getSurface(project);
        if (surface == null) {
            return null;
        }
        SceneView screenView = surface.getCurrentSceneView();
        if (screenView == null) {
            return null;
        }
        return screenView.getModel();
    }

    @Nullable
    private static DesignSurface getSurface(@NotNull Project project) {
        FileEditor[] editors;
        if (project == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(2);
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : editors = fileEditorManager.getSelectedEditors()) {
            if (!(fileEditor instanceof NlEditor)) continue;
            return ((NlEditor)fileEditor).getComponent().getSurface();
        }
        Editor editor2 = fileEditorManager.getSelectedTextEditor();
        if (editor2 == null) {
            return null;
        }
        NlPreviewManager previewManager = NlPreviewManager.getInstance(project);
        if (previewManager.isWindowVisible()) {
            return previewManager.getPreviewForm().getSurface();
        }
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project);
        if (file == null) {
            return null;
        }
        for (FileEditor fileEditor : fileEditorManager.getEditors(file.getVirtualFile())) {
            if (!(fileEditor instanceof NlEditor)) continue;
            return ((NlEditor)fileEditor).getComponent().getSurface();
        }
        return null;
    }

    @NotNull
    private static String generateModelFixture(@NotNull NlModel model) {
        if (model == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(3);
        }
        ImmutableList<NlComponent> components = model.getComponents();
        StringBuilder builder = new StringBuilder();
        builder.append("import com.android.tools.idea.uibuilder.LayoutTestCase;\n").append("import com.android.tools.idea.uibuilder.fixtures.ModelBuilder;\n").append("import com.android.tools.idea.uibuilder.model.NlModel;\n").append("import com.android.tools.idea.uibuilder.util.NlTreeDumper;\n").append("import org.jetbrains.annotations.NotNull;\n").append("\n").append("import static com.android.SdkConstants.*;\n").append("\n").append("public class NewTest extends LayoutTestCase {\n").append("\n").append("  // TODO: Rename this test method\n").append("  public void testRenameThis() {\n").append("    NlModel model = createModel();\n").append("  }\n").append("\n").append("  @NotNull\n").append("  private NlModel createModel() {\n").append("    ModelBuilder builder = model(\"").append(model.getFile().getName()).append("\",\n");
        for (NlComponent component : components) {
            GenerateLayoutTestSkeletonAction.appendComponent(component, "\"    ModelBuilder builder = model(".length(), builder);
        }
        builder.append(");\n");
        builder.append("    NlModel model = builder.build();\n").append("    format(model.getFile());\n").append("    assertEquals(").append(components.size()).append(", model.getComponents().size());\n");
        GenerateLayoutTestSkeletonAction.appendTreeComparison(components, builder);
        GenerateLayoutTestSkeletonAction.appendXmlComparison(model, builder);
        builder.append("\n").append("    return model;\n").append("  }\n").append("}\n");
        String string = builder.toString();
        if (string == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void appendComponent(@NotNull NlComponent component, int indent, @NotNull StringBuilder builder) {
        if (component == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(6);
        }
        builder.append(StringUtil.repeat((String)" ", (int)indent)).append("component(").append(GenerateLayoutTestSkeletonAction.getTagSymbol(component.getTagName())).append(")\n").append(StringUtil.repeat((String)" ", (int)(indent + 2))).append(GenerateLayoutTestSkeletonAction.makeBounds(component)).append("\n");
        for (AttributeSnapshot attribute : component.getAttributes()) {
            GenerateLayoutTestSkeletonAction.appendAttribute(attribute, indent + 4, builder);
        }
        if (component.getChildCount() > 0) {
            builder.append(StringUtil.repeat((String)" ", (int)(indent + 2))).append(".children(\n");
            for (NlComponent child : component.getChildren()) {
                GenerateLayoutTestSkeletonAction.appendComponent(child, indent + 4, builder);
                builder.replace(builder.length() - 1, builder.length(), ",\n\n");
            }
            builder.replace(builder.length() - 3, builder.length(), ")\n");
        }
    }

    private static void appendAttribute(@NotNull AttributeSnapshot attribute, int indent, @NotNull StringBuilder builder) {
        if (attribute == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(8);
        }
        if (GenerateLayoutTestSkeletonAction.implicitAttribute(attribute)) {
            return;
        }
        assert (attribute.value != null);
        if ("android".equals(attribute.prefix)) {
            switch (attribute.name) {
                case "id": {
                    GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".id", attribute.value, builder);
                    return;
                }
                case "text": {
                    GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".text", attribute.value, builder);
                    return;
                }
                case "layout_height": {
                    GenerateLayoutTestSkeletonAction.appendHeightOrWidth(indent, attribute.value, "height", builder);
                    return;
                }
                case "layout_width": {
                    GenerateLayoutTestSkeletonAction.appendHeightOrWidth(indent, attribute.value, "width", builder);
                    return;
                }
            }
        }
        GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".withAttribute", attribute.prefix, attribute.name, attribute.value, builder);
    }

    private static void appendHeightOrWidth(int indent, @NotNull String value2, @NotNull String orientation, @NotNull StringBuilder builder) {
        if (value2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(9);
        }
        if (orientation == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(11);
        }
        switch (value2) {
            case "wrap_content": {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".wrapContent" + StringUtil.capitalize((String)orientation), builder);
                break;
            }
            case "match_parent": {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".matchParent" + StringUtil.capitalize((String)orientation), builder);
                break;
            }
            default: {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, "." + orientation, value2, builder);
            }
        }
    }

    private static void appendAttribute(int indent, @NotNull String with2, @NotNull StringBuilder builder) {
        if (with2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(13);
        }
        builder.append(StringUtil.repeat((String)" ", (int)indent)).append(with2).append("()\n");
    }

    private static void appendAttribute(int indent, @NotNull String with2, @Nullable String value2, @NotNull StringBuilder builder) {
        if (with2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(14);
        }
        if (builder == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(15);
        }
        GenerateLayoutTestSkeletonAction.appendAttribute(indent, with2, null, null, value2, builder);
    }

    private static void appendAttribute(int indent, @NotNull String with2, @Nullable String prefix, @Nullable String name, @Nullable String value2, @NotNull StringBuilder builder) {
        if (with2 == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(16);
        }
        if (builder == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(17);
        }
        if (value2 == null) {
            return;
        }
        builder.append(StringUtil.repeat((String)" ", (int)indent)).append(with2).append("(\"");
        if (prefix != null) {
            builder.append(prefix).append(":");
        }
        if (name != null) {
            builder.append(name).append("\", \"");
        }
        builder.append(value2).append("\")\n");
    }

    private static boolean implicitAttribute(@NotNull AttributeSnapshot attribute) {
        if (attribute == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(18);
        }
        if ("xmlns".equals(attribute.prefix)) {
            return true;
        }
        return attribute.value == null;
    }

    @NotNull
    private static String makeBounds(@NotNull NlComponent component) {
        if (component == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(19);
        }
        Rectangle bounds = GenerateLayoutTestSkeletonAction.getBounds(component);
        String string = String.format(".withBounds(%d, %d, %d, %d)", bounds.x, bounds.y, bounds.width, bounds.height);
        if (string == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static Rectangle getBounds(@NotNull NlComponent component) {
        NlComponent parent;
        if (component == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(21);
        }
        Rectangle parentBounds = (parent = component.getParent()) != null ? GenerateLayoutTestSkeletonAction.getBounds(parent) : new Rectangle(0, 0, 1000, 1000);
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        if (viewInfo == null) {
            Rectangle rectangle = new Rectangle(parentBounds.x, parentBounds.y, 100, 100);
            if (rectangle == null) {
                GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(22);
            }
            return rectangle;
        }
        Rectangle rectangle = new Rectangle(viewInfo.getLeft() + parentBounds.x, viewInfo.getTop() + parentBounds.y, viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
        if (rectangle == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(23);
        }
        return rectangle;
    }

    @NotNull
    private static String getTagSymbol(@NotNull String tagName) {
        if (tagName == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(24);
        }
        tagName = tagName.substring(1 + tagName.lastIndexOf(46));
        String string = TemplateUtils.camelCaseToUnderlines(tagName).toUpperCase(Locale.ROOT);
        if (string == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static void appendTreeComparison(@NotNull List<NlComponent> components, @NotNull StringBuilder builder) {
        if (components == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(26);
        }
        if (builder == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(27);
        }
        GenerateLayoutTestSkeletonAction.appendMultilineAssert(NlTreeDumper.dumpTree(components), "NlTreeDumper.dumpTree(model.getComponents())", builder, (List<Pattern>)ImmutableList.of(), false);
    }

    private static void appendXmlComparison(@NotNull NlModel model, @NotNull StringBuilder builder) {
        if (model == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(28);
        }
        if (builder == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(29);
        }
        GenerateLayoutTestSkeletonAction.appendMultilineAssert(model.getFile().getText(), "model.getFile().getText()", builder, (List<Pattern>)ImmutableList.of((Object)XML_PROLOG), true);
    }

    private static void appendMultilineAssert(@NotNull String expectedMultilineResult, @NotNull String subject, @NotNull StringBuilder builder, @NotNull List<Pattern> lineFilters, boolean addNewlineToLastLine) {
        if (expectedMultilineResult == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(30);
        }
        if (subject == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(31);
        }
        if (builder == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(32);
        }
        if (lineFilters == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(33);
        }
        String assertEquals = "    assertEquals(";
        builder.append(assertEquals);
        String lastLine = "";
        int indent = 0;
        for (String line : Splitter.on((String)"\n").split((CharSequence)expectedMultilineResult)) {
            if (GenerateLayoutTestSkeletonAction.matches(line, lineFilters)) continue;
            builder.append(StringUtil.repeat((String)" ", (int)indent));
            builder.append("\"").append(line.replace("\"", "\\\"")).append("\\n\" +\n");
            indent = assertEquals.length();
            lastLine = line;
        }
        if (indent > 0) {
            builder.setLength(builder.length() - 6);
            if (lastLine.isEmpty()) {
                builder.setLength(builder.length() - 1 - indent - 6);
            }
            if (addNewlineToLastLine) {
                builder.append("\\n");
            }
            builder.append("\",\n");
        } else {
            builder.append("\"\",\n");
        }
        builder.append(StringUtil.repeat((String)" ", (int)assertEquals.length()));
        builder.append(subject).append(");\n");
    }

    private static boolean matches(@NotNull String line, @NotNull List<Pattern> lineFilters) {
        if (line == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(34);
        }
        if (lineFilters == null) {
            GenerateLayoutTestSkeletonAction.$$$reportNull$$$0(35);
        }
        for (Pattern pattern : lineFilters) {
            if (!pattern.matcher(line).matches()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 20: 
            case 22: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 20: 
            case 22: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 20: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction";
                break;
            }
            case 5: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 27: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "with";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedMultilineResult";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineFilters";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateModelFixture";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "makeBounds";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBounds";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSurface";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateModelFixture";
                break;
            }
            case 4: 
            case 20: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendComponent";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "appendAttribute";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendHeightOrWidth";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "implicitAttribute";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeBounds";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBounds";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTagSymbol";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendTreeComparison";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "appendXmlComparison";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "appendMultilineAssert";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 20: 
            case 22: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

