/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.validation.validators;

import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.tools.adtui.validation.Validator;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class PathValidator
implements Validator<File> {
    public static final Rule IS_EMPTY = new SimpleRule(){

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                1.$$$reportNull$$$0(0);
            }
            if (file == null) {
                1.$$$reportNull$$$0(1);
            }
            return file.getName().isEmpty();
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                1.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                1.$$$reportNull$$$0(3);
            }
            String string = String.format("Please specify a %1$s.", fieldName);
            if (string == null) {
                1.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule INVALID_SLASHES = new SimpleRule(){

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                2.$$$reportNull$$$0(0);
            }
            if (file == null) {
                2.$$$reportNull$$$0(1);
            }
            String path = file.getPath();
            return File.separatorChar == '/' && path.contains("\\") || File.separatorChar == '\\' && path.contains("/");
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                2.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                2.$$$reportNull$$$0(3);
            }
            if (File.separatorChar == '\\') {
                String string = String.format("Your %1$s contains incorrect slashes ('/').", fieldName);
                if (string == null) {
                    2.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = String.format("Your %1$s contains incorrect slashes ('\\').", fieldName);
            if (string == null) {
                2.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$2";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule WHITESPACE = new RecursiveRule(){

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                3.$$$reportNull$$$0(0);
            }
            if (file == null) {
                3.$$$reportNull$$$0(1);
            }
            return CharMatcher.whitespace().matchesAnyOf((CharSequence)file.getName());
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                3.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                3.$$$reportNull$$$0(3);
            }
            String string = String.format("%1$s should not contain whitespace, as this can cause problems with the NDK tools.", fieldName);
            if (string == null) {
                3.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$3";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule NON_ASCII_CHARS = new RecursiveRule(){

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                4.$$$reportNull$$$0(0);
            }
            if (file == null) {
                4.$$$reportNull$$$0(1);
            }
            return !CharMatcher.ascii().matchesAllOf((CharSequence)file.getName());
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                4.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                4.$$$reportNull$$$0(3);
            }
            String string = String.format("Your %1$s contains non-ASCII characters.", fieldName);
            if (string == null) {
                4.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$4";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$4";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule PARENT_DIRECTORY_NOT_WRITABLE = new RecursiveRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                5.$$$reportNull$$$0(0);
            }
            if (file == null) {
                5.$$$reportNull$$$0(1);
            }
            File parent = file.getParentFile();
            return !fileOp.exists(file) && parent != null && fileOp.exists(parent) && !fileOp.canWrite(parent);
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                5.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                5.$$$reportNull$$$0(3);
            }
            String string = String.format("The path '%1$s' is not writable. Please choose a new location.", file.getParentFile().getPath());
            if (string == null) {
                5.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$5";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$5";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule LOCATION_IS_A_FILE = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                6.$$$reportNull$$$0(0);
            }
            if (file == null) {
                6.$$$reportNull$$$0(1);
            }
            return fileOp.isFile(file);
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                6.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                6.$$$reportNull$$$0(3);
            }
            String string = String.format("The %1$s specified already exists.", fieldName);
            if (string == null) {
                6.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$6";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$6";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule LOCATION_IS_ROOT = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                7.$$$reportNull$$$0(0);
            }
            if (file == null) {
                7.$$$reportNull$$$0(1);
            }
            return file.getParent() == null;
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                7.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                7.$$$reportNull$$$0(3);
            }
            String string = String.format("The %1$s cannot be at the filesystem root.", fieldName);
            if (string == null) {
                7.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$7";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$7";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule PARENT_IS_NOT_A_DIRECTORY = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            File parent;
            if (fileOp == null) {
                8.$$$reportNull$$$0(0);
            }
            if (file == null) {
                8.$$$reportNull$$$0(1);
            }
            return (parent = file.getParentFile()) != null && fileOp.exists(parent) && !fileOp.isDirectory(parent);
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                8.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                8.$$$reportNull$$$0(3);
            }
            String string = String.format("The %1$s's parent must be a directory, not a plain file.", fieldName);
            if (string == null) {
                8.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$8";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$8";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule PATH_NOT_WRITABLE = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                9.$$$reportNull$$$0(0);
            }
            if (file == null) {
                9.$$$reportNull$$$0(1);
            }
            return fileOp.exists(file) && !fileOp.canWrite(file);
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                9.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                9.$$$reportNull$$$0(3);
            }
            String string = String.format("The path '%1$s' is not writable. Please choose a new location.", file.getPath());
            if (string == null) {
                9.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$9";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$9";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule PATH_INSIDE_ANDROID_STUDIO = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            String installLocation;
            if (fileOp == null) {
                10.$$$reportNull$$$0(0);
            }
            if (file == null) {
                10.$$$reportNull$$$0(1);
            }
            return (installLocation = PathManager.getHomePathFor(Application.class)) != null && FileUtil.isAncestor((File)new File(installLocation), (File)file, (boolean)false);
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                10.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                10.$$$reportNull$$$0(3);
            }
            String applicationName = ApplicationNamesInfo.getInstance().getProductName();
            String string = String.format("The %1$s is inside %2$s's install location.", fieldName, applicationName);
            if (string == null) {
                10.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$10";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$10";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule NON_EMPTY_DIRECTORY = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                11.$$$reportNull$$$0(0);
            }
            if (file == null) {
                11.$$$reportNull$$$0(1);
            }
            return fileOp.listFiles(file).length > 0;
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                11.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                11.$$$reportNull$$$0(3);
            }
            String string = String.format("'%1s' already exists at the specified %2$s.", file.getName(), fieldName);
            if (string == null) {
                11.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$11";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$11";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule ILLEGAL_WINDOWS_FILENAME = new RecursiveRule(){
        private final Set<String> RESERVED_WINDOWS_FILENAMES = ImmutableSet.of((Object)"con", (Object)"prn", (Object)"aux", (Object)"clock$", (Object)"nul", (Object)"com1", (Object[])new String[]{"com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "$mft", "$mftmirr", "$logfile", "$volume", "$attrdef", "$bitmap", "$boot", "$badclus", "$secure", "$upcase", "$extend", "$quota", "$objid", "$reparse"});

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                12.$$$reportNull$$$0(0);
            }
            if (file == null) {
                12.$$$reportNull$$$0(1);
            }
            return this.RESERVED_WINDOWS_FILENAMES.contains(file.getName().toLowerCase(Locale.US));
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                12.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                12.$$$reportNull$$$0(3);
            }
            String string = String.format("Illegal (Windows) filename in %1$s path: %2$s.", fieldName, file.getName());
            if (string == null) {
                12.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$12";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$12";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule PATH_TOO_LONG = new SimpleRule(){
        private static final int WINDOWS_PATH_LENGTH_LIMIT = 100;

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                13.$$$reportNull$$$0(0);
            }
            if (file == null) {
                13.$$$reportNull$$$0(1);
            }
            return file.getAbsolutePath().length() > 100;
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                13.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                13.$$$reportNull$$$0(3);
            }
            String string = String.format("The length of the %1$s exceeds the limit of %2$d characters.", fieldName, 100);
            if (string == null) {
                13.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$13";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$13";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Rule ILLEGAL_CHARACTER = new RecursiveRule(){
        private final CharMatcher ILLEGAL_CHARACTER_MATCHER = CharMatcher.anyOf((CharSequence)"[/\\\\?%*:|\"<>!;]");

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                14.$$$reportNull$$$0(0);
            }
            if (file == null) {
                14.$$$reportNull$$$0(1);
            }
            return this.ILLEGAL_CHARACTER_MATCHER.matchesAnyOf((CharSequence)file.getName());
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                14.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                14.$$$reportNull$$$0(3);
            }
            String name = file.getName();
            char illegalChar = name.charAt(this.ILLEGAL_CHARACTER_MATCHER.indexIn((CharSequence)name));
            String string = String.format("Illegal character in %1$s path: '%2$c' in filename %3$s.", fieldName, Character.valueOf(illegalChar), name);
            if (string == null) {
                14.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$14";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$14";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    private final String myPathName;
    @NotNull
    private final Iterable<Rule> myErrors;
    @NotNull
    private final Iterable<Rule> myWarnings;
    @NotNull
    private final FileOp myFileOp;

    private PathValidator(@NotNull String pathName, @NotNull Iterable<Rule> errors, @NotNull Iterable<Rule> warnings, @NotNull FileOp fileOp) {
        if (pathName == null) {
            PathValidator.$$$reportNull$$$0(0);
        }
        if (errors == null) {
            PathValidator.$$$reportNull$$$0(1);
        }
        if (warnings == null) {
            PathValidator.$$$reportNull$$$0(2);
        }
        if (fileOp == null) {
            PathValidator.$$$reportNull$$$0(3);
        }
        this.myPathName = pathName;
        this.myErrors = errors;
        this.myWarnings = warnings;
        this.myFileOp = fileOp;
    }

    public static PathValidator createDefault(@NotNull String pathName) {
        if (pathName == null) {
            PathValidator.$$$reportNull$$$0(4);
        }
        return new Builder().withAllRules(Validator.Severity.ERROR).build(pathName);
    }

    private static Logger getLogger() {
        return Logger.getInstance(PathValidator.class);
    }

    @NotNull
    public Validator.Result validate(@NotNull File file) {
        block9: {
            Validator.Result result2;
            block8: {
                Validator.Result result3;
                if (file == null) {
                    PathValidator.$$$reportNull$$$0(5);
                }
                try {
                    result2 = this.validate(file, Validator.Severity.ERROR);
                    if (result2 == Validator.Result.OK) break block8;
                    result3 = result2;
                }
                catch (Exception ex) {
                    PathValidator.getLogger().warn((Throwable)ex);
                    Validator.Result result4 = new Validator.Result(Validator.Severity.ERROR, String.format("Invalid file, see Help -> Show Log for more details: %1$s", file));
                    if (result4 == null) {
                        PathValidator.$$$reportNull$$$0(8);
                    }
                    return result4;
                }
                if (result3 == null) {
                    PathValidator.$$$reportNull$$$0(6);
                }
                return result3;
            }
            result2 = this.validate(file, Validator.Severity.WARNING);
            if (result2 == Validator.Result.OK) break block9;
            Validator.Result result5 = result2;
            if (result5 == null) {
                PathValidator.$$$reportNull$$$0(7);
            }
            return result5;
        }
        Validator.Result result6 = Validator.Result.OK;
        if (result6 == null) {
            PathValidator.$$$reportNull$$$0(9);
        }
        return result6;
    }

    @NotNull
    private Validator.Result validate(@NotNull File projectFile, @NotNull Validator.Severity severity) {
        if (projectFile == null) {
            PathValidator.$$$reportNull$$$0(10);
        }
        if (severity == null) {
            PathValidator.$$$reportNull$$$0(11);
        }
        assert (severity != Validator.Severity.OK);
        Iterable<Rule> rules = severity == Validator.Severity.ERROR ? this.myErrors : this.myWarnings;
        for (Rule rule : rules) {
            File matchingFile = rule.getMatchingFile(this.myFileOp, projectFile);
            if (matchingFile == null) continue;
            Validator.Result result2 = new Validator.Result(severity, rule.getMessage(matchingFile, this.myPathName));
            if (result2 == null) {
                PathValidator.$$$reportNull$$$0(12);
            }
            return result2;
        }
        Validator.Result result3 = Validator.Result.OK;
        if (result3 == null) {
            PathValidator.$$$reportNull$$$0(13);
        }
        return result3;
    }

    @NotNull
    public Iterable<Rule> getErrors() {
        Iterable<Rule> iterable = this.myErrors;
        if (iterable == null) {
            PathValidator.$$$reportNull$$$0(14);
        }
        return iterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDefault";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class RecursiveRule
    implements Rule {
        private RecursiveRule() {
        }

        @Override
        @Nullable
        public final File getMatchingFile(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                RecursiveRule.$$$reportNull$$$0(0);
            }
            if (file == null) {
                RecursiveRule.$$$reportNull$$$0(1);
            }
            for (File currFile = file; currFile != null; currFile = currFile.getParentFile()) {
                if (!this.matches(fileOp, currFile)) continue;
                return currFile;
            }
            return null;
        }

        protected abstract boolean matches(@NotNull FileOp var1, @NotNull File var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileOp";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$RecursiveRule";
            objectArray[2] = "getMatchingFile";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class SimpleRule
    implements Rule {
        private SimpleRule() {
        }

        @Override
        @Nullable
        public final File getMatchingFile(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                SimpleRule.$$$reportNull$$$0(0);
            }
            if (file == null) {
                SimpleRule.$$$reportNull$$$0(1);
            }
            return this.matches(fileOp, file) ? file : null;
        }

        protected abstract boolean matches(@NotNull FileOp var1, @NotNull File var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileOp";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$SimpleRule";
            objectArray[2] = "getMatchingFile";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Builder {
        private final List<Rule> myErrors = Lists.newArrayList();
        private final List<Rule> myWarnings = Lists.newArrayList();

        @NotNull
        public Builder withAllRules(@NotNull Validator.Severity pathNotWritable) {
            if (pathNotWritable == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.withCommonRules();
            this.withRule(IS_EMPTY, Validator.Severity.ERROR);
            this.withRule(PATH_NOT_WRITABLE, pathNotWritable);
            this.withRule(NON_EMPTY_DIRECTORY, Validator.Severity.WARNING);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder withCommonRules() {
            this.withCommonTestRules();
            if (SystemInfo.isWindows) {
                this.withRule(PATH_TOO_LONG, Validator.Severity.ERROR);
            }
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder withCommonTestRules() {
            this.withRule(INVALID_SLASHES, Validator.Severity.ERROR);
            this.withRule(ILLEGAL_CHARACTER, Validator.Severity.ERROR);
            this.withRule(ILLEGAL_WINDOWS_FILENAME, SystemInfo.isWindows ? Validator.Severity.ERROR : Validator.Severity.WARNING);
            this.withRule(WHITESPACE, Validator.Severity.WARNING);
            this.withRule(NON_ASCII_CHARS, SystemInfo.isWindows ? Validator.Severity.ERROR : Validator.Severity.WARNING);
            this.withRule(PARENT_DIRECTORY_NOT_WRITABLE, Validator.Severity.ERROR);
            this.withRule(LOCATION_IS_A_FILE, Validator.Severity.ERROR);
            this.withRule(LOCATION_IS_ROOT, Validator.Severity.ERROR);
            this.withRule(PARENT_IS_NOT_A_DIRECTORY, Validator.Severity.ERROR);
            this.withRule(PATH_INSIDE_ANDROID_STUDIO, Validator.Severity.ERROR);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        public Builder withRule(@NotNull Rule rule, @NotNull Validator.Severity severity) {
            if (rule == null) {
                Builder.$$$reportNull$$$0(4);
            }
            if (severity == null) {
                Builder.$$$reportNull$$$0(5);
            }
            switch (severity) {
                case ERROR: {
                    this.myErrors.add(rule);
                    break;
                }
                case WARNING: {
                    this.myWarnings.add(rule);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Can't create rule with invalid severity %1$s", severity));
                }
            }
            return this;
        }

        @NotNull
        public PathValidator build(@NotNull String pathName) {
            if (pathName == null) {
                Builder.$$$reportNull$$$0(6);
            }
            PathValidator pathValidator = this.build(pathName, FileOpUtils.create());
            if (pathValidator == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return pathValidator;
        }

        @NotNull
        public PathValidator build(@NotNull String pathName, @NotNull FileOp fileOp) {
            if (pathName == null) {
                Builder.$$$reportNull$$$0(8);
            }
            if (fileOp == null) {
                Builder.$$$reportNull$$$0(9);
            }
            PathValidator pathValidator = new PathValidator(pathName, this.myErrors, this.myWarnings, fileOp);
            if (pathValidator == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return pathValidator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathNotWritable";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/validation/validators/PathValidator$Builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rule";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathName";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/validation/validators/PathValidator$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAllRules";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withCommonRules";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withCommonTestRules";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withAllRules";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 10: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withRule";
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Rule {
        @Nullable
        public File getMatchingFile(@NotNull FileOp var1, @NotNull File var2);

        @NotNull
        public String getMessage(@NotNull File var1, @NotNull String var2);
    }
}

