/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.preview;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItemResolver;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserItem;
import com.android.tools.idea.ui.resourcechooser.icons.IconFactory;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ResourceDrawablePanel
extends JBScrollPane
implements ActionListener {
    @NotNull
    private final Configuration myConfiguration;
    @NotNull
    private final Module myModule;
    @NotNull
    private final IconFactory myIconFactory;
    @NotNull
    private final AndroidFacet myFacet;
    private JBLabel myNameLabel;
    private JBLabel myImageLabel;
    private JComboBox myQualifierCombo;
    private JBLabel myTypeLabel;
    private JPanel myPanel;
    private JPanel myResolvedPanel;
    private JBScrollPane myResolvedScrollPane;
    private boolean myIgnoreSelection;
    private ResourceChooserItem myItem;

    public ResourceDrawablePanel(@NotNull Configuration configuration, @NotNull AndroidFacet facet, @NotNull IconFactory iconFactory) {
        if (configuration == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(1);
        }
        if (iconFactory == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(2);
        }
        this.myConfiguration = configuration;
        this.myFacet = facet;
        this.$$$setupUI$$$();
        this.myModule = facet.getModule();
        this.myIconFactory = iconFactory;
        this.setBorder(null);
        this.setViewportView(this.myPanel);
        this.myQualifierCombo.addActionListener(this);
        this.myResolvedPanel.setLayout((LayoutManager)new VerticalFlowLayout());
        this.myResolvedScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myResolvedScrollPane.setViewportBorder(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(@NotNull ResourceChooserItem item) {
        int index;
        String folderName;
        FolderConfiguration folderConfig;
        File folder;
        File rendered;
        String value2;
        ResourceValue resourceValue2;
        if (item == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(3);
        }
        this.myItem = item;
        List<String> qualifiers = item.getQualifiers();
        this.myQualifierCombo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(qualifiers)));
        String currentQualifier = "Default";
        ResourceResolver resourceResolver = this.myConfiguration.getResourceResolver();
        if (resourceResolver != null && (resourceValue2 = resourceResolver.resolveResValue(item.getResourceValue())) != null && (value2 = resourceValue2.getValue()) != null && (rendered = new File(value2)).exists() && (folder = rendered.getParentFile()) != null && (folderConfig = FolderConfiguration.getConfigForFolder((String)(folderName = folder.getName()))) != null && (index = folderName.indexOf(45)) != -1) {
            currentQualifier = folderName.substring(index + 1);
        }
        try {
            this.myIgnoreSelection = true;
            this.myQualifierCombo.setSelectedItem(currentQualifier);
        }
        finally {
            this.myIgnoreSelection = false;
        }
        this.show(item);
    }

    @NotNull
    private String getSelectedQualifier() {
        String string = this.myQualifierCombo.getSelectedItem() != null ? this.myQualifierCombo.getSelectedItem().toString() : "Default";
        if (string == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void show(@NotNull ResourceChooserItem item) {
        if (item == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(5);
        }
        this.myNameLabel.setText(item.getName());
        this.myImageLabel.setIcon(this.newItemIcon(item, this.myImageLabel.getHeight(), this.getSelectedQualifier(), () -> this.myImageLabel.repaint()));
        this.myTypeLabel.setText(ResourceDrawablePanel.getItemTypeLabel(item));
        ResourceDrawablePanel.updateResolutionChain(item, this.myConfiguration, this.myFacet, this.myResolvedPanel);
        this.validate();
    }

    @NotNull
    private Icon newItemIcon(@NotNull ResourceChooserItem item, int height, @NotNull String folderName, @NotNull Runnable iconCallback) {
        if (item == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(6);
        }
        if (folderName == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(7);
        }
        if (iconCallback == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(8);
        }
        String path = null;
        if (!"Default".equals(folderName)) {
            path = item.getFileForQualifiers(folderName);
        }
        if (path == null) {
            path = item.getPath();
        }
        if (height == 0) {
            height = 300;
        }
        Icon icon = null;
        if (path != null) {
            icon = this.myIconFactory.createIconFromPath(height, JBUI.scale((int)8), false, path);
        }
        if (icon == null) {
            icon = this.myIconFactory.createAsyncIconFromResourceValue(height, JBUI.scale((int)8), false, item.getResourceValue(), (Icon)EmptyIcon.create((int)height), iconCallback);
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(9);
        }
        return icon2;
    }

    @NotNull
    private static String getItemTypeLabel(@NotNull ResourceChooserItem item) {
        String extension;
        if (item == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(10);
        }
        if (item.getType() == ResourceType.MIPMAP) {
            String string = ResourceType.MIPMAP.getDisplayName().toUpperCase(Locale.US);
            if (string == null) {
                ResourceDrawablePanel.$$$reportNull$$$0(11);
            }
            return string;
        }
        PathString file = item.getFile();
        if (file != null && item.getType() != ResourceType.COLOR && !(extension = Files.getFileExtension((String)file.getFileName())).isEmpty()) {
            String string = extension.toUpperCase(Locale.US);
            if (string == null) {
                ResourceDrawablePanel.$$$reportNull$$$0(12);
            }
            return string;
        }
        if ("" == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(13);
        }
        return "";
    }

    @NotNull
    private static Stream<String> getResolutionChain(@NotNull Configuration configuration, @NotNull AndroidFacet facet, @NotNull ResourceValue value2) {
        ResourceRepository frameworkResources;
        if (configuration == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(14);
        }
        if (facet == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(15);
        }
        if (value2 == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(16);
        }
        if ((frameworkResources = configuration.getFrameworkResources()) == null) {
            Stream<String> stream = Stream.empty();
            if (stream == null) {
                ResourceDrawablePanel.$$$reportNull$$$0(17);
            }
            return stream;
        }
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(facet);
        ResourceItemResolver resolver = new ResourceItemResolver(configuration.getFullConfig(), frameworkResources, (ResourceRepository)appResources, null);
        ArrayList lookupChain = Lists.newArrayList();
        resolver.setLookupChainList((List)lookupChain);
        resolver.resolveResValue(value2);
        Stream<String> stream = lookupChain.stream().skip(2L).filter(Objects::nonNull).map(e -> e.getValue()).filter(Objects::nonNull).distinct().map(text -> {
            int end;
            if (!text.startsWith("?") && !text.startsWith("@") && (end = Math.max(text.lastIndexOf(47), text.lastIndexOf(92))) != -1) {
                return text.substring(end + 1);
            }
            return text;
        });
        if (stream == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(18);
        }
        return stream;
    }

    private static void updateResolutionChain(@NotNull ResourceChooserItem item, @NotNull Configuration configuration, @NotNull AndroidFacet facet, @NotNull JPanel resolvedPanel) {
        if (item == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(19);
        }
        if (configuration == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(20);
        }
        if (facet == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(21);
        }
        if (resolvedPanel == null) {
            ResourceDrawablePanel.$$$reportNull$$$0(22);
        }
        resolvedPanel.removeAll();
        ResourceValue value2 = item.getResourceValue();
        if (value2.getValue() == null) {
            return;
        }
        JBLabel rootLabel = new JBLabel(value2.getValue());
        resolvedPanel.add((Component)rootLabel);
        AtomicInteger indentCount = new AtomicInteger(0);
        ResourceDrawablePanel.getResolutionChain(configuration, facet, value2).map(text -> "\u21d2 " + text).map(text -> new JBLabel(text)).forEach(label -> {
            label.setBorder((Border)JBUI.Borders.emptyLeft((int)JBUI.scale((int)(indentCount.incrementAndGet() * 12))));
            resolvedPanel.add((Component)label);
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myQualifierCombo && !this.myIgnoreSelection) {
            this.show(this.myItem);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconFactory";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/preview/ResourceDrawablePanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconCallback";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/preview/ResourceDrawablePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedQualifier";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newItemIcon";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemTypeLabel";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolutionChain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newItemIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getItemTypeLabel";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getResolutionChain";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateResolutionChain";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBScrollPane jBScrollPane;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JComboBox jComboBox;
        JBLabel jBLabel3;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 5, new Insets(12, 12, 11, 11), -1, -1, false, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Name:");
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myNameLabel = jBLabel3 = new JBLabel();
        jBLabel3.setName("drawablePreviewName");
        jBLabel3.setText("");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myQualifierCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 3, 1, 2, 4, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(1, 0, 1, 5, 1, 1, 7, 1, null, null, null));
        this.myImageLabel = jBLabel2 = new JBLabel();
        jBLabel2.setAlignmentY(0.0f);
        jBLabel2.setHorizontalAlignment(2);
        jBLabel2.setIconTextGap(0);
        jBLabel2.setName("drawablePreviewLabel");
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 4, 8, 2, 0, 0, null, new Dimension(300, 300), null));
        this.myTypeLabel = jBLabel = new JBLabel();
        jBLabel.setName("drawablePreviewType");
        jBLabel.setText("PNG");
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 4, 1, 1, 5, 0, 0, 0, null, null, null));
        this.myResolvedScrollPane = jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 5, 0, 3, 7, 7, null, null, null));
        this.myResolvedPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setName("resolutionChain");
        jBScrollPane.setViewportView(jPanel);
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

