/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.icons;

import com.android.tools.idea.ui.resourcechooser.util.CheckerboardPaint;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.Icon;

class ResourceChooserImageIcon
implements Icon {
    private final int mySize;
    private final Image myImage;
    private final Paint myCheckerPaint;
    private boolean myInterpolate;

    ResourceChooserImageIcon(int size, Image image, int checkerboardSize, boolean interpolate) {
        this.mySize = size;
        this.myImage = image;
        this.myCheckerPaint = checkerboardSize > 0 ? new CheckerboardPaint(checkerboardSize) : null;
        this.myInterpolate = interpolate;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        double scale = Math.min((double)this.getIconHeight() / (double)this.myImage.getHeight(c), (double)this.getIconWidth() / (double)this.myImage.getWidth(c));
        int dx = (int)((double)this.getIconWidth() - (double)this.myImage.getWidth(c) * scale) / 2;
        int dy = (int)((double)this.getIconHeight() - (double)this.myImage.getHeight(c) * scale) / 2;
        if (this.myCheckerPaint != null) {
            ((Graphics2D)g).setPaint(this.myCheckerPaint);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        }
        if (this.myInterpolate) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        g.drawImage(this.myImage, x + dx, y + dy, (int)((double)this.myImage.getWidth(c) * scale), (int)((double)this.myImage.getHeight(c) * scale), null);
    }

    @Override
    public int getIconWidth() {
        return this.mySize;
    }

    @Override
    public int getIconHeight() {
        return this.mySize;
    }
}

