/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.colorpicker2;

import com.android.tools.adtui.util.GraphicsUtil;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.AlphaSliderComponentKt;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.SliderComponent;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0015\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/AlphaSliderComponent;", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/SliderComponent;", "", "()V", "sliderBackgroundColor", "Ljava/awt/Color;", "getSliderBackgroundColor", "()Ljava/awt/Color;", "setSliderBackgroundColor", "(Ljava/awt/Color;)V", "knobPositionToValue", "knobPosition", "(I)Ljava/lang/Integer;", "paintSlider", "", "g2d", "Ljava/awt/Graphics2D;", "slide", "shift", "valueToKnobPosition", "value", "intellij.android.core"})
public final class AlphaSliderComponent
extends SliderComponent<Integer> {
    @NotNull
    private Color sliderBackgroundColor;

    @NotNull
    public final Color getSliderBackgroundColor() {
        return this.sliderBackgroundColor;
    }

    public final void setSliderBackgroundColor(@NotNull Color color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"<set-?>");
        this.sliderBackgroundColor = color;
    }

    @Override
    @NotNull
    protected Integer knobPositionToValue(int knobPosition) {
        return this.getSliderWidth() > 0 ? Math.round((float)knobPosition * 255.0f / (float)this.getSliderWidth()) : 0;
    }

    @Override
    protected int valueToKnobPosition(int value2) {
        return Math.round((float)(value2 * this.getSliderWidth()) / 255.0f);
    }

    @Override
    @NotNull
    protected Integer slide(int shift) {
        int n = 0;
        int n2 = ((Number)this.getValue()).intValue() + shift;
        int n3 = 255;
        n2 = Math.min(n2, n3);
        return Math.max(n, n2);
    }

    @Override
    protected void paintSlider(@NotNull Graphics2D g2d) {
        Intrinsics.checkParameterIsNotNull((Object)g2d, (String)"g2d");
        Color color = ColorUtil.toAlpha((Color)Color.WHITE, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"ColorUtil.toAlpha(Color.WHITE, 0)");
        Color transparent = color;
        Rectangle clip = new Rectangle(this.getLeftPadding(), this.getTopPadding(), this.getWidth() - this.getLeftPadding() - this.getRightPadding(), this.getHeight() - this.getTopPadding() - this.getBottomPadding());
        GraphicsUtil.paintCheckeredBackground((Graphics)g2d, (Color)Color.LIGHT_GRAY, (Color)Color.GRAY, (Shape)clip, (int)6);
        Color sliderBackgroundWithoutAlpha = new Color(this.sliderBackgroundColor.getRGB() & 0xFFFFFF);
        g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)transparent, (float)this.getWidth(), (float)0.0f, (Color)sliderBackgroundWithoutAlpha));
        g2d.fillRect(clip.x, clip.y, clip.width, clip.height);
    }

    public AlphaSliderComponent() {
        super(0);
        Color color = AlphaSliderComponentKt.access$getDEFAULT_SLIDER_BACKGROUND$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"DEFAULT_SLIDER_BACKGROUND");
        this.sliderBackgroundColor = color;
    }
}

