/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.res.StateListState;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.ui.resourcechooser.ResourceSwatchComponent;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateListPicker
extends JPanel {
    private static final EnumSet<ResourceType> DIMENSIONS_ONLY = EnumSet.of(ResourceType.DIMEN);
    private final Module myModule;
    private final Configuration myConfiguration;
    @Nullable
    private StateList myStateList;
    private List<StateComponent> myStateComponents;
    @NotNull
    private final RenderTask myRenderTask;
    private boolean myIsBackgroundStateList;
    @NotNull
    private ImmutableMap<String, Color> myContrastColorsWithDescription;

    public StateListPicker(@Nullable StateList stateList, @NotNull Module module, @NotNull Configuration configuration) {
        if (module == null) {
            StateListPicker.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            StateListPicker.$$$reportNull$$$0(1);
        }
        this.myContrastColorsWithDescription = ImmutableMap.of();
        this.myModule = module;
        this.myConfiguration = configuration;
        this.myRenderTask = DrawableRendererEditor.configureRenderTask(module, configuration);
        this.setLayout(new BoxLayout(this, 1));
        if (stateList != null) {
            this.setStateList(stateList);
        }
    }

    public void setStateList(@NotNull StateList stateList) {
        if (stateList == null) {
            StateListPicker.$$$reportNull$$$0(2);
        }
        this.myStateList = stateList;
        this.myStateComponents = Lists.newArrayListWithCapacity((int)this.myStateList.getStates().size());
        this.removeAll();
        if (this.myStateList.getStates().isEmpty()) {
            this.add(new JLabel("Empty " + this.myStateList.getType() + " StateList"));
        }
        for (StateListState state : this.myStateList.getStates()) {
            StateComponent stateComponent = this.createStateComponent(state);
            this.add(stateComponent);
        }
        this.revalidate();
        this.repaint();
    }

    @NotNull
    private StateComponent createStateComponent(@NotNull StateListState state) {
        if (state == null) {
            StateListPicker.$$$reportNull$$$0(3);
        }
        StateComponent stateComponent = new StateComponent(this.myModule.getProject());
        this.myStateComponents.add(stateComponent);
        String stateValue = state.getValue();
        String alphaValue = state.getAlpha();
        stateComponent.addValueActionListener(new ValueActionListener(state, stateComponent));
        stateComponent.addAlphaActionListener(new AlphaActionListener(state, stateComponent));
        stateComponent.setValueText(stateValue);
        stateComponent.setAlphaValue(alphaValue);
        stateComponent.setAlphaVisible(!StringUtil.isEmpty((String)alphaValue));
        stateComponent.setNameText(state.getDescription());
        stateComponent.setComponentPopupMenu((JPopupMenu)this.createAlphaPopupMenu(state, stateComponent));
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null);
        assert (this.myStateList != null);
        List<String> completionStrings = ResourceHelper.getCompletionFromTypes(facet, this.myStateList.getFolderType() == ResourceFolderType.COLOR ? GraphicalResourceRendererEditor.COLORS_ONLY : GraphicalResourceRendererEditor.DRAWABLES_ONLY);
        stateComponent.getResourceComponent().setCompletionStrings(completionStrings);
        stateComponent.getAlphaComponent().setCompletionStrings(ResourceHelper.getCompletionFromTypes(facet, DIMENSIONS_ONLY));
        StateComponent stateComponent2 = stateComponent;
        if (stateComponent2 == null) {
            StateListPicker.$$$reportNull$$$0(4);
        }
        return stateComponent2;
    }

    @NotNull
    private JBPopupMenu createAlphaPopupMenu(@NotNull StateListState state, @NotNull StateComponent stateComponent) {
        if (state == null) {
            StateListPicker.$$$reportNull$$$0(5);
        }
        if (stateComponent == null) {
            StateListPicker.$$$reportNull$$$0(6);
        }
        JBPopupMenu popupMenu = new JBPopupMenu();
        JMenuItem deleteAlpha = new JMenuItem("Delete alpha");
        popupMenu.add(deleteAlpha);
        deleteAlpha.setVisible(!StringUtil.isEmpty((String)state.getAlpha()));
        JMenuItem createAlpha = new JMenuItem("Create alpha");
        popupMenu.add(createAlpha);
        createAlpha.setVisible(StringUtil.isEmpty((String)state.getAlpha()));
        deleteAlpha.addActionListener(e -> {
            stateComponent.getAlphaComponent().setVisible(false);
            stateComponent.setAlphaValue(null);
            state.setAlpha(null);
            this.updateIcon(stateComponent);
            deleteAlpha.setVisible(false);
            createAlpha.setVisible(true);
        });
        createAlpha.addActionListener(e -> {
            AlphaActionListener listener2 = stateComponent.getAlphaActionListener();
            if (listener2 == null) {
                return;
            }
            listener2.actionPerformed(new ActionEvent(stateComponent.getAlphaComponent(), 1001, null));
            if (!StringUtil.isEmpty((String)state.getAlpha())) {
                stateComponent.getAlphaComponent().setVisible(true);
                createAlpha.setVisible(false);
                deleteAlpha.setVisible(true);
            }
        });
        JBPopupMenu jBPopupMenu = popupMenu;
        if (jBPopupMenu == null) {
            StateListPicker.$$$reportNull$$$0(7);
        }
        return jBPopupMenu;
    }

    @Nullable
    public ValidationInfo doValidate(int minApi) {
        IAndroidTarget target = this.myConfiguration.getRealTarget();
        assert (target != null);
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myModule);
        assert (androidTargetData != null);
        ResourceRepository frameworkResources = this.myConfiguration.getFrameworkResources();
        assert (frameworkResources != null);
        for (StateComponent component : this.myStateComponents) {
            ValidationInfo error = component.doValidate(minApi, androidTargetData);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    public void setContrastParameters(@NotNull ImmutableMap<String, Color> contrastColorsWithDescription, boolean isBackgroundStateList) {
        if (contrastColorsWithDescription == null) {
            StateListPicker.$$$reportNull$$$0(8);
        }
        this.myContrastColorsWithDescription = contrastColorsWithDescription;
        this.myIsBackgroundStateList = isBackgroundStateList;
    }

    @Nullable
    public StateList getStateList() {
        return this.myStateList;
    }

    private void updateIcon(@NotNull StateComponent component) {
        if (component == null) {
            StateListPicker.$$$reportNull$$$0(9);
        }
        component.showAlphaError(false);
        ResourceResolver resourceResolver = this.myConfiguration.getResourceResolver();
        assert (resourceResolver != null);
        component.setValueIcon(StateListPicker.getSwatchIcon(component.getResourceValue(), resourceResolver, this.myRenderTask));
        String alphaValue = component.getAlphaValue();
        if (!StringUtil.isEmpty((String)alphaValue)) {
            try {
                float alpha = Float.parseFloat(ResourceHelper.resolveStringValue((RenderResources)resourceResolver, alphaValue));
                JBFont iconFont = JBUI.Fonts.smallFont().asBold();
                component.getAlphaComponent().setSwatchIcon(new ResourceSwatchComponent.TextIcon(String.format("%.2f", Float.valueOf(alpha)), (Font)iconFont));
            }
            catch (NumberFormatException e) {
                component.showAlphaError(true);
                component.getAlphaComponent().setSwatchIcon(ResourceSwatchComponent.WARNING_ICON);
            }
        } else {
            JBFont iconFont = JBUI.Fonts.smallFont().asBold();
            component.getAlphaComponent().setSwatchIcon(new ResourceSwatchComponent.TextIcon("1.00", (Font)iconFont));
        }
    }

    @NotNull
    public static ResourceSwatchComponent.SwatchIcon getSwatchIcon(@Nullable String resourceName, @NotNull ResourceResolver resourceResolver, @NotNull RenderTask renderTask) {
        ResourceSwatchComponent.SwatchIcon icon;
        if (resourceResolver == null) {
            StateListPicker.$$$reportNull$$$0(10);
        }
        if (renderTask == null) {
            StateListPicker.$$$reportNull$$$0(11);
        }
        ResourceValue resValue = resourceResolver.findResValue(resourceName, false);
        if ((resValue = resourceResolver.resolveResValue(resValue)) == null || resValue.getResourceType() == ResourceType.COLOR) {
            ResourceSwatchComponent.SwatchIcon icon2;
            List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)resourceResolver, resValue, renderTask.getContext().getModule().getProject());
            if (colors.isEmpty()) {
                Color colorValue = ResourceHelper.parseColor(resourceName);
                icon2 = colorValue != null ? new ResourceSwatchComponent.ColorIcon(colorValue) : ResourceSwatchComponent.WARNING_ICON;
            } else {
                icon2 = new ResourceSwatchComponent.ColorIcon((Color)Iterables.getLast(colors));
                icon2.setIsStack(colors.size() > 1);
            }
            ResourceSwatchComponent.SwatchIcon swatchIcon = icon2;
            if (swatchIcon == null) {
                StateListPicker.$$$reportNull$$$0(12);
            }
            return swatchIcon;
        }
        List<BufferedImage> images = renderTask.renderDrawableAllStates(resValue);
        if (images.isEmpty()) {
            icon = ResourceSwatchComponent.WARNING_ICON;
        } else {
            icon = new ResourceSwatchComponent.SquareImageIcon((BufferedImage)Iterables.getLast(images));
            icon.setIsStack(images.size() > 1);
        }
        ResourceSwatchComponent.SwatchIcon swatchIcon = icon;
        if (swatchIcon == null) {
            StateListPicker.$$$reportNull$$$0(13);
        }
        return swatchIcon;
    }

    private void repaintAllComponents() {
        for (StateComponent component : this.myStateComponents) {
            this.updateIcon(component);
            component.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateList";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/StateListPicker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contrastColorsWithDescription";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceResolver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/StateListPicker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createStateComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAlphaPopupMenu";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwatchIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setStateList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStateComponent";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAlphaPopupMenu";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setContrastParameters";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateIcon";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSwatchIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StateComponent
    extends Box {
        private final ResourceComponent myResourceComponent;
        private final ResourceSwatchComponent myAlphaComponent;
        private final JBLabel myAlphaErrorLabel;
        private AlphaActionListener myAlphaActionListener;

        public StateComponent(Project project) {
            if (project == null) {
                StateComponent.$$$reportNull$$$0(0);
            }
            super(3);
            this.myResourceComponent = new ResourceComponent(project, true);
            this.add(this.myResourceComponent);
            this.myAlphaComponent = new ResourceSwatchComponent(project, true);
            this.add(this.myAlphaComponent);
            Font font = StateListPicker.this.getFont();
            this.setFont(ThemeEditorUtils.scaleFontForAttribute(font));
            Box alphaErrorComponent = new Box(2);
            this.myAlphaErrorLabel = new JBLabel("This value does not resolve to a floating-point number.", AllIcons.General.BalloonWarning, 10);
            this.myAlphaErrorLabel.setVisible(false);
            alphaErrorComponent.add((Component)this.myAlphaErrorLabel);
            alphaErrorComponent.add(Box.createHorizontalGlue());
            this.add(alphaErrorComponent);
        }

        @NotNull
        public ResourceComponent getResourceComponent() {
            ResourceComponent resourceComponent = this.myResourceComponent;
            if (resourceComponent == null) {
                StateComponent.$$$reportNull$$$0(1);
            }
            return resourceComponent;
        }

        @NotNull
        public ResourceSwatchComponent getAlphaComponent() {
            ResourceSwatchComponent resourceSwatchComponent = this.myAlphaComponent;
            if (resourceSwatchComponent == null) {
                StateComponent.$$$reportNull$$$0(2);
            }
            return resourceSwatchComponent;
        }

        public void showAlphaError(boolean hasError) {
            this.myAlphaErrorLabel.setVisible(hasError);
            this.myAlphaComponent.setWarningBorder(hasError);
        }

        public void setNameText(@NotNull String name) {
            if (name == null) {
                StateComponent.$$$reportNull$$$0(3);
            }
            this.myResourceComponent.setNameText(name);
        }

        public void setValueText(@NotNull String value2) {
            if (value2 == null) {
                StateComponent.$$$reportNull$$$0(4);
            }
            this.myResourceComponent.setValueText(value2);
            StateListPicker.this.updateIcon(this);
        }

        public void setAlphaValue(@Nullable String alphaValue) {
            this.myAlphaComponent.setText(Strings.nullToEmpty((String)alphaValue));
        }

        public void setAlphaVisible(boolean isVisible) {
            this.myAlphaComponent.setVisible(isVisible);
        }

        public void setValueIcon(@NotNull ResourceSwatchComponent.SwatchIcon icon) {
            if (icon == null) {
                StateComponent.$$$reportNull$$$0(5);
            }
            this.myResourceComponent.setSwatchIcon(icon);
        }

        @NotNull
        public String getResourceValue() {
            String string = this.myResourceComponent.getValueText();
            if (string == null) {
                StateComponent.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nullable
        public String getAlphaValue() {
            return this.myAlphaComponent.getText();
        }

        public void addValueActionListener(@NotNull ValueActionListener listener2) {
            if (listener2 == null) {
                StateComponent.$$$reportNull$$$0(7);
            }
            this.myResourceComponent.addSwatchListener(listener2);
            this.myResourceComponent.addTextDocumentListener(listener2);
        }

        public void addAlphaActionListener(@NotNull AlphaActionListener listener2) {
            if (listener2 == null) {
                StateComponent.$$$reportNull$$$0(8);
            }
            this.myAlphaComponent.addSwatchListener(listener2);
            this.myAlphaComponent.addTextDocumentListener(listener2);
            this.myAlphaActionListener = listener2;
        }

        @Nullable
        public AlphaActionListener getAlphaActionListener() {
            return this.myAlphaActionListener;
        }

        @Override
        public void setComponentPopupMenu(JPopupMenu popup2) {
            super.setComponentPopupMenu(popup2);
            this.myResourceComponent.setComponentPopupMenu(popup2);
            this.myAlphaComponent.setComponentPopupMenu(popup2);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.myResourceComponent != null) {
                this.myResourceComponent.setFont(font);
            }
            if (this.myAlphaComponent != null) {
                this.myAlphaComponent.setFont(font);
            }
        }

        @Nullable
        public ValidationInfo doValidate(int minApi, @NotNull AndroidTargetData androidTargetData) {
            ValidationInfo error;
            if (androidTargetData == null) {
                StateComponent.$$$reportNull$$$0(9);
            }
            if ((error = this.getResourceComponent().doValidate(minApi, androidTargetData)) == null && this.getAlphaValue() != null) {
                error = this.getAlphaComponent().doValidate(minApi, androidTargetData);
            }
            return error;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/StateListPicker$StateComponent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidTargetData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/StateListPicker$StateComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlphaComponent";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setNameText";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setValueText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setValueIcon";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addValueActionListener";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addAlphaActionListener";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class AlphaActionListener
    implements ActionListener,
    DocumentListener {
        private final StateListState myState;
        private final StateComponent myComponent;

        public AlphaActionListener(StateListState state, StateComponent stateComponent) {
            this.myState = state;
            this.myComponent = stateComponent;
        }

        public void documentChanged(DocumentEvent e) {
            this.myState.setAlpha(this.myComponent.getAlphaValue());
            ApplicationManager.getApplication().invokeLater(() -> {
                StateListPicker.this.updateIcon(this.myComponent);
                this.myComponent.repaint();
            }, ModalityState.any());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResourceSwatchComponent source = this.myComponent.getAlphaComponent();
            String itemValue = source.getText();
            ResourceResolver resourceResolver = StateListPicker.this.myConfiguration.getResourceResolver();
            assert (resourceResolver != null);
            ResourceValue resValue = resourceResolver.findResValue(itemValue, false);
            String resolvedResource = resValue != null ? resourceResolver.resolveResValue(resValue).getName() : itemValue;
            ChooseResourceDialog dialog = ChooseResourceDialog.builder().setModule(StateListPicker.this.myModule).setTypes(DIMENSIONS_ONLY).setCurrentValue(resolvedResource).setConfiguration(StateListPicker.this.myConfiguration).build();
            dialog.show();
            if (dialog.isOK()) {
                String resourceName = dialog.getResourceName();
                this.myState.setAlpha(resourceName);
                this.myComponent.setAlphaValue(resourceName);
                StateListPicker.this.repaintAllComponents();
            }
        }
    }

    class ValueActionListener
    implements ActionListener,
    DocumentListener {
        private final StateListState myState;
        private final StateComponent myComponent;

        public ValueActionListener(StateListState state, StateComponent stateComponent) {
            this.myState = state;
            this.myComponent = stateComponent;
        }

        public void documentChanged(DocumentEvent e) {
            this.myState.setValue(this.myComponent.getResourceValue());
            ApplicationManager.getApplication().invokeLater(() -> {
                StateListPicker.this.updateIcon(this.myComponent);
                this.myComponent.repaint();
            }, ModalityState.any());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nameSuggestion;
            ResourceComponent resourceComponent = this.myComponent.getResourceComponent();
            String attributeValue = resourceComponent.getValueText();
            ResourceUrl attributeValueUrl = ResourceUrl.parse((String)attributeValue);
            boolean isFrameworkValue = attributeValueUrl != null && attributeValueUrl.isFramework();
            String string = nameSuggestion = attributeValueUrl != null ? attributeValueUrl.name : attributeValue;
            assert (StateListPicker.this.myStateList != null);
            EnumSet<ResourceType> allowedTypes = StateListPicker.this.myStateList.getFolderType() == ResourceFolderType.COLOR ? GraphicalResourceRendererEditor.COLORS_ONLY : GraphicalResourceRendererEditor.DRAWABLES_ONLY;
            ChooseResourceDialog.ResourceNameVisibility resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.FORCE;
            if (nameSuggestion.startsWith("#")) {
                nameSuggestion = null;
                resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.SHOW;
            }
            ChooseResourceDialog dialog = ChooseResourceDialog.builder().setModule(StateListPicker.this.myModule).setTypes(allowedTypes).setCurrentValue(attributeValue).setIsFrameworkValue(isFrameworkValue).setResourceNameVisibility(resourceNameVisibility).setResourceNameSuggestion(nameSuggestion).setConfiguration(StateListPicker.this.myConfiguration).build();
            if (!StateListPicker.this.myContrastColorsWithDescription.isEmpty()) {
                dialog.setContrastParameters((ImmutableMap<String, Color>)StateListPicker.this.myContrastColorsWithDescription, StateListPicker.this.myIsBackgroundStateList, !StateListPicker.this.myStateList.getDisabledStates().contains((Object)this.myState));
            }
            dialog.show();
            if (dialog.isOK()) {
                String resourceName = dialog.getResourceName();
                this.myComponent.setValueText(resourceName);
                StateListPicker.this.repaintAllComponents();
            }
        }
    }
}

