/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.tools.idea.ui.resourcechooser.groups.ResourceChooserGroup;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.Nullable;

class ResourceTableContentProvider
extends AbstractTableModel {
    private final ResourceChooserGroup[] myGroups;
    private final int[] myGroupIndices;
    private final int myRowCount;

    ResourceTableContentProvider(ResourceChooserGroup[] groups) {
        this.myGroups = groups;
        this.myGroupIndices = new int[groups.length];
        int rowCount = 0;
        for (int i2 = 0; i2 < groups.length; ++i2) {
            this.myGroupIndices[i2] = rowCount++;
            rowCount += groups[i2].getItems().size();
        }
        this.myRowCount = rowCount;
    }

    @Override
    public int getRowCount() {
        return this.myRowCount;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getResource(rowIndex);
    }

    @Nullable
    private Object getResource(int rowIndex) {
        for (int groupIndex = this.myGroups.length - 1; groupIndex >= 0; --groupIndex) {
            if (rowIndex < this.myGroupIndices[groupIndex]) continue;
            ResourceChooserGroup group = this.myGroups[groupIndex];
            if (rowIndex == this.myGroupIndices[groupIndex]) {
                return group.getGroupLabel();
            }
            int index = rowIndex - this.myGroupIndices[groupIndex] - 1;
            return group.getItems().get(index);
        }
        return null;
    }
}

