/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.FreemarkerConfiguration;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.StudioTemplateLoader;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.recipe.DefaultRecipeExecutor;
import com.android.tools.idea.templates.recipe.FindReferencesRecipeExecutor;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderingContext {
    private final ContextTarget myContextTarget;
    private final String myTitle;
    private final Map<String, Object> myParamMap;
    private final File myOutputRoot;
    private final File myModuleRoot;
    private final boolean myFindOnlyReferences;
    private final StudioTemplateLoader myLoader;
    private final Configuration myFreemarker;
    private final Collection<File> mySourceFiles;
    private final Collection<File> myTargetFiles;
    private final Collection<File> myFilesToOpen;
    private final Collection<String> myPlugins;
    private final Collection<String> myClasspathEntries;
    private final SetMultimap<String, String> myDependencies;
    private final Collection<String> myWarnings;
    private final boolean myDryRun;
    private final boolean myShowErrors;

    private RenderingContext(@NotNull ContextTarget contextTarget, @NotNull File initialTemplatePath, @NotNull String commandName, @NotNull Map<String, Object> paramMap, @NotNull File outputRoot, @NotNull File moduleRoot, boolean findOnlyReferences, boolean dryRun, boolean showErrors, @Nullable Collection<File> outSourceFiles, @Nullable Collection<File> outTargetFiles, @Nullable Collection<File> outOpenFiles, @Nullable Collection<String> outPlugins, @Nullable Collection<String> outClasspathEntries, @Nullable SetMultimap<String, String> outDependencies) {
        if (contextTarget == null) {
            RenderingContext.$$$reportNull$$$0(0);
        }
        if (initialTemplatePath == null) {
            RenderingContext.$$$reportNull$$$0(1);
        }
        if (commandName == null) {
            RenderingContext.$$$reportNull$$$0(2);
        }
        if (paramMap == null) {
            RenderingContext.$$$reportNull$$$0(3);
        }
        if (outputRoot == null) {
            RenderingContext.$$$reportNull$$$0(4);
        }
        if (moduleRoot == null) {
            RenderingContext.$$$reportNull$$$0(5);
        }
        this.myContextTarget = contextTarget;
        this.myTitle = commandName;
        this.myParamMap = FreemarkerUtils.createParameterMap(paramMap);
        this.myOutputRoot = outputRoot;
        this.myModuleRoot = moduleRoot;
        this.myFindOnlyReferences = findOnlyReferences;
        this.myDryRun = dryRun;
        this.myShowErrors = showErrors;
        this.myLoader = new StudioTemplateLoader(initialTemplatePath);
        this.myFreemarker = new FreemarkerConfiguration();
        this.myFreemarker.setTemplateLoader((TemplateLoader)this.myLoader);
        this.mySourceFiles = outSourceFiles != null ? outSourceFiles : Lists.newArrayList();
        this.myTargetFiles = outTargetFiles != null ? outTargetFiles : Lists.newArrayList();
        this.myFilesToOpen = outOpenFiles != null ? outOpenFiles : Lists.newArrayList();
        this.myPlugins = outPlugins != null ? outPlugins : Lists.newArrayList();
        this.myClasspathEntries = outClasspathEntries != null ? outClasspathEntries : Lists.newArrayList();
        this.myDependencies = outDependencies != null ? outDependencies : LinkedHashMultimap.create();
        this.myWarnings = Lists.newArrayList();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myContextTarget.myProject;
        if (project == null) {
            RenderingContext.$$$reportNull$$$0(6);
        }
        return project;
    }

    @Nullable
    public Module getModule() {
        return this.myContextTarget.myModule;
    }

    @NotNull
    public String getCommandName() {
        String string = this.myTitle;
        if (string == null) {
            RenderingContext.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public Map<String, Object> getParamMap() {
        Map<String, Object> map2 = this.myParamMap;
        if (map2 == null) {
            RenderingContext.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @NotNull
    public File getOutputRoot() {
        File file = this.myOutputRoot;
        if (file == null) {
            RenderingContext.$$$reportNull$$$0(9);
        }
        return file;
    }

    @NotNull
    public File getModuleRoot() {
        File file = this.myModuleRoot;
        if (file == null) {
            RenderingContext.$$$reportNull$$$0(10);
        }
        return file;
    }

    public boolean showErrors() {
        return this.myShowErrors;
    }

    public boolean showWarnings() {
        return this.myShowErrors && this.myDryRun;
    }

    @NotNull
    public StudioTemplateLoader getLoader() {
        StudioTemplateLoader studioTemplateLoader = this.myLoader;
        if (studioTemplateLoader == null) {
            RenderingContext.$$$reportNull$$$0(11);
        }
        return studioTemplateLoader;
    }

    @NotNull
    public Configuration getFreemarkerConfiguration() {
        Configuration configuration = this.myFreemarker;
        if (configuration == null) {
            RenderingContext.$$$reportNull$$$0(12);
        }
        return configuration;
    }

    @NotNull
    public Collection<File> getTargetFiles() {
        Collection<File> collection = this.myTargetFiles;
        if (collection == null) {
            RenderingContext.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public Collection<File> getFilesToOpen() {
        Collection<File> collection = this.myFilesToOpen;
        if (collection == null) {
            RenderingContext.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getPlugins() {
        Collection<String> collection = this.myPlugins;
        if (collection == null) {
            RenderingContext.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getClasspathEntries() {
        Collection<String> collection = this.myClasspathEntries;
        if (collection == null) {
            RenderingContext.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public SetMultimap<String, String> getDependencies() {
        SetMultimap<String, String> setMultimap = this.myDependencies;
        if (setMultimap == null) {
            RenderingContext.$$$reportNull$$$0(17);
        }
        return setMultimap;
    }

    @NotNull
    public Collection<File> getSourceFiles() {
        Collection<File> collection = this.mySourceFiles;
        if (collection == null) {
            RenderingContext.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getWarnings() {
        Collection<String> collection = this.myWarnings;
        if (collection == null) {
            RenderingContext.$$$reportNull$$$0(19);
        }
        return collection;
    }

    public RecipeExecutor getRecipeExecutor() {
        if (this.myFindOnlyReferences) {
            return new FindReferencesRecipeExecutor(this);
        }
        return new DefaultRecipeExecutor(this, this.myDryRun);
    }

    public boolean shouldReformat() {
        return !this.myDryRun;
    }

    public boolean canCausePartialRendering() {
        return !this.myDryRun;
    }

    public String toString() {
        return "RenderingContext{myContextTarget=" + this.myContextTarget + ", myTitle='" + this.myTitle + '\'' + ", myParamMap=" + this.myParamMap + ", myOutputRoot=" + this.myOutputRoot + ", myModuleRoot=" + this.myModuleRoot + ", myFindOnlyReferences=" + this.myFindOnlyReferences + ", myLoader=" + this.myLoader + ", myFreemarker=" + this.myFreemarker + ", mySourceFiles=" + this.mySourceFiles + ", myTargetFiles=" + this.myTargetFiles + ", myFilesToOpen=" + this.myFilesToOpen + ", myPlugins=" + this.myPlugins + ", myClasspathEntries=" + this.myClasspathEntries + ", myDependencies=" + this.myDependencies + ", myWarnings=" + this.myWarnings + ", myDryRun=" + this.myDryRun + ", myShowErrors=" + this.myShowErrors + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextTarget";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialTemplatePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/recipe/RenderingContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/recipe/RenderingContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoot";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRoot";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoader";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFreemarkerConfiguration";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetFiles";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToOpen";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathEntries";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarnings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContextTarget {
        @NotNull
        final Project myProject;
        @Nullable
        final Module myModule;

        private ContextTarget(@NotNull Project project) {
            if (project == null) {
                ContextTarget.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myModule = null;
        }

        private ContextTarget(@NotNull Module module) {
            if (module == null) {
                ContextTarget.$$$reportNull$$$0(1);
            }
            this.myProject = module.getProject();
            this.myModule = module;
        }

        public String toString() {
            return "RenderingContext{myProject=" + this.myProject + ", myModule=" + this.myModule + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/templates/recipe/RenderingContext$ContextTarget";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Builder {
        private final File myInitialTemplatePath;
        private final Project myProject;
        private Module myModule;
        private String myCommandName;
        private Map<String, Object> myParams;
        private File myOutputRoot;
        private File myModuleRoot;
        private boolean myFindOnlyReferences;
        private boolean myDryRun;
        private boolean myShowErrors;
        private Collection<File> mySourceFiles;
        private Collection<File> myTargetFiles;
        private Collection<File> myOpenFiles;
        private Collection<String> myPlugins;
        private Collection<String> myClasspathEntries;
        private SetMultimap<String, String> myDependencies;

        private Builder(@NotNull File initialTemplatePath, @NotNull Project project) {
            if (initialTemplatePath == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (project == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myInitialTemplatePath = initialTemplatePath;
            this.myProject = project;
            this.myCommandName = "Instantiate Template";
            this.myParams = Collections.emptyMap();
            this.myModuleRoot = this.myOutputRoot = VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir());
        }

        public static Builder newContext(@NotNull Template template, @NotNull Project project) {
            if (template == null) {
                Builder.$$$reportNull$$$0(2);
            }
            if (project == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return new Builder(template.getRootPath(), project);
        }

        public static Builder newContext(@NotNull File templateRootPath, @NotNull Project project) {
            if (templateRootPath == null) {
                Builder.$$$reportNull$$$0(4);
            }
            if (project == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return new Builder(templateRootPath, project);
        }

        public Builder withCommandName(@NotNull String commandName) {
            if (commandName == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myCommandName = commandName;
            return this;
        }

        public Builder withModule(@Nullable Module module) {
            this.myModule = module;
            return this;
        }

        public Builder withOutputRoot(@NotNull File outputRoot) {
            if (outputRoot == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myOutputRoot = outputRoot;
            return this;
        }

        public Builder withModuleRoot(@NotNull File moduleRoot) {
            if (moduleRoot == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myModuleRoot = moduleRoot;
            return this;
        }

        public Builder withParams(@NotNull Map<String, Object> params) {
            if (params == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myParams = params;
            return this;
        }

        public Builder withFindOnlyReferences(boolean findOnlyReferences) {
            this.myFindOnlyReferences = findOnlyReferences;
            return this;
        }

        public Builder withDryRun(boolean dryRun) {
            this.myDryRun = dryRun;
            return this;
        }

        public Builder withShowErrors(boolean showErrors) {
            this.myShowErrors = showErrors;
            return this;
        }

        public Builder intoSourceFiles(@Nullable Collection<File> sourceFiles) {
            this.mySourceFiles = sourceFiles;
            return this;
        }

        public Builder intoTargetFiles(@Nullable Collection<File> targetFiles) {
            this.myTargetFiles = targetFiles;
            return this;
        }

        public Builder intoOpenFiles(@Nullable Collection<File> openFiles) {
            this.myOpenFiles = openFiles;
            return this;
        }

        public Builder intoPlugins(@Nullable Collection<String> plugins) {
            this.myPlugins = plugins;
            return this;
        }

        public Builder intoClasspathEntries(@Nullable Collection<String> classpathEntries) {
            this.myClasspathEntries = classpathEntries;
            return this;
        }

        public Builder intoDependencies(@Nullable SetMultimap<String, String> dependencies) {
            this.myDependencies = dependencies;
            return this;
        }

        public RenderingContext build() {
            if (this.myDryRun) {
                this.mySourceFiles = null;
                this.myTargetFiles = null;
                this.myOpenFiles = null;
                this.myClasspathEntries = null;
                this.myDependencies = null;
            }
            Project project = this.myProject == null ? ProjectManagerEx.getInstanceEx().getDefaultProject() : this.myProject;
            ContextTarget contextTarget = this.myModule == null ? new ContextTarget(project) : new ContextTarget(this.myModule);
            return new RenderingContext(contextTarget, this.myInitialTemplatePath, this.myCommandName, this.myParams, this.myOutputRoot, this.myModuleRoot, this.myFindOnlyReferences, this.myDryRun, this.myShowErrors, this.mySourceFiles, this.myTargetFiles, this.myOpenFiles, this.myPlugins, this.myClasspathEntries, this.myDependencies);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialTemplatePath";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateRootPath";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputRoot";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleRoot";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/templates/recipe/RenderingContext$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "newContext";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withCommandName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withOutputRoot";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withModuleRoot";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withParams";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

