/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.collections.ObservableList;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.SelectedIndexProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.structure.services.BuildSystemOperationsLookup;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.android.tools.idea.structure.services.ServiceContext;
import com.android.tools.idea.structure.services.ServicePanelBuilder;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.TypedVariable;
import com.android.tools.idea.templates.parse.SaxUtils;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.Stack;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ServiceXmlParser
extends DefaultHandler {
    private static final Logger LOG = Logger.getInstance(ServiceXmlParser.class);
    private static final int CURRENT_FORMAT = 1;
    private static final Pattern VAR_PATTERN = Pattern.compile("^\\$\\{(.+)\\}$");
    private static final Pattern ACTION_PATTERN = Pattern.compile("^\\$\\{(.+)\\(\\)\\}$");
    @NotNull
    private final Module myModule;
    @NotNull
    private final File myRootPath;
    @NotNull
    private final ServiceContext myContext;
    @NotNull
    private final Stack<String> myTagStack;
    @NotNull
    private ServicePanelBuilder myPanelBuilder;
    @NotNull
    private ServiceCategory myServiceCategory;
    @NotNull
    private DeveloperServiceMetadata myDeveloperServiceMetadata;
    @NotNull
    private File myRecipeFile;

    ServiceXmlParser(@NotNull Module module, @NotNull File rootPath, @NotNull ServiceContext serviceContext) {
        if (module == null) {
            ServiceXmlParser.$$$reportNull$$$0(0);
        }
        if (rootPath == null) {
            ServiceXmlParser.$$$reportNull$$$0(1);
        }
        if (serviceContext == null) {
            ServiceXmlParser.$$$reportNull$$$0(2);
        }
        this.myTagStack = new Stack();
        this.myModule = module;
        this.myRootPath = rootPath;
        this.myContext = serviceContext;
        this.myPanelBuilder = new ServicePanelBuilder();
    }

    @NotNull
    private static URI toUri(@NotNull String urlString) {
        URI uRI;
        block3: {
            if (urlString == null) {
                ServiceXmlParser.$$$reportNull$$$0(3);
            }
            try {
                uRI = new URI(urlString);
                if (uRI != null) break block3;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(String.format("Malformed link argument: %1$s", urlString), e);
            }
            ServiceXmlParser.$$$reportNull$$$0(4);
        }
        return uRI;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ServiceXmlParser.$$$reportNull$$$0(5);
        }
        return module;
    }

    @NotNull
    public ServiceContext getContext() {
        ServiceContext serviceContext = this.myContext;
        if (serviceContext == null) {
            ServiceXmlParser.$$$reportNull$$$0(6);
        }
        return serviceContext;
    }

    @NotNull
    public DeveloperServiceMetadata getDeveloperServiceMetadata() {
        DeveloperServiceMetadata developerServiceMetadata = this.myDeveloperServiceMetadata;
        if (developerServiceMetadata == null) {
            ServiceXmlParser.$$$reportNull$$$0(7);
        }
        return developerServiceMetadata;
    }

    @NotNull
    public ServiceCategory getServiceCategory() {
        ServiceCategory serviceCategory = this.myServiceCategory;
        if (serviceCategory == null) {
            ServiceXmlParser.$$$reportNull$$$0(8);
        }
        return serviceCategory;
    }

    public JPanel getServicePanel() {
        return this.myPanelBuilder.getPanel();
    }

    @Override
    public void startElement(String uri, String localName, @NotNull String tagName, @NotNull Attributes attributes) throws SAXException {
        if (tagName == null) {
            ServiceXmlParser.$$$reportNull$$$0(9);
        }
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(10);
        }
        this.myTagStack.push((Object)tagName);
        if (tagName.equals("service")) {
            this.parseServiceTag(attributes);
        } else if (tagName.equals("uiGrid")) {
            this.parseUiGridTag(attributes);
        } else if (tagName.equals("uiButton")) {
            this.parseUiButton(attributes);
        } else if (tagName.equals("uiCheckbox")) {
            this.parseUiCheckbox(attributes);
        } else if (tagName.equals("uiInput")) {
            this.parseUiInput(attributes);
        } else if (tagName.equals("uiLabel")) {
            this.parseUiLabel(attributes);
        } else if (tagName.equals("uiLink")) {
            this.parseUiLink(attributes);
        } else if (tagName.equals("uiPulldown")) {
            this.parseUiPulldown(attributes);
        } else {
            LOG.warn("WARNING: Unknown service directive " + tagName);
        }
    }

    @Override
    public void endElement(String uri, String localName, @NotNull String tagName) throws SAXException {
        if (tagName == null) {
            ServiceXmlParser.$$$reportNull$$$0(11);
        }
        if (tagName.equals("service")) {
            this.closeServiceTag();
        } else if (tagName.equals("uiGrid")) {
            this.closeUiGridTag();
        }
        this.myTagStack.pop();
    }

    public void install() {
        ArrayList filesToOpen = Lists.newArrayList();
        this.analyzeRecipe(false, filesToOpen, null, null, null, null, null);
        TemplateUtils.openEditors(this.myModule.getProject(), filesToOpen, true);
    }

    private void analyzeRecipe(boolean findOnlyReferences, @Nullable Collection<File> openFiles, @Nullable SetMultimap<String, String> dependencies, @Nullable Collection<String> classpathEntries, @Nullable Collection<String> plugins, @Nullable Collection<File> sourceFiles, @Nullable Collection<File> targetFiles) {
        RenderingContext context = null;
        try {
            File moduleRoot = new File(this.myModule.getModuleFilePath()).getParentFile();
            context = RenderingContext.Builder.newContext(this.myRootPath, this.myModule.getProject()).withParams(this.myContext.toValueMap()).withOutputRoot(moduleRoot).withModuleRoot(moduleRoot).withFindOnlyReferences(findOnlyReferences).intoOpenFiles(openFiles).intoDependencies(dependencies).intoClasspathEntries(classpathEntries).intoPlugins(plugins).intoSourceFiles(sourceFiles).intoTargetFiles(targetFiles).build();
            String xml = FreemarkerUtils.processFreemarkerTemplate(context, this.myRecipeFile, null);
            Recipe recipe = Recipe.parse(new StringReader(xml));
            RecipeExecutor recipeExecutor = context.getRecipeExecutor();
            recipe.execute(recipeExecutor);
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            LOG.warn("Template processing exception with context in the following state: " + context);
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseServiceTag(@NotNull Attributes attributes) {
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(12);
        }
        String format = this.requireAttr(attributes, "format");
        try {
            if (Integer.parseInt(format) > 1) {
                throw new RuntimeException(String.format("Definition found with format %1$s newer than newest known format %2$s", format, 1));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("Non-numeric value passed to format attribute: %1$s", format));
        }
        String name = this.requireAttr(attributes, "name");
        String id = this.requireAttr(attributes, "id");
        String description = this.requireAttr(attributes, "description");
        String category = this.requireAttr(attributes, "category");
        File iconFile = new File(this.myRootPath, this.requireAttr(attributes, "icon"));
        String learnLink = attributes.getValue("learnMore");
        String apiLink = attributes.getValue("apiDocs");
        this.myRecipeFile = new File(this.myRootPath, this.requireAttr(attributes, "execute"));
        try {
            this.myServiceCategory = ServiceCategory.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, category));
        }
        catch (IllegalArgumentException e) {
            List validCategories = Lists.transform(Arrays.asList(ServiceCategory.values()), (Function)new Function<ServiceCategory, String>(){

                @Nullable
                public String apply(ServiceCategory c) {
                    return c.getDisplayName();
                }
            });
            throw new RuntimeException(String.format("Invalid category \"%1$s\", should be one of [%2$s]", category, Joiner.on((char)',').join((Iterable)validCategories)));
        }
        ImageIcon icon = new ImageIcon(iconFile.getPath());
        this.myDeveloperServiceMetadata = new DeveloperServiceMetadata(id, name, description, icon);
        if (learnLink != null) {
            this.myDeveloperServiceMetadata.setLearnMoreLink(ServiceXmlParser.toUri(learnLink));
        }
        if (apiLink != null) {
            this.myDeveloperServiceMetadata.setApiLink(ServiceXmlParser.toUri(apiLink));
        }
    }

    private void closeServiceTag() {
        LinkedHashMultimap dependencies = LinkedHashMultimap.create();
        HashSet classpathEntries = Sets.newHashSet();
        HashSet plugins = Sets.newHashSet();
        ArrayList sourceFiles = Lists.newArrayList();
        ArrayList targetFiles = Lists.newArrayList();
        this.analyzeRecipe(true, null, (SetMultimap<String, String>)dependencies, classpathEntries, plugins, sourceFiles, targetFiles);
        for (String d : dependencies.get((Object)"compile")) {
            this.myDeveloperServiceMetadata.addDependency(d);
        }
        for (String c : classpathEntries) {
            this.myDeveloperServiceMetadata.addClasspathEntry(c);
        }
        for (String p : plugins) {
            this.myDeveloperServiceMetadata.addPlugin(p);
        }
        for (File f : sourceFiles) {
            if (!f.getName().equals("AndroidManifest.xml")) continue;
            this.parseManifestForPermissions(f);
        }
        for (File f : targetFiles) {
            this.myDeveloperServiceMetadata.addModifiedFile(f);
        }
        Project project = this.myModule.getProject();
        boolean allDependenciesFound = BuildSystemOperationsLookup.getBuildSystemOperations(project).containsAllDependencies(this.myModule, this.myDeveloperServiceMetadata);
        this.myContext.installed().set(allDependenciesFound);
        this.myContext.snapshot();
    }

    private void parseManifestForPermissions(@NotNull File f) {
        if (f == null) {
            ServiceXmlParser.$$$reportNull$$$0(13);
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(f, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String tagName, Attributes attributes) throws SAXException {
                    if (tagName.equals("uses-permission") || tagName.equals("uses-permission-sdk-23") || tagName.equals("uses-permission-sdk-m")) {
                        String permission = attributes.getValue("android:name");
                        permission = permission.replace("android.permission.", "");
                        ServiceXmlParser.this.myDeveloperServiceMetadata.addPermission(permission);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Failed to read permissions from AndroidManifest.xml", (Throwable)e);
        }
    }

    private void parseUiGridTag(@NotNull Attributes attributes) {
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(14);
        }
        this.parseRowCol(attributes);
        String weights = this.requireAttr(attributes, "colDefinitions");
        JPanel grid = this.myPanelBuilder.startGrid(weights);
        this.bindTopLevelProperties(grid, attributes);
    }

    private void closeUiGridTag() {
        this.myPanelBuilder.endGrid();
    }

    private void parseUiButton(@NotNull Attributes attributes) {
        String actionKey;
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(15);
        }
        this.parseRowCol(attributes);
        JButton button = this.myPanelBuilder.addButton();
        this.bindTopLevelProperties(button, attributes);
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(button);
            this.myPanelBuilder.getBindings().bind(textProperty, this.parseString(textKey));
        }
        if ((actionKey = attributes.getValue("action")) != null) {
            final Runnable action2 = this.parseAction(actionKey);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action2.run();
                }
            });
        }
    }

    private void parseUiCheckbox(@NotNull Attributes attributes) {
        String checkedKey;
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(16);
        }
        this.parseRowCol(attributes);
        JCheckBox checkbox = this.myPanelBuilder.addCheckbox();
        this.bindTopLevelProperties(checkbox, attributes);
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(checkbox);
            this.myPanelBuilder.getBindings().bind(textProperty, this.parseString(textKey));
        }
        if ((checkedKey = attributes.getValue("checked")) != null) {
            SelectedProperty selectedProperty = new SelectedProperty(checkbox);
            BoolProperty checkedValue = (BoolProperty)this.parseBool(checkedKey);
            this.myPanelBuilder.getBindings().bindTwoWay(selectedProperty, checkedValue);
        }
    }

    private void parseUiInput(@NotNull Attributes attributes) {
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(17);
        }
        this.parseRowCol(attributes);
        JTextField field2 = this.myPanelBuilder.addField();
        this.bindTopLevelProperties(field2, attributes);
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(field2);
            StringProperty textValue = (StringProperty)this.parseString(textKey);
            this.myPanelBuilder.getBindings().bindTwoWay(textProperty, textValue);
        }
    }

    private void parseUiLabel(@NotNull Attributes attributes) {
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(18);
        }
        this.parseRowCol(attributes);
        JLabel label = this.myPanelBuilder.addLabel();
        this.bindTopLevelProperties(label, attributes);
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(label);
            this.myPanelBuilder.getBindings().bind(textProperty, this.parseString(textKey));
        }
    }

    private void parseUiLink(@NotNull Attributes attributes) {
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(19);
        }
        this.parseRowCol(attributes);
        HyperlinkLabel link = this.myPanelBuilder.addLink(this.requireAttr(attributes, "text"), ServiceXmlParser.toUri(this.requireAttr(attributes, "url")));
        this.bindTopLevelProperties((JComponent)link, attributes);
    }

    private void parseUiPulldown(@NotNull Attributes attributes) {
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(20);
        }
        this.parseRowCol(attributes);
        String listKey = this.requireAttr(attributes, "list");
        ObservableList<String> backingList = this.getList(listKey);
        JComboBox comboBox = this.myPanelBuilder.addComboBox(backingList);
        this.bindTopLevelProperties(comboBox, attributes);
        String indexKey = attributes.getValue("index");
        if (indexKey != null) {
            SelectedIndexProperty indexProperty = new SelectedIndexProperty(comboBox);
            IntProperty indexValue = (IntProperty)this.parseInt(indexKey);
            this.myPanelBuilder.getBindings().bindTwoWay(indexProperty, indexValue);
        }
    }

    private void parseRowCol(@NotNull Attributes attributes) {
        String col;
        String row;
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(21);
        }
        if ((row = attributes.getValue("row")) != null) {
            this.myPanelBuilder.setRow(Integer.parseInt(row));
        }
        if ((col = attributes.getValue("col")) != null) {
            this.myPanelBuilder.setCol(Integer.parseInt(col));
        }
    }

    private void bindTopLevelProperties(@NotNull JComponent component, @NotNull Attributes attributes) {
        String enabledKey;
        String visibleKey;
        if (component == null) {
            ServiceXmlParser.$$$reportNull$$$0(22);
        }
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(23);
        }
        if ((visibleKey = attributes.getValue("visible")) != null) {
            VisibleProperty visibleProperty = new VisibleProperty(component);
            this.myPanelBuilder.getBindings().bind(visibleProperty, this.parseBool(visibleKey));
        }
        if ((enabledKey = attributes.getValue("enabled")) != null) {
            EnabledProperty enabledProperty = new EnabledProperty(component);
            this.myPanelBuilder.getBindings().bind(enabledProperty, this.parseBool(enabledKey));
        }
    }

    @NotNull
    private Runnable parseAction(String value2) {
        Matcher matcher = ACTION_PATTERN.matcher(value2);
        if (matcher.find()) {
            String varName = matcher.group(1);
            Runnable runnable = this.myContext.getAction(varName);
            if (runnable == null) {
                ServiceXmlParser.$$$reportNull$$$0(24);
            }
            return runnable;
        }
        throw new RuntimeException("Invalid action value (did you forget ${...()}): " + value2);
    }

    @NotNull
    private ObservableValue<Boolean> parseBool(@NotNull String value2) {
        Matcher matcher;
        if (value2 == null) {
            ServiceXmlParser.$$$reportNull$$$0(25);
        }
        if ((matcher = VAR_PATTERN.matcher(value2)).find()) {
            ObservableValue observableValue = this.myContext.getValue(matcher.group(1));
            if (observableValue == null) {
                ServiceXmlParser.$$$reportNull$$$0(26);
            }
            return observableValue;
        }
        Boolean boolValue = (Boolean)TypedVariable.parse(TypedVariable.Type.BOOLEAN, value2);
        if (boolValue == null) {
            throw new RuntimeException("Invalid bool value (did you forget ${...}): " + value2);
        }
        BoolValueProperty boolValueProperty = new BoolValueProperty(boolValue);
        if (boolValueProperty == null) {
            ServiceXmlParser.$$$reportNull$$$0(27);
        }
        return boolValueProperty;
    }

    @NotNull
    private ObservableValue<String> parseString(@NotNull String value2) {
        Matcher matcher;
        if (value2 == null) {
            ServiceXmlParser.$$$reportNull$$$0(28);
        }
        if ((matcher = VAR_PATTERN.matcher(value2)).find()) {
            ObservableValue observableValue = this.myContext.getValue(matcher.group(1));
            if (observableValue == null) {
                ServiceXmlParser.$$$reportNull$$$0(29);
            }
            return observableValue;
        }
        StringValueProperty stringValueProperty = new StringValueProperty(value2);
        if (stringValueProperty == null) {
            ServiceXmlParser.$$$reportNull$$$0(30);
        }
        return stringValueProperty;
    }

    @NotNull
    private ObservableValue<Integer> parseInt(@NotNull String value2) {
        Matcher matcher;
        if (value2 == null) {
            ServiceXmlParser.$$$reportNull$$$0(31);
        }
        if ((matcher = VAR_PATTERN.matcher(value2)).find()) {
            ObservableValue observableValue = this.myContext.getValue(matcher.group(1));
            if (observableValue == null) {
                ServiceXmlParser.$$$reportNull$$$0(32);
            }
            return observableValue;
        }
        Integer intValue = (Integer)TypedVariable.parse(TypedVariable.Type.INTEGER, value2);
        if (intValue == null) {
            throw new RuntimeException("Invalid integer value (did you forget ${...}): " + value2);
        }
        IntValueProperty intValueProperty = new IntValueProperty(intValue);
        if (intValueProperty == null) {
            ServiceXmlParser.$$$reportNull$$$0(33);
        }
        return intValueProperty;
    }

    @NotNull
    private <E> ObservableList<E> getList(@NotNull String value2) {
        Matcher matcher;
        if (value2 == null) {
            ServiceXmlParser.$$$reportNull$$$0(34);
        }
        if ((matcher = VAR_PATTERN.matcher(value2)).find()) {
            ObservableList observableList = (ObservableList)this.myContext.getValue(matcher.group(1));
            if (observableList == null) {
                ServiceXmlParser.$$$reportNull$$$0(35);
            }
            return observableList;
        }
        throw new RuntimeException("Invalid list value (did you forget ${...}): " + value2);
    }

    private String requireAttr(@NotNull Attributes attributes, @NotNull String attrFormat) {
        if (attributes == null) {
            ServiceXmlParser.$$$reportNull$$$0(36);
        }
        if (attrFormat == null) {
            ServiceXmlParser.$$$reportNull$$$0(37);
        }
        return SaxUtils.requireAttr((String)this.myTagStack.peek(), attributes, attrFormat);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlString";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/structure/services/ServiceXmlParser";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 25: 
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/structure/services/ServiceXmlParser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toUri";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeveloperServiceMetadata";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceCategory";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAction";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBool";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "parseString";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "parseInt";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toUri";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "endElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseServiceTag";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseManifestForPermissions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseUiGridTag";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseUiButton";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseUiCheckbox";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseUiInput";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseUiLabel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseUiLink";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseUiPulldown";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseRowCol";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "bindTopLevelProperties";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseBool";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseString";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parseInt";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getList";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "requireAttr";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Schema {
        private Schema() {
        }

        public static final class UiPulldown
        extends UiTag {
            public static final String TAG = "uiPulldown";
            public static final String ATTR_LIST = "list";
            public static final String ATTR_INDEX = "index";
        }

        public static final class UiLink
        extends UiTag {
            public static final String TAG = "uiLink";
            public static final String ATTR_TEXT = "text";
            public static final String ATTR_URL = "url";
        }

        public static final class UiLabel
        extends UiTag {
            public static final String TAG = "uiLabel";
            public static final String ATTR_TEXT = "text";
        }

        public static final class UiInput
        extends UiTag {
            public static final String TAG = "uiInput";
            public static final String ATTR_TEXT = "text";
        }

        public static final class UiCheckbox
        extends UiTag {
            public static final String TAG = "uiCheckbox";
            public static final String ATTR_TEXT = "text";
            public static final String ATTR_CHECKED = "checked";
        }

        public static final class UiButton
        extends UiTag {
            public static final String TAG = "uiButton";
            public static final String ATTR_TEXT = "text";
            public static final String ATTR_ACTION = "action";
        }

        public static final class UiGrid
        extends UiTag {
            public static final String TAG = "uiGrid";
            public static final String ATTR_COL_DEFINITIONS = "colDefinitions";
        }

        public static abstract class UiTag {
            public static final String ATTR_COL = "col";
            public static final String ATTR_ROW = "row";
            public static final String ATTR_ENABLED = "enabled";
            public static final String ATTR_VISIBLE = "visible";
        }

        public static final class Service {
            public static final String TAG = "service";
            public static final String ATTR_API_DOCS = "apiDocs";
            public static final String ATTR_CATEGORY = "category";
            public static final String ATTR_DESCRIPTION = "description";
            public static final String ATTR_EXECUTE = "execute";
            public static final String ATTR_FORMAT = "format";
            public static final String ATTR_ICON = "icon";
            public static final String ATTR_LEARN_MORE = "learnMore";
            public static final String ATTR_MIN_API = "minApi";
            public static final String ATTR_NAME = "name";
            public static final String ATTR_ID = "id";
        }
    }
}

