/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.structure.services.BuildSystemOperationsLookup;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceBuildSystemOperations;
import com.android.tools.idea.structure.services.ServiceContext;
import com.android.tools.idea.structure.services.ServiceXmlParser;
import com.android.tools.idea.templates.TemplateMetadata;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DeveloperServiceCreator {
    private static final String SERVICE_XML = "service.xml";
    @NotNull
    private final File myRootPath;

    public DeveloperServiceCreator() {
        try {
            this.myRootPath = new File(FileUtil.generateRandomTemporaryPath(), this.getResourceRoot());
            this.myRootPath.deleteOnExit();
            for (String name : this.getResources()) {
                assert (!name.contains("..")) : "Initializer resource can't specify relative path";
                File file = new File(this.myRootPath, name);
                Files.createParentDirs((File)file);
                assert (file.createNewFile());
                String fullName = String.format("%1$s/%2$s", this.getResourceRoot(), name);
                URL resource = this.getClass().getResource(fullName);
                if (resource == null) {
                    throw new FileNotFoundException(String.format("Could not find service file %1$s", fullName));
                }
                Resources.asByteSource((URL)resource).copyTo(Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static ServiceContext createContext(@NotNull Module module) {
        AndroidPlatform platform;
        if (module == null) {
            DeveloperServiceCreator.$$$reportNull$$$0(0);
        }
        String buildSystemId = BuildSystemOperationsLookup.getBuildSystemOperations(module.getProject()).getBuildSystemId();
        ServiceContext context = new ServiceContext(buildSystemId);
        String packageName = MergedManifest.get(module).getPackage();
        if (packageName != null) {
            context.putValue("packageName", new StringValueProperty(packageName));
        }
        if ((platform = AndroidPlatform.getInstance(module)) != null) {
            AndroidVersion version2 = platform.getApiVersion();
            context.putValue("buildApi", new IntValueProperty(version2.getFeatureLevel()));
            context.putValue("buildApiString", new StringValueProperty(TemplateMetadata.getBuildApiString(version2)));
        }
        ServiceContext serviceContext = context;
        if (serviceContext == null) {
            DeveloperServiceCreator.$$$reportNull$$$0(1);
        }
        return serviceContext;
    }

    protected static <T> void runInBackground(final @NotNull Callable<T> backgroundAction, final @Nullable Dispatchable<T> dispatchAfter) {
        if (backgroundAction == null) {
            DeveloperServiceCreator.$$$reportNull$$$0(2);
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result2 = backgroundAction.call();
                    if (result2 != null && dispatchAfter != null) {
                        dispatchAfter.dispatch(result2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    protected static void browse(@NotNull String url) {
        if (url == null) {
            DeveloperServiceCreator.$$$reportNull$$$0(3);
        }
        BrowserUtil.browse((String)url);
    }

    @Nullable
    protected static String getHighestVersion(@NotNull String groupId, @NotNull String artifactId, @NotNull ServiceContext serviceContext) {
        if (groupId == null) {
            DeveloperServiceCreator.$$$reportNull$$$0(4);
        }
        if (artifactId == null) {
            DeveloperServiceCreator.$$$reportNull$$$0(5);
        }
        if (serviceContext == null) {
            DeveloperServiceCreator.$$$reportNull$$$0(6);
        }
        DeveloperServiceBuildSystemOperations operations = BuildSystemOperationsLookup.getBuildSystemOperations(serviceContext.getBuildSystemId());
        return operations.getHighestVersion(groupId, artifactId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DeveloperService createService(@NotNull Module module) {
        if (module == null) {
            DeveloperServiceCreator.$$$reportNull$$$0(7);
        }
        if (AndroidFacet.getInstance(module) == null) {
            throw new IllegalArgumentException(String.format("Developer service cannot be associated with non-Android module %s", module.getName()));
        }
        ServiceContext context = DeveloperServiceCreator.createContext(module);
        this.initializeContext(context);
        final ServiceXmlParser serviceParser = new ServiceXmlParser(module, this.myRootPath, context);
        try (final FileInputStream serviceXml = new FileInputStream(new File(this.myRootPath, SERVICE_XML));){
            WriteCommandAction.runWriteCommandAction((Project)module.getProject(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        SAXParserFactory.newInstance().newSAXParser().parse(serviceXml, (DefaultHandler)serviceParser);
                    }
                    catch (ParserConfigurationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (SAXException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.getInstance(this.getClass()).warn(String.format("Skipping over invalid service in module %1$s: %2$s", module.getName(), e.getMessage()));
            return null;
        }
        return new DeveloperService(serviceParser);
    }

    @NotNull
    protected abstract String getResourceRoot();

    @NotNull
    protected abstract String[] getResources();

    protected void initializeContext(@NotNull ServiceContext serviceContext) {
        if (serviceContext == null) {
            DeveloperServiceCreator.$$$reportNull$$$0(8);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/structure/services/DeveloperServiceCreator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/structure/services/DeveloperServiceCreator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runInBackground";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "browse";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHighestVersion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createService";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "initializeContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface Dispatchable<T> {
        public void dispatch(@NotNull T var1);
    }
}

