/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.dialog;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.structure.IdeSdksConfigurable;
import com.android.tools.idea.gradle.structure.configurables.ui.CrossModuleUiStateComponent;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.idea.structure.dialog.AndroidConfigurableContributor;
import com.android.tools.idea.structure.dialog.CounterDisplayConfigurable;
import com.android.tools.idea.structure.dialog.ProjectStructureItemGroup;
import com.android.tools.idea.structure.dialog.SidePanel;
import com.android.tools.idea.structure.dialog.TrackedConfigurable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.google.wireless.android.sdk.stats.PSDEvent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureConfigurable
implements SearchableConfigurable,
Place.Navigator,
Configurable.NoMargin,
Configurable.NoScroll {
    public static final DataKey<ProjectStructureConfigurable> KEY = DataKey.create((String)"ProjectStructureConfiguration");
    @NonNls
    public static final String CATEGORY = "category";
    @NonNls
    public static final String CATEGORY_NAME = "categoryName";
    @NonNls
    private static final String LAST_EDITED_PROPERTY = "project.structure.last.edited";
    @NonNls
    private static final String PROPORTION_PROPERTY = "project.structure.proportion";
    @NonNls
    private static final String SIDE_PROPORTION_PROPERTY = "project.structure.side.proportion";
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeSdksConfigurable mySdksConfigurable;
    @NotNull
    private final Wrapper myDetails;
    @NotNull
    private final Map<Configurable, JComponent> myConfigurables;
    @NotNull
    private final UIState myUiState;
    private History myHistory;
    private JBSplitter mySplitter;
    private SidePanel mySidePanel;
    private JPanel myNotificationPanel;
    private JComponent myToolbarComponent;
    private JBLabel myErrorsComponent;
    private JComponent myToFocus;
    private boolean myUiInitialized;
    private boolean myShowing;
    private Configurable mySelectedConfigurable;
    private final JLabel myEmptySelection;
    private final EventDispatcher<ProjectStructureChangeListener> myChangeEventDispatcher;
    private MyDisposable myDisposable;
    private long myOpenTimeMs;

    @NotNull
    public static ProjectStructureConfigurable getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(0);
        }
        ProjectStructureConfigurable projectStructureConfigurable = (ProjectStructureConfigurable)ServiceManager.getService((Project)project, ProjectStructureConfigurable.class);
        if (projectStructureConfigurable == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(1);
        }
        return projectStructureConfigurable;
    }

    public ProjectStructureConfigurable(@NotNull Project project) {
        if (project == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(2);
        }
        this.myDetails = new Wrapper();
        this.myConfigurables = Maps.newLinkedHashMap();
        this.myUiState = new UIState();
        this.myHistory = new History((Place.Navigator)this);
        this.myShowing = false;
        this.myEmptySelection = new JLabel("<html><body><center>Select a setting to view or edit its details here</center></body></html>", 0);
        this.myChangeEventDispatcher = EventDispatcher.create(ProjectStructureChangeListener.class);
        this.myDisposable = new MyDisposable();
        this.myProject = project;
        this.mySdksConfigurable = new IdeSdksConfigurable((Configurable)this, project);
        this.mySdksConfigurable.setHistory(this.myHistory);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myUiState.lastEditedConfigurable = propertiesComponent.getValue(LAST_EDITED_PROPERTY);
        String proportion = propertiesComponent.getValue(PROPORTION_PROPERTY);
        this.myUiState.proportion = ProjectStructureConfigurable.parseFloatValue(proportion);
        String sideProportion = propertiesComponent.getValue(SIDE_PROPORTION_PROPERTY);
        this.myUiState.sideProportion = ProjectStructureConfigurable.parseFloatValue(sideProportion);
    }

    private static float parseFloatValue(@Nullable String value2) {
        if (value2 != null) {
            try {
                return Float.parseFloat(value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myToFocus;
    }

    public boolean showDialog() {
        return this.showDialog(null);
    }

    private boolean showDialog(@Nullable Runnable advanceInit) {
        return ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)this, advanceInit);
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    @NotNull
    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        JComponent toFocus;
        if (place == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                ProjectStructureConfigurable.$$$reportNull$$$0(3);
            }
            return actionCallback;
        }
        Object displayName = place.getPath(CATEGORY_NAME);
        Configurable toSelect = displayName instanceof String ? this.findConfigurable((String)displayName) : (Configurable)place.getPath(CATEGORY);
        JComponent detailsContent = this.myDetails.getTargetComponent();
        if (this.mySelectedConfigurable != toSelect) {
            this.saveSideProportion();
            this.removeSelected();
        }
        if (toSelect != null) {
            if (toSelect instanceof CrossModuleUiStateComponent) {
                ((CrossModuleUiStateComponent)toSelect).restoreUiState();
            }
            if ((detailsContent = this.myConfigurables.get(toSelect)) == null) {
                detailsContent = toSelect.createComponent();
                this.myConfigurables.put(toSelect, detailsContent);
            }
            this.myDetails.setContent(detailsContent);
        }
        this.mySelectedConfigurable = toSelect;
        if (this.mySelectedConfigurable != null) {
            this.myUiState.lastEditedConfigurable = this.mySelectedConfigurable.getDisplayName();
            PSDEvent.Builder psdEvent = PSDEvent.newBuilder().setGeneration(PSDEvent.PSDGeneration.PROJECT_STRUCTURE_DIALOG_GENERATION_002);
            if (this.mySelectedConfigurable instanceof TrackedConfigurable) {
                ((TrackedConfigurable)this.mySelectedConfigurable).applyTo(psdEvent);
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_STRUCTURE_DIALOG).setKind(AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_LEFT_NAV_CLICK).setPsdEvent(psdEvent), this.myProject));
            }
        }
        if (toSelect instanceof MasterDetailsComponent) {
            MasterDetailsComponent masterDetails = (MasterDetailsComponent)toSelect;
            if (this.myUiState.sideProportion > 0.0f) {
                masterDetails.getSplitter().setProportion(this.myUiState.sideProportion);
            }
            masterDetails.setHistory(this.myHistory);
        } else if (toSelect == this.mySdksConfigurable) {
            this.mySdksConfigurable.setHistory(this.myHistory);
        }
        if (toSelect != null) {
            this.mySidePanel.select(ProjectStructureConfigurable.createPlaceFor(toSelect));
        }
        JComponent jComponent = toFocus = this.mySelectedConfigurable == null ? null : this.mySelectedConfigurable.getPreferredFocusedComponent();
        if (toFocus == null && this.mySelectedConfigurable instanceof MasterDetailsComponent) {
            toFocus = ((MasterDetailsComponent)this.mySelectedConfigurable).getMaster();
        }
        if (toFocus == null && detailsContent != null && (toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)detailsContent)) == null) {
            toFocus = detailsContent;
        }
        this.myToFocus = toFocus;
        if (this.myToFocus != null) {
            UIUtil.requestFocus((JComponent)this.myToFocus);
        }
        ActionCallback result2 = new ActionCallback();
        Place.goFurther((Object)toSelect, (Place)place, (boolean)requestFocus).notifyWhenDone(result2);
        this.myDetails.revalidate();
        this.myDetails.repaint();
        if (!this.myHistory.isNavigatingNow() && this.mySelectedConfigurable != null) {
            this.myHistory.pushQueryPlace();
        }
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(4);
        }
        return actionCallback;
    }

    @Nullable
    private Configurable findConfigurable(@NotNull String displayName) {
        if (displayName == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(5);
        }
        for (Configurable configurable : this.myConfigurables.keySet()) {
            if (!displayName.equals(configurable.getDisplayName())) continue;
            return configurable;
        }
        return null;
    }

    private void saveSideProportion() {
        if (this.mySelectedConfigurable instanceof MasterDetailsComponent) {
            this.myUiState.sideProportion = ((MasterDetailsComponent)this.mySelectedConfigurable).getSplitter().getProportion();
        }
    }

    private void removeSelected() {
        this.myDetails.removeAll();
        this.mySelectedConfigurable = null;
        this.myUiState.lastEditedConfigurable = null;
        this.myDetails.add((Component)this.myEmptySelection, (Object)"Center");
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(6);
        }
        if (this.mySelectedConfigurable != null) {
            place.putPath(CATEGORY, (Object)this.mySelectedConfigurable);
            Place.queryFurther((Object)this.mySelectedConfigurable, (Place)place);
        }
    }

    @NotNull
    public String getId() {
        if ("android.project.structure" == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(7);
        }
        return "android.project.structure";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"project.settings.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return this.mySelectedConfigurable != null ? this.mySelectedConfigurable.getHelpTopic() : "";
    }

    @Nullable
    public JComponent createComponent() {
        MyPanel component = new MyPanel();
        this.mySplitter = new OnePixelSplitter(false, 0.15f);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.initSidePanel();
        JPanel left = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension original = super.getMinimumSize();
                return new Dimension(Math.max(original.width, 100), original.height);
            }
        };
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)new BackAction((JComponent)component, (Disposable)this.myDisposable));
        toolbarGroup.add((AnAction)new ForwardAction((JComponent)component, (Disposable)this.myDisposable));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("AndroidProjectStructure", (ActionGroup)toolbarGroup, true);
        toolbar.setTargetComponent((JComponent)component);
        this.myToolbarComponent = toolbar.getComponent();
        left.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myToolbarComponent.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        left.add((Component)this.myToolbarComponent, "North");
        left.add((Component)this.mySidePanel, "Center");
        this.mySplitter.setFirstComponent((JComponent)left);
        this.mySplitter.setSecondComponent((JComponent)this.myDetails);
        component.add((Component)this.mySplitter, "Center");
        this.myErrorsComponent = new JBLabel();
        component.add((Component)this.myErrorsComponent, "South");
        this.myUiInitialized = true;
        return component;
    }

    private void initSidePanel() {
        boolean isDefaultProject = this.myProject == ProjectManager.getInstance().getDefaultProject();
        this.mySidePanel = new SidePanel(this, this.myHistory);
        this.addConfigurable(this.mySdksConfigurable);
        if (!isDefaultProject) {
            this.addConfigurables();
        }
    }

    private void addConfigurables() {
        if (this.myDisposable.disposed) {
            this.myDisposable = new MyDisposable();
        }
        ArrayList additionalConfigurableGroups = Lists.newArrayList();
        for (AndroidConfigurableContributor contributor : (AndroidConfigurableContributor[])AndroidConfigurableContributor.EP_NAME.getExtensions()) {
            contributor.getMainConfigurables(this.myProject, this.myDisposable).forEach(this::addConfigurable);
            additionalConfigurableGroups.addAll(contributor.getAdditionalConfigurableGroups());
        }
        for (ProjectStructureItemGroup group : additionalConfigurableGroups) {
            String name = group.getGroupName();
            this.mySidePanel.addSeparator(name);
            group.getItems().forEach(this::addConfigurable);
        }
    }

    private void addConfigurable(@NotNull Configurable configurable) {
        if (configurable == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(8);
        }
        this.myConfigurables.put(configurable, null);
        if (configurable instanceof Place.Navigator) {
            Place.Navigator navigator = (Place.Navigator)configurable;
            navigator.setHistory(this.myHistory);
        }
        this.mySidePanel.addPlace(ProjectStructureConfigurable.createPlaceFor(configurable), new Presentation(configurable.getDisplayName()));
        if (configurable instanceof CounterDisplayConfigurable) {
            ((CounterDisplayConfigurable)configurable).add(() -> UIUtil.invokeLaterIfNeeded(() -> this.mySidePanel.repaint()), this.myDisposable);
        }
    }

    public static void putPath(@NotNull Place place, @NotNull Configurable configurable) {
        if (place == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(9);
        }
        if (configurable == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(10);
        }
        place.putPath(CATEGORY_NAME, (Object)configurable.getDisplayName());
    }

    @Nullable
    public <T extends Configurable> T findConfigurable(@NotNull Class<T> type) {
        if (type == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(11);
        }
        for (Configurable configurable : this.myConfigurables.keySet()) {
            if (!type.isInstance(configurable)) continue;
            return (T)((Configurable)type.cast(configurable));
        }
        return null;
    }

    @NotNull
    private static Place createPlaceFor(@NotNull Configurable configurable) {
        if (configurable == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(12);
        }
        Place place = new Place().putPath(CATEGORY, (Object)configurable);
        if (place == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(13);
        }
        return place;
    }

    public boolean isModified() {
        for (Configurable configurable : this.myConfigurables.keySet()) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        long duration = System.currentTimeMillis() - this.myOpenTimeMs;
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_STRUCTURE_DIALOG).setKind(AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_SAVE).setPsdEvent(PSDEvent.newBuilder().setGeneration(PSDEvent.PSDGeneration.PROJECT_STRUCTURE_DIALOG_GENERATION_002).setDurationMs(duration)), this.myProject));
        boolean applied = false;
        for (Configurable configurable : this.myConfigurables.keySet()) {
            if (!configurable.isModified()) continue;
            configurable.apply();
            applied = true;
        }
        if (applied) {
            ((ProjectStructureChangeListener)this.myChangeEventDispatcher.getMulticaster()).projectStructureChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Resetting Project Structure");
        try {
            this.mySdksConfigurable.reset();
            Configurable toSelect = null;
            for (Configurable each : this.myConfigurables.keySet()) {
                if (this.myUiState.lastEditedConfigurable != null && this.myUiState.lastEditedConfigurable.equals(each.getDisplayName())) {
                    toSelect = each;
                }
                if (each instanceof MasterDetailsComponent) {
                    ((MasterDetailsComponent)each).setHistory(this.myHistory);
                }
                each.disposeUIResources();
                each.reset();
            }
            this.myHistory.clear();
            if (toSelect == null && !this.myConfigurables.isEmpty()) {
                toSelect = this.myConfigurables.keySet().stream().findFirst().orElse(null);
            }
            this.removeSelected();
            this.navigateTo(toSelect != null ? ProjectStructureConfigurable.createPlaceFor(toSelect) : null, false);
            if (this.myUiState.proportion > 0.0f) {
                this.mySplitter.setProportion(this.myUiState.proportion);
            }
        }
        finally {
            token.finish();
        }
    }

    public void disposeUIResources() {
        if (!this.myUiInitialized) {
            return;
        }
        try {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            propertiesComponent.setValue(LAST_EDITED_PROPERTY, this.myUiState.lastEditedConfigurable);
            propertiesComponent.setValue(PROPORTION_PROPERTY, String.valueOf(this.myUiState.proportion));
            propertiesComponent.setValue(SIDE_PROPORTION_PROPERTY, String.valueOf(this.myUiState.sideProportion));
            this.myUiState.proportion = this.mySplitter.getProportion();
            this.saveSideProportion();
            this.myConfigurables.keySet().forEach(UnnamedConfigurable::disposeUIResources);
            Disposer.dispose((Disposable)this.myDisposable);
        }
        finally {
            this.myConfigurables.clear();
            this.myUiInitialized = false;
        }
    }

    @Nullable
    public History getHistory() {
        return this.myHistory;
    }

    public void add(@NotNull ProjectStructureChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(14);
        }
        if (parentDisposable == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(15);
        }
        this.myChangeEventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void add(@NotNull ProjectStructureChangeListener listener2) {
        if (listener2 == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(16);
        }
        this.myChangeEventDispatcher.addListener((EventListener)listener2);
    }

    public void remove(@NotNull ProjectStructureChangeListener listener2) {
        if (listener2 == null) {
            ProjectStructureConfigurable.$$$reportNull$$$0(17);
        }
        this.myChangeEventDispatcher.removeListener((EventListener)listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPlace(@Nullable Place place) {
        if (this.myShowing) {
            return;
        }
        if (GradleSyncState.getInstance(this.myProject).isSyncInProgress()) {
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
            if (ideFrame != null) {
                StatusBarEx statusBar = (StatusBarEx)ideFrame.getStatusBar();
                statusBar.notifyProgressByBalloon(MessageType.WARNING, "Project Structure is unavailable while sync is in progress.", null, null);
            }
            return;
        }
        AtomicBoolean needsSync = new AtomicBoolean();
        ProjectStructureChangeListener changeListener = () -> needsSync.set(true);
        this.add(changeListener);
        try {
            this.myOpenTimeMs = System.currentTimeMillis();
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_STRUCTURE_DIALOG).setKind(AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_OPEN).setPsdEvent(PSDEvent.newBuilder().setGeneration(PSDEvent.PSDGeneration.PROJECT_STRUCTURE_DIALOG_GENERATION_002)), this.myProject));
            this.myShowing = true;
            try {
                this.showDialog(() -> {
                    if (place != null) {
                        this.navigateTo(place, true);
                    }
                });
            }
            finally {
                this.myShowing = false;
            }
        }
        finally {
            this.remove(changeListener);
        }
        if (needsSync.get()) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
        }
    }

    public void show() {
        this.showPlace(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/structure/dialog/ProjectStructureConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/structure/dialog/ProjectStructureConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "navigateTo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlaceFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createPlaceFor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProjectStructureChangeListener
    extends EventListener {
        public void projectStructureChanged();
    }

    private static class MyDisposable
    implements Disposable {
        volatile boolean disposed;

        private MyDisposable() {
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    public static class UIState {
        public float proportion;
        public float sideProportion;
        @Nullable
        public String lastEditedConfigurable;
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        MyPanel() {
            super(new BorderLayout());
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            if (KEY.is(dataId)) {
                return ProjectStructureConfigurable.this;
            }
            if (History.KEY.is(dataId)) {
                return ProjectStructureConfigurable.this.getHistory();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/android/tools/idea/structure/dialog/ProjectStructureConfigurable$MyPanel", "getData"));
        }
    }
}

