/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.SettingsController;
import com.android.sdklib.devices.Storage;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioProgressIndicatorAdapter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.NotNull;

public class StudioDownloader
implements Downloader {
    @NotNull
    private final SettingsController mySettingsController;

    public StudioDownloader() {
        this(StudioSettingsController.getInstance());
    }

    StudioDownloader(@NotNull SettingsController settingsController) {
        if (settingsController == null) {
            StudioDownloader.$$$reportNull$$$0(0);
        }
        this.mySettingsController = settingsController;
    }

    public InputStream downloadAndStream(@NotNull URL url, @NotNull ProgressIndicator indicator) throws IOException {
        Path file;
        if (url == null) {
            StudioDownloader.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            StudioDownloader.$$$reportNull$$$0(2);
        }
        if ((file = this.downloadFully(url, indicator)) == null) {
            return null;
        }
        return Files.newInputStream(file, StandardOpenOption.DELETE_ON_CLOSE);
    }

    public void downloadFully(@NotNull URL url, @NotNull File target, String checksum, @NotNull ProgressIndicator indicator) throws IOException {
        if (url == null) {
            StudioDownloader.$$$reportNull$$$0(3);
        }
        if (target == null) {
            StudioDownloader.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            StudioDownloader.$$$reportNull$$$0(5);
        }
        this.doDownloadFully(url, target, checksum, false, indicator);
    }

    public void downloadFullyWithCaching(@NotNull URL url, @NotNull File target, String checksum, @NotNull ProgressIndicator indicator) throws IOException {
        if (url == null) {
            StudioDownloader.$$$reportNull$$$0(6);
        }
        if (target == null) {
            StudioDownloader.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            StudioDownloader.$$$reportNull$$$0(8);
        }
        this.doDownloadFully(url, target, checksum, true, indicator);
    }

    private void doDownloadFully(@NotNull URL url, @NotNull File target, String checksum, boolean allowNetworkCaches, @NotNull ProgressIndicator indicator) throws IOException {
        if (url == null) {
            StudioDownloader.$$$reportNull$$$0(9);
        }
        if (target == null) {
            StudioDownloader.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            StudioDownloader.$$$reportNull$$$0(11);
        }
        if (target.exists() && checksum != null && checksum.equals(Downloader.hash((InputStream)new BufferedInputStream(new FileInputStream(target)), (long)target.length(), (ProgressIndicator)indicator))) {
            return;
        }
        String preparedUrl = this.prepareUrl(url);
        indicator.logInfo("Downloading " + preparedUrl);
        indicator.setText("Downloading...");
        indicator.setSecondaryText(preparedUrl);
        RequestBuilder rb = HttpRequests.request((String)preparedUrl).productNameAsUserAgent();
        if (this.mySettingsController.getForceHttp()) {
            rb.forceHttps(false);
        }
        rb.tuner(c -> c.setUseCaches(allowNetworkCaches));
        rb.connect(request -> {
            long contentLength = request.getConnection().getContentLength();
            return request.saveToFile(target, (com.intellij.openapi.progress.ProgressIndicator)new DownloadProgressIndicator(indicator, contentLength));
        });
    }

    public Path downloadFully(@NotNull URL url, @NotNull ProgressIndicator indicator) throws IOException {
        if (url == null) {
            StudioDownloader.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            StudioDownloader.$$$reportNull$$$0(13);
        }
        String suffix = url.getPath();
        suffix = suffix.substring(suffix.lastIndexOf(47) + 1);
        File tempFile = FileUtil.createTempFile((String)"StudioDownloader", (String)suffix, (boolean)true);
        tempFile.deleteOnExit();
        this.downloadFully(url, tempFile, null, indicator);
        return tempFile.toPath();
    }

    @NotNull
    String prepareUrl(@NotNull URL url) {
        if (url == null) {
            StudioDownloader.$$$reportNull$$$0(14);
        }
        String prepared = url.toExternalForm();
        if (this.mySettingsController.getForceHttp() && StringUtil.startsWith((CharSequence)prepared, (CharSequence)"https:")) {
            prepared = "http:" + prepared.substring(6);
        }
        String string = prepared;
        if (string == null) {
            StudioDownloader.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsController";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/StudioDownloader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/StudioDownloader";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "downloadAndStream";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "downloadFully";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "downloadFullyWithCaching";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doDownloadFully";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareUrl";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DownloadProgressIndicator
    extends StudioProgressIndicatorAdapter {
        private final long mContentLength;
        private final String mTotalDisplaySize;
        private int mCurrentPercentage;
        private Storage.Unit mReasonableUnit;

        public DownloadProgressIndicator(@NotNull ProgressIndicator wrapped, long contentLength) {
            if (wrapped == null) {
                DownloadProgressIndicator.$$$reportNull$$$0(0);
            }
            super(wrapped);
            this.mContentLength = contentLength;
            Storage storage = new Storage(this.mContentLength);
            this.mReasonableUnit = storage.getLargestReasonableUnits();
            this.mTotalDisplaySize = storage.toUiString(1);
        }

        @Override
        public void setFraction(double fraction) {
            super.setFraction(fraction);
            this.checkCanceled();
            int percentage = (int)(fraction * 100.0);
            if (percentage == this.mCurrentPercentage) {
                return;
            }
            this.mCurrentPercentage = percentage;
            long downloadedSize = (long)(fraction * (double)this.mContentLength);
            double downloadedSizeInReasonableUnits = new Storage(downloadedSize).getPreciseSizeAsUnit(this.mReasonableUnit);
            this.setText(String.format("Downloading (%1$d%%): %2$.1f / %3$s ...", this.mCurrentPercentage, downloadedSizeInReasonableUnits, this.mTotalDisplaySize));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "com/android/tools/idea/sdk/StudioDownloader$DownloadProgressIndicator", "<init>"));
        }
    }
}

