/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectNdkDialog
extends DialogWrapper {
    private boolean myHasBeenEdited = false;
    private JPanel myPanel;
    private JBLabel myInvalidNdkPathLabel;
    private JRadioButton myRemoveInvalidNdkRadioButton;
    private JRadioButton mySelectValidNdkRadioButton;
    private TextFieldWithBrowseButton myNdkTextFieldWithButton;
    private JRadioButton myDownloadNdkRadioButton;
    private JBLabel myHeaderText;
    private JBLabel myErrorLabel;
    private JBLabel myChoiceLabel;
    private String myNdkPath = "";

    public SelectNdkDialog(@Nullable String invalidNdkPath, boolean showRemove, boolean showDownload) {
        super(false);
        this.$$$setupUI$$$();
        this.init();
        this.setTitle("Select Android NDK");
        this.myInvalidNdkPathLabel.setText(invalidNdkPath);
        this.configureNdkTextField();
        if (showDownload) {
            this.myDownloadNdkRadioButton.setSelected(true);
            this.myNdkTextFieldWithButton.setEnabled(false);
        } else {
            this.myDownloadNdkRadioButton.setVisible(false);
            this.mySelectValidNdkRadioButton.setSelected(true);
            this.myNdkTextFieldWithButton.setEnabled(true);
            this.getOKAction().setEnabled(false);
        }
        if (!showDownload && !showRemove) {
            this.mySelectValidNdkRadioButton.setVisible(false);
            this.myChoiceLabel.setVisible(false);
        }
        if (showRemove) {
            this.myRemoveInvalidNdkRadioButton.addActionListener(actionEvent -> this.myNdkTextFieldWithButton.setEnabled(!this.myRemoveInvalidNdkRadioButton.isSelected()));
        } else {
            this.myRemoveInvalidNdkRadioButton.setVisible(false);
        }
        if (invalidNdkPath == null) {
            this.myHeaderText.setText("The project's local.properties doesn't contain an NDK path.");
        } else {
            this.myHeaderText.setText("The project's local.properties file contains an invalid NDK path:");
            this.myErrorLabel.setText(SdkPaths.validateAndroidNdk((File)new File((String)invalidNdkPath), (boolean)false).message);
            this.myErrorLabel.setVisible(true);
            this.myErrorLabel.setForeground((Color)JBColor.RED);
        }
        this.mySelectValidNdkRadioButton.addChangeListener(e -> this.myNdkTextFieldWithButton.setEnabled(this.mySelectValidNdkRadioButton.isSelected()));
    }

    private void configureNdkTextField() {
        this.myNdkTextFieldWithButton.setTextFieldPreferredWidth(50);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(@NotNull VirtualFile[] files2) throws Exception {
                if (files2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VirtualFile virtualFile : files2) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidNdk(file, false);
                    if (validationResult.success) continue;
                    String msg = validationResult.message;
                    if (StringUtil.isEmpty((String)msg)) {
                        msg = "Please choose a valid Android NDK directory.";
                    }
                    throw new IllegalArgumentException(msg);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/sdk/SelectNdkDialog$1", "validateSelectedFiles"));
            }
        };
        if (SystemInfo.isMac) {
            descriptor.withShowHiddenFiles(true);
        }
        descriptor.setTitle("Choose Android NDK Location");
        this.myNdkTextFieldWithButton.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Select Android NDK Home", null, (ComponentWithBrowseButton)this.myNdkTextFieldWithButton, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!this.mySelectValidNdkRadioButton.isSelected()) {
            return null;
        }
        String ndkPath = this.myNdkTextFieldWithButton.getText().trim();
        if (!Strings.isNullOrEmpty((String)ndkPath)) {
            this.myHasBeenEdited = true;
        }
        if (!this.myHasBeenEdited) {
            return null;
        }
        String ndkError = SelectNdkDialog.validateAndroidNdkPath(ndkPath);
        if (ndkError != null) {
            return new ValidationInfo(ndkError, (JComponent)this.myNdkTextFieldWithButton.getTextField());
        }
        return null;
    }

    @Nullable
    private static String validateAndroidNdkPath(@Nullable String path) {
        if (StringUtil.isEmpty((String)path)) {
            return "Android NDK path not specified.";
        }
        SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidNdk(FilePaths.toSystemDependentPath((String)path), false);
        if (!validationResult.success) {
            return String.format("Invalid Android NDK path:<br>%1$s", validationResult.message);
        }
        return null;
    }

    protected void doOKAction() {
        File ndk;
        ImmutableList requested;
        ModelWizardDialog dialog;
        if (this.myDownloadNdkRadioButton.isSelected() && (dialog = SdkQuickfixUtils.createDialogForPaths(this.myPanel, (Collection<String>)(requested = ImmutableList.of((Object)"ndk-bundle")), false)) != null && dialog.showAndGet() && (ndk = IdeSdks.getInstance().getAndroidNdkPath()) != null) {
            this.myNdkPath = ndk.getPath();
        }
        if (this.mySelectValidNdkRadioButton.isSelected()) {
            this.myNdkPath = this.myNdkTextFieldWithButton.getText();
        }
        super.doOKAction();
    }

    @NotNull
    public String getAndroidNdkPath() {
        String string = this.myNdkPath;
        if (string == null) {
            SelectNdkDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SelectNdkDialog", "getAndroidNdkPath"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JBLabel jBLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNdkTextFieldWithButton = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(8, 1, 1, 1, 0, 1, 6, 0, new Dimension(300, -1), null, null));
        this.myHeaderText = jBLabel4 = new JBLabel();
        jBLabel4.setText("");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Please provide the path to the Android NDK.");
        jPanel.add((Component)jBLabel5, new GridConstraints(7, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRemoveInvalidNdkRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Remove the invalid NDK path ");
        jPanel2.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySelectValidNdkRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Select a valid NDK path");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDownloadNdkRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Download NDK");
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText(" ");
        jPanel.add((Component)jBLabel6, new GridConstraints(6, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myInvalidNdkPathLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("");
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText(" ");
        jPanel.add((Component)jBLabel7, new GridConstraints(3, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myChoiceLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Do you want to ");
        jPanel.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myErrorLabel = jBLabel = new JBLabel();
        jBLabel.setVisible(false);
        jPanel.add((Component)jBLabel, new GridConstraints(2, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

