/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.hyperlink.DownloadAndroidStudioHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.DownloadJdk8Hyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SelectJdkFromFileSystemHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.UseCurrentlyRunningJdkHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.UseEmbeddedJdkHyperlink;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jdks {
    @NotNull
    private static final Logger LOG = Logger.getInstance(Jdks.class);
    @NonNls
    public static final String DOWNLOAD_JDK_8_URL = "http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html";
    private static final LanguageLevel DEFAULT_LANG_LEVEL = LanguageLevel.JDK_1_8;
    @NotNull
    private final IdeInfo myIdeInfo;

    @NotNull
    public static Jdks getInstance() {
        Jdks jdks = (Jdks)ServiceManager.getService(Jdks.class);
        if (jdks == null) {
            Jdks.$$$reportNull$$$0(0);
        }
        return jdks;
    }

    public Jdks(@NotNull IdeInfo ideInfo) {
        if (ideInfo == null) {
            Jdks.$$$reportNull$$$0(1);
        }
        this.myIdeInfo = ideInfo;
    }

    @Nullable
    public Sdk chooseOrCreateJavaSdk() {
        return this.chooseOrCreateJavaSdk(null);
    }

    @Nullable
    public Sdk chooseOrCreateJavaSdk(@Nullable LanguageLevel langLevel) {
        if (langLevel == null) {
            langLevel = DEFAULT_LANG_LEVEL;
        }
        if (this.myIdeInfo.isAndroidStudio() && !IdeSdks.getInstance().isUsingEmbeddedJdk()) {
            File viableJdkPath = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
            if (viableJdkPath == null) {
                viableJdkPath = new File(System.getProperty("java.home"));
            }
            Sdk jdk = this.createJdk(viableJdkPath.getPath());
            assert (jdk != null && this.isApplicableJdk(jdk, langLevel));
            return jdk;
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!this.isApplicableJdk(sdk, langLevel)) continue;
            return sdk;
        }
        String jdkHomePath = Jdks.getJdkHomePath(langLevel);
        if (jdkHomePath != null) {
            return this.createJdk(jdkHomePath);
        }
        return null;
    }

    public boolean isApplicableJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            Jdks.$$$reportNull$$$0(2);
        }
        return this.isApplicableJdk(jdk, null);
    }

    public boolean isApplicableJdk(@NotNull Sdk jdk, @Nullable LanguageLevel langLevel) {
        JavaSdkVersion version2;
        if (jdk == null) {
            Jdks.$$$reportNull$$$0(3);
        }
        if (!(jdk.getSdkType() instanceof JavaSdk)) {
            return false;
        }
        if (langLevel == null) {
            langLevel = DEFAULT_LANG_LEVEL;
        }
        if ((version2 = JavaSdk.getInstance().getVersion(jdk)) != null) {
            return Jdks.hasMatchingLangLevel(version2, langLevel);
        }
        return false;
    }

    @Nullable
    public static String getJdkHomePath(@Nullable LanguageLevel langLevel) {
        ArrayList jdkHomePaths;
        if (langLevel == null) {
            langLevel = DEFAULT_LANG_LEVEL;
        }
        if ((jdkHomePaths = new ArrayList(JavaSdk.getInstance().suggestHomePaths())).isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String javaHome = SystemProperties.getJavaHome();
        if (javaHome != null && !javaHome.isEmpty()) {
            Iterator it = jdkHomePaths.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (path == null || !javaHome.startsWith(path)) continue;
                it.remove();
                list.add(path);
            }
        }
        list.addAll(jdkHomePaths);
        return Jdks.getBestJdkHomePath(list, langLevel);
    }

    @Nullable
    private static String getBestJdkHomePath(@NotNull Collection<String> jdkHomePaths, @NotNull LanguageLevel langLevel) {
        if (jdkHomePaths == null) {
            Jdks.$$$reportNull$$$0(4);
        }
        if (langLevel == null) {
            Jdks.$$$reportNull$$$0(5);
        }
        ArrayList roots = Lists.newArrayList();
        for (String jdkHomePath : jdkHomePaths) {
            if (!StringUtil.isNotEmpty((String)jdkHomePath)) continue;
            roots.add(jdkHomePath);
            roots.addAll(Jdks.getChildrenPaths(jdkHomePath));
        }
        return Jdks.getBestJdk(roots, langLevel);
    }

    @NotNull
    private static List<String> getChildrenPaths(@NotNull String dirPath) {
        File dir;
        if (dirPath == null) {
            Jdks.$$$reportNull$$$0(6);
        }
        if (!(dir = new File(dirPath)).isDirectory()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                Jdks.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList childrenPaths = Lists.newArrayList();
        for (File child : FileUtil.notNullize((File[])dir.listFiles())) {
            boolean directory = child.isDirectory();
            if (!directory) continue;
            childrenPaths.add(child.getAbsolutePath());
        }
        ArrayList arrayList = childrenPaths;
        if (arrayList == null) {
            Jdks.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    private static String getBestJdk(@NotNull List<String> jdkRoots, @NotNull LanguageLevel langLevel) {
        if (jdkRoots == null) {
            Jdks.$$$reportNull$$$0(9);
        }
        if (langLevel == null) {
            Jdks.$$$reportNull$$$0(10);
        }
        String bestJdk = null;
        for (String jdkRoot : jdkRoots) {
            if (!JavaSdk.getInstance().isValidSdkHome(jdkRoot)) continue;
            if (bestJdk == null && Jdks.hasMatchingLangLevel(jdkRoot, langLevel)) {
                bestJdk = jdkRoot;
                continue;
            }
            if (bestJdk == null) continue;
            bestJdk = Jdks.selectJdk(bestJdk, jdkRoot, langLevel);
        }
        return bestJdk;
    }

    @Nullable
    private static String selectJdk(@NotNull String jdk1, @NotNull String jdk2, @NotNull LanguageLevel langLevel) {
        if (jdk1 == null) {
            Jdks.$$$reportNull$$$0(11);
        }
        if (jdk2 == null) {
            Jdks.$$$reportNull$$$0(12);
        }
        if (langLevel == null) {
            Jdks.$$$reportNull$$$0(13);
        }
        if (Jdks.hasMatchingLangLevel(jdk1, langLevel)) {
            return jdk1;
        }
        if (Jdks.hasMatchingLangLevel(jdk2, langLevel)) {
            return jdk2;
        }
        return null;
    }

    private static boolean hasMatchingLangLevel(@NotNull String jdkRoot, @NotNull LanguageLevel langLevel) {
        JavaSdkVersion version2;
        if (jdkRoot == null) {
            Jdks.$$$reportNull$$$0(14);
        }
        if (langLevel == null) {
            Jdks.$$$reportNull$$$0(15);
        }
        if ((version2 = Jdks.getVersion(jdkRoot)) == null) {
            version2 = JavaSdkVersion.JDK_1_0;
        }
        return Jdks.hasMatchingLangLevel(version2, langLevel);
    }

    @VisibleForTesting
    static boolean hasMatchingLangLevel(@NotNull JavaSdkVersion jdkVersion, @NotNull LanguageLevel langLevel) {
        if (jdkVersion == null) {
            Jdks.$$$reportNull$$$0(16);
        }
        if (langLevel == null) {
            Jdks.$$$reportNull$$$0(17);
        }
        LanguageLevel max = jdkVersion.getMaxLanguageLevel();
        return max.isAtLeast(langLevel);
    }

    @Nullable
    public JavaSdkVersion findVersion(@NotNull File jdkRoot) {
        if (jdkRoot == null) {
            Jdks.$$$reportNull$$$0(18);
        }
        return Jdks.getVersion(jdkRoot.getPath());
    }

    @Nullable
    private static JavaSdkVersion getVersion(String jdkRoot) {
        String version2 = JavaSdk.getInstance().getVersionString(jdkRoot);
        return StringUtil.isEmpty((String)version2) ? null : JavaSdkVersion.fromVersionString((String)version2);
    }

    @Nullable
    public Sdk createJdk(@NotNull String jdkHomePath) {
        Sdk jdk;
        if (jdkHomePath == null) {
            Jdks.$$$reportNull$$$0(19);
        }
        if ((jdk = SdkConfigurationUtil.createAndAddSDK((String)jdkHomePath, (SdkType)JavaSdk.getInstance())) == null) {
            String msg = String.format("Unable to create JDK from path '%1$s'", jdkHomePath);
            LOG.error(msg);
        }
        return jdk;
    }

    @Nullable
    public Sdk createEmbeddedJdk() {
        if (this.myIdeInfo.isAndroidStudio()) {
            File path = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
            if (path == null) {
                return null;
            }
            Sdk jdk = this.createJdk(path.getPath());
            assert (jdk != null);
            return jdk;
        }
        return null;
    }

    public void setJdk(@NotNull Project project, @NotNull Sdk jdk) {
        if (project == null) {
            Jdks.$$$reportNull$$$0(20);
        }
        if (jdk == null) {
            Jdks.$$$reportNull$$$0(21);
        }
        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)jdk);
    }

    @NotNull
    public List<NotificationHyperlink> getWrongJdkQuickFixes(@NotNull Project project) {
        if (project == null) {
            Jdks.$$$reportNull$$$0(22);
        }
        ArrayList quickFixes = Lists.newArrayList();
        if (this.myIdeInfo.isAndroidStudio()) {
            File embeddedJdkPath = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
            if (embeddedJdkPath == null || !Jdks.isJdkRunnableOnPlatform(embeddedJdkPath.getAbsolutePath())) {
                DownloadAndroidStudioHyperlink downloadAndroidStudioHyperLink = new DownloadAndroidStudioHyperlink();
                quickFixes.add(downloadAndroidStudioHyperLink);
                UseCurrentlyRunningJdkHyperlink useCurrentJdkHyperLink = UseCurrentlyRunningJdkHyperlink.create();
                if (useCurrentJdkHyperLink != null) {
                    quickFixes.add(useCurrentJdkHyperLink);
                }
            } else {
                UseEmbeddedJdkHyperlink useEmbeddedJdkHyperlink = UseEmbeddedJdkHyperlink.create();
                if (useEmbeddedJdkHyperlink != null) {
                    quickFixes.add(useEmbeddedJdkHyperlink);
                }
            }
        }
        quickFixes.add(new DownloadJdk8Hyperlink());
        SelectJdkFromFileSystemHyperlink selectJdkHyperlink = SelectJdkFromFileSystemHyperlink.create(project);
        if (selectJdkHyperlink != null) {
            quickFixes.add(selectJdkHyperlink);
        }
        ArrayList arrayList = quickFixes;
        if (arrayList == null) {
            Jdks.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    public static boolean isJdkRunnableOnPlatform(@NotNull Sdk jdk) {
        if (jdk == null) {
            Jdks.$$$reportNull$$$0(24);
        }
        if (!(jdk.getSdkType() instanceof JavaSdk)) {
            return false;
        }
        if (!SystemInfo.isWindows || !SystemInfo.is32Bit) {
            return true;
        }
        JavaSdk javaSdk = (JavaSdk)jdk.getSdkType();
        String javaExecutablePath = javaSdk.getVMExecutablePath(jdk);
        return Jdks.runAndCheckJVM(javaExecutablePath);
    }

    private static boolean isJdkRunnableOnPlatform(@NotNull String jdkHome) {
        if (jdkHome == null) {
            Jdks.$$$reportNull$$$0(25);
        }
        return Jdks.runAndCheckJVM(FileUtil.join((String[])new String[]{jdkHome, "bin", "java"}));
    }

    private static boolean runAndCheckJVM(@NotNull String javaExecutablePath) {
        if (javaExecutablePath == null) {
            Jdks.$$$reportNull$$$0(26);
        }
        LOG.info("Checking java binary: " + javaExecutablePath);
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{javaExecutablePath});
        commandLine.addParameter("-version");
        try {
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            int exitCode = process.runProcess().getExitCode();
            return exitCode == 0;
        }
        catch (ExecutionException e) {
            LOG.info("Could not invoke 'java -version'", (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/Jdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 2: 
            case 3: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHomePaths";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langLevel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk2";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkRoot";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkVersion";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHomePath";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHome";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaExecutablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/Jdks";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenPaths";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrongJdkQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableJdk";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBestJdkHomePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenPaths";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBestJdk";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "selectJdk";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchingLangLevel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findVersion";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setJdk";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getWrongJdkQuickFixes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isJdkRunnableOnPlatform";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "runAndCheckJVM";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

