/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata.datasource;

import com.google.common.base.Charsets;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import libcore.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceContent
implements Function<OutputStream, Exception> {
    private static final Logger LOG = Logger.getInstance(ResourceContent.class);
    private static final String[] LIB_CUSTOM_PATHS = new String[]{"/plugins/android/lib/sampleData", "/../adt/idea/android/lib/sampleData", "/community/android/android/lib/sampleData"};
    byte[] myContent;

    private ResourceContent(@NotNull byte[] content) {
        if (content == null) {
            ResourceContent.$$$reportNull$$$0(0);
        }
        this.myContent = content;
    }

    @Nullable
    public static File getSampleDataBaseDir() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        StringBuilder notFoundPaths = new StringBuilder();
        for (String path : LIB_CUSTOM_PATHS) {
            String jarPath = homePath + path;
            VirtualFile rootDir = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)jarPath));
            if (rootDir != null) {
                File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)rootDir);
                if (!rootFile.exists()) continue;
                LOG.debug("Sample data base dir found at " + jarPath);
                return rootFile;
            }
            notFoundPaths.append(jarPath).append('\n');
        }
        LOG.warn("Unable to sampleData in paths:\n" + notFoundPaths.toString());
        return null;
    }

    @NotNull
    public static ResourceContent fromDirectory(@NotNull String relativePath) {
        File baseDir;
        if (relativePath == null) {
            ResourceContent.$$$reportNull$$$0(1);
        }
        File sampleDataPath = (baseDir = ResourceContent.getSampleDataBaseDir()) != null ? new File(baseDir, relativePath) : null;
        File[] files2 = sampleDataPath != null && sampleDataPath.isDirectory() ? sampleDataPath.listFiles() : null;
        StringBuilder content = new StringBuilder();
        if (files2 != null) {
            for (File file : files2) {
                content.append(file.getAbsolutePath()).append('\n');
            }
        }
        ResourceContent resourceContent = new ResourceContent(content.toString().getBytes(Charsets.UTF_8));
        if (resourceContent == null) {
            ResourceContent.$$$reportNull$$$0(2);
        }
        return resourceContent;
    }

    @NotNull
    public static ResourceContent fromInputStream(@NotNull InputStream stream) {
        byte[] content;
        if (stream == null) {
            ResourceContent.$$$reportNull$$$0(3);
        }
        try {
            content = Streams.readFully((InputStream)stream);
        }
        catch (IOException e) {
            content = new byte[]{};
        }
        ResourceContent resourceContent = new ResourceContent(content);
        if (resourceContent == null) {
            ResourceContent.$$$reportNull$$$0(4);
        }
        return resourceContent;
    }

    @Override
    public Exception apply(OutputStream stream) {
        try {
            stream.write(this.myContent);
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sampledata/datasource/ResourceContent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sampledata/datasource/ResourceContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromDirectory";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromInputStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

