/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.deploy.swapper.DexArchiveDatabase;
import com.android.tools.deploy.swapper.SQLiteDexArchiveDatabase;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkDiffer;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.Installer;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class UnifiedDeployTask
implements LaunchTask,
Deployer.InstallerCallBack {
    private static final String ID = "UNIFIED_DEPLOY";
    private final Collection<ApkInfo> myApks;
    private static DexArchiveDatabase myDb = new SQLiteDexArchiveDatabase(new File(Paths.get(PathManager.getSystemPath(), ".deploy.db").toString()));
    public static final Logger LOG = Logger.getInstance(UnifiedDeployTask.class);
    private final boolean mySwap;

    public UnifiedDeployTask(@NotNull Collection<ApkInfo> apks, boolean swap) {
        if (apks == null) {
            UnifiedDeployTask.$$$reportNull$$$0(0);
        }
        this.myApks = apks;
        this.mySwap = swap;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Installing APK" == null) {
            UnifiedDeployTask.$$$reportNull$$$0(1);
        }
        return "Installing APK";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    private String getLocalInstaller() {
        File path = new File(PathManager.getHomePath(), "plugins/android/resources/installer");
        if (!path.exists()) {
            path = new File(PathManager.getHomePath(), "../../bazel-bin/tools/base/deploy/installer/android");
        }
        return path.getAbsolutePath();
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            UnifiedDeployTask.$$$reportNull$$$0(2);
        }
        if (launchStatus == null) {
            UnifiedDeployTask.$$$reportNull$$$0(3);
        }
        if (printer == null) {
            UnifiedDeployTask.$$$reportNull$$$0(4);
        }
        boolean error = false;
        for (ApkInfo apk : this.myApks) {
            Deployer.RunResponse.Analysis analysis;
            System.err.println("Processing application:" + apk.getApplicationId());
            List paths2 = apk.getFiles().stream().map(apkunit -> apkunit.getApkFile().getPath()).collect(Collectors.toList());
            AdbClient adb = new AdbClient(device);
            Installer installer = new Installer(this.getLocalInstaller(), adb);
            Deployer deployer = new Deployer(apk.getApplicationId(), paths2, (Deployer.InstallerCallBack)this, adb, myDb, installer);
            Deployer.RunResponse response = null;
            try {
                response = this.mySwap ? deployer.fullSwap() : deployer.install();
            }
            catch (IOException e) {
                LOG.error("Error deploying APK", (Throwable)e);
                return false;
            }
            if (response.status == Deployer.RunResponse.Status.ERROR) {
                System.err.println(response.errorMessage);
                return error;
            }
            if (response.status == Deployer.RunResponse.Status.NOT_INSTALLED) {
                for (String apkAnalysisKey : response.result.keySet()) {
                    analysis = (Deployer.RunResponse.Analysis)response.result.get(apkAnalysisKey);
                    System.err.println("Apk: " + apkAnalysisKey);
                    System.err.println("    local apk id: " + analysis.localApkHash);
                }
                continue;
            }
            for (String apkAnalysisKey : response.result.keySet()) {
                analysis = (Deployer.RunResponse.Analysis)response.result.get(apkAnalysisKey);
                System.err.println("Apk: " + apkAnalysisKey);
                System.err.println("    local apk id: " + analysis.localApkHash);
                System.err.println("    remot apk id: " + analysis.remoteApkHash);
                for (Map.Entry statusEntry : analysis.diffs.entrySet()) {
                    System.err.println("  " + (String)statusEntry.getKey() + " [" + ((ApkDiffer.ApkEntryStatus)statusEntry.getValue()).toString().toLowerCase() + "]");
                }
            }
        }
        return true;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            UnifiedDeployTask.$$$reportNull$$$0(5);
        }
        return ID;
    }

    public void onInstallationFinished(boolean status) {
        System.err.println("Installation finished");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apks";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/UnifiedDeployTask";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/UnifiedDeployTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

