/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.instantapp.InstantAppSdks;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.android.instantapps.sdk.api.ExtendedSdk;
import com.google.android.instantapps.sdk.api.HandlerResult;
import com.google.android.instantapps.sdk.api.ProgressIndicator;
import com.google.android.instantapps.sdk.api.ResultStream;
import com.google.android.instantapps.sdk.api.StatusCode;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInstantAppTask
implements LaunchTask {
    private static final String ID = "RUN_INSTANT_APP";
    @NotNull
    private final Collection<ApkInfo> myPackages;
    @Nullable
    private final String myDeepLink;
    @NotNull
    private final InstantAppSdks mySdk;
    @NotNull
    private final List<String> myDisabledFeatures;

    public RunInstantAppTask(@NotNull Collection<ApkInfo> packages, @Nullable String link, @NotNull List<String> disabledFeatures) {
        if (packages == null) {
            RunInstantAppTask.$$$reportNull$$$0(0);
        }
        if (disabledFeatures == null) {
            RunInstantAppTask.$$$reportNull$$$0(1);
        }
        this.myPackages = packages;
        this.myDeepLink = link;
        this.mySdk = InstantAppSdks.getInstance();
        this.myDisabledFeatures = disabledFeatures;
    }

    public RunInstantAppTask(@NotNull Collection<ApkInfo> packages, @Nullable String link) {
        if (packages == null) {
            RunInstantAppTask.$$$reportNull$$$0(2);
        }
        this(packages, link, (List<String>)ImmutableList.of());
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Uploading and launching Instant App" == null) {
            RunInstantAppTask.$$$reportNull$$$0(3);
        }
        return "Uploading and launching Instant App";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, final @NotNull ConsolePrinter printer) {
        if (device == null) {
            RunInstantAppTask.$$$reportNull$$$0(4);
        }
        if (launchStatus == null) {
            RunInstantAppTask.$$$reportNull$$$0(5);
        }
        if (printer == null) {
            RunInstantAppTask.$$$reportNull$$$0(6);
        }
        if (launchStatus.isLaunchTerminated()) {
            return false;
        }
        if (this.myPackages.size() != 1) {
            printer.stderr("Package not found or not unique.");
            return false;
        }
        URL url = null;
        if (this.myDeepLink != null && !this.myDeepLink.isEmpty()) {
            try {
                url = new URL(this.myDeepLink);
            }
            catch (MalformedURLException e) {
                printer.stderr("Invalid launch URL: " + this.myDeepLink);
                return false;
            }
        }
        ResultStream resultStream = new ResultStream(){

            public void write(HandlerResult result2) {
                if (result2.isError()) {
                    printer.stderr(result2.toString());
                    RunInstantAppTask.getLogger().error((Throwable)new RunInstantAppException(result2.getMessage()));
                } else {
                    printer.stdout(result2.toString());
                }
            }
        };
        try {
            ExtendedSdk aiaSdk = this.mySdk.loadLibrary();
            assert (aiaSdk != null);
            ApkInfo apkInfo = this.myPackages.iterator().next();
            List<ApkFileUnit> artifactFiles = apkInfo.getFiles();
            StatusCode status = RunInstantAppTask.isSingleZipFile(artifactFiles) ? aiaSdk.getRunHandler().runZip(artifactFiles.get(0).getApkFile(), url, AndroidDebugBridge.getSocketAddress(), device.getSerialNumber(), null, resultStream, (ProgressIndicator)new NullProgressIndicator()) : aiaSdk.getRunHandler().runApks((ImmutableList)artifactFiles.stream().filter(apkFileUnit -> DynamicAppUtils.isFeatureEnabled(this.myDisabledFeatures, apkFileUnit)).map(ApkFileUnit::getApkFile).collect(ImmutableList.toImmutableList()), url, AndroidDebugBridge.getSocketAddress(), device.getSerialNumber(), null, resultStream, (ProgressIndicator)new NullProgressIndicator());
            return status == StatusCode.SUCCESS;
        }
        catch (Exception e) {
            printer.stderr(e.toString());
            RunInstantAppTask.getLogger().error((Throwable)new RunInstantAppException(e));
            return false;
        }
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            RunInstantAppTask.$$$reportNull$$$0(7);
        }
        return ID;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(RunInstantAppTask.class);
        if (logger == null) {
            RunInstantAppTask.$$$reportNull$$$0(8);
        }
        return logger;
    }

    private static boolean isSingleZipFile(List<ApkFileUnit> artifactFiles) {
        return artifactFiles.size() == 1 && artifactFiles.get(0).getApkFile().getName().toLowerCase().endsWith(".zip");
    }

    @NotNull
    public Collection<ApkInfo> getPackages() {
        Collection<ApkInfo> collection = this.myPackages;
        if (collection == null) {
            RunInstantAppTask.$$$reportNull$$$0(9);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledFeatures";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/RunInstantAppTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/RunInstantAppTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NullProgressIndicator
    implements ProgressIndicator {
        private NullProgressIndicator() {
        }

        public void setProgress(double v) {
        }
    }

    public static class RunInstantAppException
    extends Exception {
        private RunInstantAppException(@NotNull String message) {
            if (message == null) {
                RunInstantAppException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private RunInstantAppException(@NotNull Throwable t) {
            if (t == null) {
                RunInstantAppException.$$$reportNull$$$0(1);
            }
            super(t);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "t";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/run/tasks/RunInstantAppTask$RunInstantAppException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

