/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.profiler;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CpuProfilerConfigsState", storages={@Storage(value="cpuProfilingConfigs.xml")})
public class CpuProfilerConfigsState
implements PersistentStateComponent<CpuProfilerConfigsState> {
    @NotNull
    private List<CpuProfilerConfig> myUserConfigs = new ArrayList<CpuProfilerConfig>();

    @NotNull
    public static CpuProfilerConfigsState getInstance(Project project) {
        CpuProfilerConfigsState cpuProfilerConfigsState = (CpuProfilerConfigsState)ServiceManager.getService((Project)project, CpuProfilerConfigsState.class);
        if (cpuProfilerConfigsState == null) {
            CpuProfilerConfigsState.$$$reportNull$$$0(0);
        }
        return cpuProfilerConfigsState;
    }

    @NotNull
    public List<CpuProfilerConfig> getUserConfigs() {
        List<CpuProfilerConfig> list = this.myUserConfigs;
        if (list == null) {
            CpuProfilerConfigsState.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setUserConfigs(@NotNull List<CpuProfilerConfig> configs) {
        if (configs == null) {
            CpuProfilerConfigsState.$$$reportNull$$$0(2);
        }
        this.myUserConfigs = configs;
    }

    public boolean addUserConfig(@NotNull CpuProfilerConfig config) {
        if (config == null) {
            CpuProfilerConfigsState.$$$reportNull$$$0(3);
        }
        if (this.getConfigByName(config.getName()) == null) {
            this.myUserConfigs.add(config);
            return true;
        }
        return false;
    }

    @NotNull
    public static List<CpuProfilerConfig> getDefaultConfigs() {
        ImmutableList.Builder configs = new ImmutableList.Builder().add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.SAMPLED_JAVA)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.INSTRUMENTED_JAVA)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.SAMPLED_NATIVE));
        if (((Boolean)StudioFlags.PROFILER_USE_ATRACE.get()).booleanValue()) {
            CpuProfilerConfig atraceConfig = new CpuProfilerConfig(CpuProfilerConfig.Technology.ATRACE);
            atraceConfig.setBufferSizeMb(32);
            configs.add((Object)atraceConfig);
        }
        ImmutableList immutableList = configs.build();
        if (immutableList == null) {
            CpuProfilerConfigsState.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @NotNull
    public List<CpuProfilerConfig> getConfigs() {
        ImmutableList immutableList = ImmutableList.builder().addAll(CpuProfilerConfigsState.getDefaultConfigs()).addAll(this.getUserConfigs()).build();
        if (immutableList == null) {
            CpuProfilerConfigsState.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    @Nullable
    public CpuProfilerConfig getConfigByName(@NotNull String name) {
        if (name == null) {
            CpuProfilerConfigsState.$$$reportNull$$$0(6);
        }
        return this.getConfigs().stream().filter(c -> name.equals(c.getName())).findFirst().orElse(null);
    }

    @Nullable
    public CpuProfilerConfigsState getState() {
        return this;
    }

    public void loadState(CpuProfilerConfigsState state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/profiler/CpuProfilerConfigsState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserConfigs";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/profiler/CpuProfilerConfigsState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setUserConfigs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addUserConfig";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfigByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

