/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DeployTargetContext
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(DeployTargetContext.class);
    public String TARGET_SELECTION_MODE;
    private final Supplier<Boolean> mySelectDeviceSnapshotComboBoxVisible;
    private final List<DeployTargetProvider> myDeployTargetProviders;
    private final Map<String, DeployTargetState> myDeployTargetStates;

    public DeployTargetContext() {
        this(() -> (Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_VISIBLE.get());
    }

    DeployTargetContext(@NotNull Supplier<Boolean> selectDeviceSnapshotComboBoxVisible) {
        if (selectDeviceSnapshotComboBoxVisible == null) {
            DeployTargetContext.$$$reportNull$$$0(0);
        }
        this.TARGET_SELECTION_MODE = TargetSelectionMode.SHOW_DIALOG.name();
        this.mySelectDeviceSnapshotComboBoxVisible = selectDeviceSnapshotComboBoxVisible;
        this.myDeployTargetProviders = DeployTargetProvider.getProviders();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeployTargetProvider provider : this.myDeployTargetProviders) {
            builder.put((Object)provider.getId(), provider.createState());
        }
        this.myDeployTargetStates = builder.build();
    }

    @NotNull
    public List<DeployTargetProvider> getDeployTargetProviders() {
        List<DeployTargetProvider> list = this.myDeployTargetProviders;
        if (list == null) {
            DeployTargetContext.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public DeployTargetProvider getCurrentDeployTargetProvider() {
        if (this.mySelectDeviceSnapshotComboBoxVisible.get().booleanValue()) {
            DeployTargetProvider deployTargetProvider = this.getDeployTargetProvider(TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX);
            if (deployTargetProvider == null) {
                DeployTargetContext.$$$reportNull$$$0(2);
            }
            return deployTargetProvider;
        }
        if (this.TARGET_SELECTION_MODE.equals(TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX.name())) {
            DeployTargetProvider deployTargetProvider = this.getDeployTargetProvider(TargetSelectionMode.SHOW_DIALOG);
            if (deployTargetProvider == null) {
                DeployTargetContext.$$$reportNull$$$0(3);
            }
            return deployTargetProvider;
        }
        Optional<DeployTargetProvider> provider = DeployTargetContext.getDeployTargetProvider(this.myDeployTargetProviders, this.TARGET_SELECTION_MODE);
        DeployTargetProvider deployTargetProvider = provider.orElse(this.getDeployTargetProvider(TargetSelectionMode.SHOW_DIALOG));
        if (deployTargetProvider == null) {
            DeployTargetContext.$$$reportNull$$$0(4);
        }
        return deployTargetProvider;
    }

    @NotNull
    private DeployTargetProvider getDeployTargetProvider(@NotNull TargetSelectionMode mode) {
        if (mode == null) {
            DeployTargetContext.$$$reportNull$$$0(5);
        }
        DeployTargetProvider deployTargetProvider = DeployTargetContext.getDeployTargetProvider(this.myDeployTargetProviders, mode.name()).orElseThrow(AssertionError::new);
        if (deployTargetProvider == null) {
            DeployTargetContext.$$$reportNull$$$0(6);
        }
        return deployTargetProvider;
    }

    @NotNull
    static Optional<DeployTargetProvider> getDeployTargetProvider(@NotNull Collection<DeployTargetProvider> providers, @NotNull String id) {
        if (providers == null) {
            DeployTargetContext.$$$reportNull$$$0(7);
        }
        if (id == null) {
            DeployTargetContext.$$$reportNull$$$0(8);
        }
        Optional<DeployTargetProvider> optional = providers.stream().filter(provider -> provider.getId().equals(id)).findFirst();
        if (optional == null) {
            DeployTargetContext.$$$reportNull$$$0(9);
        }
        return optional;
    }

    @NotNull
    public Map<String, DeployTargetState> getDeployTargetStates() {
        Map<String, DeployTargetState> map2 = this.myDeployTargetStates;
        if (map2 == null) {
            DeployTargetContext.$$$reportNull$$$0(10);
        }
        return map2;
    }

    @NotNull
    public DeployTargetState getCurrentDeployTargetState() {
        DeployTargetProvider currentTarget = this.getCurrentDeployTargetProvider();
        DeployTargetState deployTargetState = this.myDeployTargetStates.get(currentTarget.getId());
        if (deployTargetState == null) {
            DeployTargetContext.$$$reportNull$$$0(11);
        }
        return deployTargetState;
    }

    @NotNull
    public DeployTargetState getDeployTargetState(@NotNull DeployTargetProvider target) {
        if (target == null) {
            DeployTargetContext.$$$reportNull$$$0(12);
        }
        DeployTargetState deployTargetState = this.myDeployTargetStates.get(target.getId());
        if (deployTargetState == null) {
            DeployTargetContext.$$$reportNull$$$0(13);
        }
        return deployTargetState;
    }

    public void setTargetSelectionMode(@NotNull TargetSelectionMode mode) {
        if (mode == null) {
            DeployTargetContext.$$$reportNull$$$0(14);
        }
        this.TARGET_SELECTION_MODE = mode.name();
    }

    public void setTargetSelectionMode(@NotNull DeployTargetProvider target) {
        if (target == null) {
            DeployTargetContext.$$$reportNull$$$0(15);
        }
        this.TARGET_SELECTION_MODE = target.getId();
    }

    @NotNull
    public TargetSelectionMode getTargetSelectionMode() {
        TargetSelectionMode targetSelectionMode;
        try {
            targetSelectionMode = TargetSelectionMode.valueOf(this.TARGET_SELECTION_MODE);
        }
        catch (IllegalArgumentException e) {
            LOG.info((Throwable)e);
            TargetSelectionMode targetSelectionMode2 = TargetSelectionMode.EMULATOR;
            if (targetSelectionMode2 == null) {
                DeployTargetContext.$$$reportNull$$$0(17);
            }
            return targetSelectionMode2;
        }
        if (targetSelectionMode == null) {
            DeployTargetContext.$$$reportNull$$$0(16);
        }
        return targetSelectionMode;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.readExternal((Object)state, (Element)element);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.writeExternal((Object)state, (Element)element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectDeviceSnapshotComboBoxVisible";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/editor/DeployTargetContext";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/editor/DeployTargetContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTargetProviders";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDeployTargetProvider";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTargetProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTargetStates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDeployTargetState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTargetState";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSelectionMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDeployTargetProvider";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDeployTargetState";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setTargetSelectionMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

