/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.AndroidAppRunConfigurationBase;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.ConfigurationSpecificEditor;
import com.android.tools.idea.run.editor.DeepLinkLaunch;
import com.android.tools.idea.run.editor.DefaultActivityLaunch;
import com.android.tools.idea.run.editor.DynamicFeaturesParameters;
import com.android.tools.idea.run.editor.InstallOption;
import com.android.tools.idea.run.editor.LaunchConfigurableWrapper;
import com.android.tools.idea.run.editor.LaunchOption;
import com.android.tools.idea.run.editor.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.editor.LaunchOptionState;
import com.android.tools.idea.run.editor.NoLaunch;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.annotations.NotNull;

public class ApplicationRunParameters<T extends AndroidAppRunConfigurationBase>
implements ConfigurationSpecificEditor<T>,
ActionListener {
    private JPanel myPanel;
    private ComboBox myDeployOptionCombo;
    private LabeledComponent<ComboBox> myCustomArtifactLabeledComponent;
    private final ComboBox myArtifactCombo;
    private LabeledComponent<JBTextField> myPmOptionsLabeledComponent;
    private ComboBox myLaunchOptionCombo;
    private ConfigurableCardPanel myLaunchOptionsCardPanel;
    private LabeledComponent<JBTextField> myAmOptionsLabeledComponent;
    private JComponent myDynamicFeaturesParametersComponent;
    private JBCheckBox myInstantAppDeployCheckBox;
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private Artifact myLastSelectedArtifact;
    private final ImmutableMap<String, LaunchConfigurableWrapper> myConfigurables;
    private DynamicFeaturesParameters myDynamicFeaturesParameters;

    public ApplicationRunParameters(Project project, ConfigurationModuleSelector moduleSelector) {
        this.myProject = project;
        this.myModuleSelector = moduleSelector;
        this.$$$setupUI$$$();
        this.myDeployOptionCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(InstallOption.values())));
        this.myDeployOptionCombo.setRenderer((ListCellRenderer)((Object)new InstallOption.Renderer()));
        this.myDeployOptionCombo.addActionListener((ActionListener)this);
        this.myDeployOptionCombo.setSelectedItem((Object)InstallOption.DEFAULT_APK);
        this.myArtifactCombo = (ComboBox)this.myCustomArtifactLabeledComponent.getComponent();
        this.myArtifactCombo.setRenderer((ListCellRenderer)((Object)new ArtifactRenderer()));
        this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(this.getAndroidArtifacts().toArray()));
        this.myArtifactCombo.addActionListener((ActionListener)this);
        ((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).getEmptyText().setText("Options to 'pm install' command");
        this.myLaunchOptionCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(AndroidRunConfiguration.LAUNCH_OPTIONS));
        this.myLaunchOptionCombo.setRenderer((ListCellRenderer)((Object)new LaunchOption.Renderer()));
        this.myLaunchOptionCombo.addActionListener((ActionListener)this);
        ((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).getEmptyText().setText("Options to 'am start' command");
        this.myInstantAppDeployCheckBox.addActionListener((ActionListener)this);
        LaunchOptionConfigurableContext context = new LaunchOptionConfigurableContext(){

            @Override
            public Module getModule() {
                return ApplicationRunParameters.this.myModuleSelector.getModule();
            }
        };
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (LaunchOption option : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            builder.put((Object)option.getId(), (Object)new LaunchConfigurableWrapper(project, context, option));
        }
        this.myConfigurables = builder.build();
        this.myLaunchOptionCombo.setSelectedItem((Object)DefaultActivityLaunch.INSTANCE);
        this.myInstantAppDeployCheckBox.setVisible(((Boolean)StudioFlags.UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS.get()).booleanValue());
    }

    private void createUIComponents() {
        this.myDynamicFeaturesParameters = new DynamicFeaturesParameters();
        this.myDynamicFeaturesParametersComponent = this.myDynamicFeaturesParameters.getComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.myDeployOptionCombo) {
            InstallOption option = (InstallOption)((Object)this.myDeployOptionCombo.getSelectedItem());
            this.myCustomArtifactLabeledComponent.setVisible(option == InstallOption.CUSTOM_ARTIFACT);
            this.myPmOptionsLabeledComponent.setVisible(option != InstallOption.NOTHING);
            if (option == InstallOption.CUSTOM_ARTIFACT) {
                this.updateBuildArtifactBeforeRunSetting();
            }
        } else if (source == this.myArtifactCombo) {
            this.updateBuildArtifactBeforeRunSetting();
        } else if (source == this.myLaunchOptionCombo) {
            LaunchOption option = (LaunchOption)this.myLaunchOptionCombo.getSelectedItem();
            this.myAmOptionsLabeledComponent.setVisible(option != NoLaunch.INSTANCE);
            this.myLaunchOptionsCardPanel.select(this.myConfigurables.get((Object)option.getId()), true);
        } else if (source == this.myInstantAppDeployCheckBox && this.myModuleSelector.getModule() != null) {
            this.myDynamicFeaturesParameters.updateBasedOnInstantState(this.myModuleSelector.getModule(), this.myInstantAppDeployCheckBox.isSelected());
        }
    }

    public Module getModule() {
        return this.myModuleSelector.getModule();
    }

    @NotNull
    private static InstallOption getDeployOption(boolean deploy, boolean deployFromBundle, String artifactName) {
        Preconditions.checkArgument((!deployFromBundle || deploy ? 1 : 0) != 0);
        if (deploy) {
            if (deployFromBundle) {
                InstallOption installOption = StringUtil.isEmpty((String)artifactName) ? InstallOption.APK_FROM_BUNDLE : InstallOption.CUSTOM_ARTIFACT;
                if (installOption == null) {
                    ApplicationRunParameters.$$$reportNull$$$0(0);
                }
                return installOption;
            }
            InstallOption installOption = StringUtil.isEmpty((String)artifactName) ? InstallOption.DEFAULT_APK : InstallOption.CUSTOM_ARTIFACT;
            if (installOption == null) {
                ApplicationRunParameters.$$$reportNull$$$0(1);
            }
            return installOption;
        }
        InstallOption installOption = InstallOption.NOTHING;
        if (installOption == null) {
            ApplicationRunParameters.$$$reportNull$$$0(2);
        }
        return installOption;
    }

    @Override
    public void resetFrom(@NotNull AndroidAppRunConfigurationBase configuration) {
        if (configuration == null) {
            ApplicationRunParameters.$$$reportNull$$$0(3);
        }
        InstallOption installOption = ApplicationRunParameters.getDeployOption(configuration.DEPLOY, configuration.DEPLOY_APK_FROM_BUNDLE, configuration.ARTIFACT_NAME);
        this.myDeployOptionCombo.setSelectedItem((Object)installOption);
        this.myInstantAppDeployCheckBox.setSelected(this.myInstantAppDeployCheckBox.isEnabled() && configuration.DEPLOY_AS_INSTANT);
        Module currentModule = this.myModuleSelector.getModule();
        if (currentModule != null) {
            this.myDynamicFeaturesParameters.updateBasedOnInstantState(currentModule, this.myInstantAppDeployCheckBox.isSelected());
        }
        if (installOption == InstallOption.CUSTOM_ARTIFACT) {
            String artifactName = StringUtil.notNullize((String)configuration.ARTIFACT_NAME);
            ArrayList artifacts = Lists.newArrayList(this.getAndroidArtifacts());
            Artifact selectedArtifact = ApplicationRunParameters.findArtifactByName(artifacts, artifactName);
            if (selectedArtifact != null) {
                this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(artifacts.toArray()));
                this.myArtifactCombo.setSelectedItem((Object)selectedArtifact);
            } else {
                ArrayList items2 = Lists.newArrayList((Object[])artifacts.toArray());
                items2.add(artifactName);
                this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(items2.toArray()));
                this.myArtifactCombo.setSelectedItem((Object)artifactName);
            }
        }
        ((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).setText(configuration.PM_INSTALL_OPTIONS);
        for (LaunchOption option : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            LaunchOptionState state = configuration.getLaunchOptionState(option.getId());
            assert (state != null) : "State is null for option: " + option.getDisplayName();
            ((LaunchConfigurableWrapper)this.myConfigurables.get((Object)option.getId())).resetFrom(state);
        }
        LaunchOption launchOption = ApplicationRunParameters.getLaunchOption(configuration.MODE);
        this.myLaunchOptionCombo.setSelectedItem((Object)launchOption);
        ((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).setText(configuration.ACTIVITY_EXTRA_FLAGS);
        this.myDynamicFeaturesParameters.setDisabledDynamicFeatures(configuration.getDisabledDynamicFeatures());
    }

    @NotNull
    private static LaunchOption getLaunchOption(String mode) {
        if (StringUtil.isEmpty((String)mode)) {
            mode = DefaultActivityLaunch.INSTANCE.getId();
        }
        for (LaunchOption option : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            if (!option.getId().equals(mode)) continue;
            LaunchOption launchOption = option;
            if (launchOption == null) {
                ApplicationRunParameters.$$$reportNull$$$0(4);
            }
            return launchOption;
        }
        throw new IllegalStateException("Unexpected error determining launch mode");
    }

    @Override
    public void applyTo(@NotNull AndroidAppRunConfigurationBase configuration) {
        Iterator item;
        InstallOption installOption;
        if (configuration == null) {
            ApplicationRunParameters.$$$reportNull$$$0(5);
        }
        configuration.DEPLOY = (installOption = (InstallOption)((Object)this.myDeployOptionCombo.getSelectedItem())) != InstallOption.NOTHING;
        configuration.DEPLOY_APK_FROM_BUNDLE = installOption == InstallOption.APK_FROM_BUNDLE;
        configuration.DEPLOY_AS_INSTANT = this.myInstantAppDeployCheckBox.isSelected();
        configuration.ARTIFACT_NAME = "";
        if (installOption == InstallOption.CUSTOM_ARTIFACT && (item = ((ComboBox)this.myCustomArtifactLabeledComponent.getComponent()).getSelectedItem()) instanceof Artifact) {
            configuration.ARTIFACT_NAME = ((Artifact)item).getName();
        }
        configuration.PM_INSTALL_OPTIONS = StringUtil.notNullize((String)((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).getText());
        for (LaunchOption option : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            LaunchOptionState state = configuration.getLaunchOptionState(option.getId());
            assert (state != null) : "State is null for option: " + option.getDisplayName();
            ((LaunchConfigurableWrapper)this.myConfigurables.get((Object)option.getId())).applyTo(state);
        }
        LaunchOption launchOption = (LaunchOption)this.myLaunchOptionCombo.getSelectedItem();
        configuration.MODE = launchOption.getId();
        configuration.ACTIVITY_EXTRA_FLAGS = StringUtil.notNullize((String)((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).getText());
        configuration.setDisabledDynamicFeatures(this.myDynamicFeaturesParameters.getDisabledDynamicFeatures());
    }

    @Override
    public Component getComponent() {
        return this.myPanel;
    }

    public JComponent getAnchor() {
        return null;
    }

    public void setAnchor(JComponent anchor) {
    }

    private void updateBuildArtifactBeforeRunSetting() {
        Artifact newArtifact = null;
        Object item = this.myArtifactCombo.getSelectedItem();
        if (item instanceof Artifact) {
            newArtifact = (Artifact)item;
        }
        if (Comparing.equal((Object)newArtifact, (Object)this.myLastSelectedArtifact)) {
            return;
        }
        if (this.myLastSelectedArtifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myPanel, (Project)this.myProject, (Artifact)this.myLastSelectedArtifact, (boolean)false);
        }
        if (newArtifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myPanel, (Project)this.myProject, (Artifact)newArtifact, (boolean)true);
        }
        if (this.myLastSelectedArtifact == null || newArtifact == null) {
            this.addOrRemoveMakeTask(newArtifact == null);
        }
        this.myLastSelectedArtifact = newArtifact;
    }

    private void addOrRemoveMakeTask(boolean add2) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myPanel);
        ConfigurationSettingsEditorWrapper editor2 = (ConfigurationSettingsEditorWrapper)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext);
        if (editor2 == null) {
            return;
        }
        SmartList makeTasks = new SmartList();
        for (BeforeRunTask task : editor2.getStepsBeforeLaunch()) {
            if (!(task instanceof CompileStepBeforeRun.MakeBeforeRunTask) && !(task instanceof CompileStepBeforeRunNoErrorCheck.MakeBeforeRunTaskNoErrorCheck)) continue;
            makeTasks.add(task);
        }
        if (add2) {
            if (makeTasks.isEmpty()) {
                editor2.addBeforeLaunchStep((BeforeRunTask)new CompileStepBeforeRun.MakeBeforeRunTask());
            } else {
                for (BeforeRunTask task : makeTasks) {
                    task.setEnabled(true);
                }
            }
        } else {
            for (BeforeRunTask task : makeTasks) {
                task.setEnabled(false);
            }
        }
    }

    @NotNull
    private Collection<? extends Artifact> getAndroidArtifacts() {
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        Collection<Object> collection = artifactManager == null ? Collections.emptyList() : artifactManager.getArtifactsByType(AndroidApplicationArtifactType.getInstance());
        if (collection == null) {
            ApplicationRunParameters.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static Artifact findArtifactByName(@NotNull List<Artifact> artifacts, @NotNull String artifactName) {
        if (artifacts == null) {
            ApplicationRunParameters.$$$reportNull$$$0(7);
        }
        if (artifactName == null) {
            ApplicationRunParameters.$$$reportNull$$$0(8);
        }
        for (Artifact artifact : artifacts) {
            if (!artifactName.equals(artifact.getName())) continue;
            return artifact;
        }
        return null;
    }

    public void onModuleChanged() {
        boolean isInstantApp;
        Module currentModule = this.myModuleSelector.getModule();
        if (currentModule == null) {
            return;
        }
        AndroidModuleModel model = AndroidModuleModel.get(currentModule);
        boolean bl = isInstantApp = model != null && model.getAndroidProject().getProjectType() == 4;
        if (isInstantApp) {
            this.myLaunchOptionCombo.setSelectedItem((Object)DeepLinkLaunch.INSTANCE);
            this.myDeployOptionCombo.setSelectedItem((Object)InstallOption.DEFAULT_APK);
        } else {
            this.myInstantAppDeployCheckBox.setEnabled(model != null && model.getSelectedVariant().isInstantAppCompatible());
            this.myLaunchOptionCombo.setSelectedItem((Object)DefaultActivityLaunch.INSTANCE);
        }
        this.myDeployOptionCombo.setEnabled(!isInstantApp);
        this.myCustomArtifactLabeledComponent.setEnabled(!isInstantApp);
        this.myLaunchOptionCombo.setEnabled(!isInstantApp);
        this.myDynamicFeaturesParameters.setActiveModule(currentModule, model != null && model.getSelectedVariant().isInstantAppCompatible() && (Boolean)StudioFlags.UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS.get() != false ? DynamicFeaturesParameters.AvailableDeployTypes.INSTANT_AND_INSTALLED : DynamicFeaturesParameters.AvailableDeployTypes.INSTALLED_ONLY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/editor/ApplicationRunParameters";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployOption";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/editor/ApplicationRunParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchOption";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findArtifactByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        LabeledComponent labeledComponent;
        ConfigurableCardPanel configurableCardPanel;
        ComboBox comboBox;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        ComboBox comboBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Installation Options");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 4, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Deploy:");
        jBLabel.setDisplayedMnemonic('D');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myDeployOptionCombo = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, new Dimension(100, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCustomArtifactLabeledComponent = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.ComboBox");
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText("&Artifact");
        jPanel.add((Component)labeledComponent3, new GridConstraints(2, 0, 1, 4, 0, 1, 3, 3, null, null, null, 2));
        JComponent jComponent = this.myDynamicFeaturesParametersComponent;
        jPanel.add((Component)jComponent, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2));
        this.myPmOptionsLabeledComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.ui.components.JBTextField");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText("&Install Flags");
        jPanel.add((Component)labeledComponent2, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Launch Options");
        jPanel.add((Component)titledSeparator2, new GridConstraints(5, 0, 1, 4, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Launch:");
        jBLabel2.setDisplayedMnemonic('L');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myLaunchOptionCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(6, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLaunchOptionsCardPanel = configurableCardPanel = new ConfigurableCardPanel();
        jPanel.add((Component)configurableCardPanel, new GridConstraints(7, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2));
        this.myAmOptionsLabeledComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.ui.components.JBTextField");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Launch &Flags");
        jPanel.add((Component)labeledComponent, new GridConstraints(8, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myInstantAppDeployCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Deploy as instant app");
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class ArtifactRenderer
    extends ListCellRendererWrapper {
        private ArtifactRenderer() {
        }

        public void customize(JList list, Object value2, int index, boolean selected, boolean hasFocus) {
            if (value2 instanceof Artifact) {
                Artifact artifact = (Artifact)value2;
                this.setText(artifact.getName());
                this.setIcon(artifact.getArtifactType().getIcon());
            } else if (value2 instanceof String) {
                this.setText("<html><font color='red'>" + value2 + "</font></html>");
            }
        }
    }
}

