/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.PhysicalDevice;
import com.android.tools.idea.run.deployment.SelectDeviceAndSnapshotAction;
import com.android.tools.idea.run.deployment.SnapshotActionGroup;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.google.common.collect.ImmutableCollection;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.popup.PopupFactoryImpl;
import icons.StudioIcons;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.android.actions.RunAndroidAvdManagerAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DeviceAndSnapshotComboBoxAction
extends ComboBoxAction {
    private final Supplier<Boolean> mySelectDeviceSnapshotComboBoxVisible;
    private final AsyncDevicesGetter myDevicesGetter;
    private final AnAction myOpenAvdManagerAction;
    private List<Device> myDevices;
    private Device mySelectedDevice;
    private String mySelectedSnapshot;

    private DeviceAndSnapshotComboBoxAction() {
        this(() -> (Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_VISIBLE.get(), new AsyncDevicesGetter((Disposable)ApplicationManager.getApplication()));
    }

    DeviceAndSnapshotComboBoxAction(@NotNull Supplier<Boolean> selectDeviceSnapshotComboBoxVisible, @NotNull AsyncDevicesGetter devicesGetter) {
        if (selectDeviceSnapshotComboBoxVisible == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(0);
        }
        if (devicesGetter == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(1);
        }
        this.mySelectDeviceSnapshotComboBoxVisible = selectDeviceSnapshotComboBoxVisible;
        this.myDevicesGetter = devicesGetter;
        this.myOpenAvdManagerAction = new RunAndroidAvdManagerAction();
        Presentation presentation = this.myOpenAvdManagerAction.getTemplatePresentation();
        presentation.setIcon(StudioIcons.Shell.Toolbar.DEVICE_MANAGER);
        presentation.setText("Open AVD Manager");
        this.myDevices = Collections.emptyList();
    }

    @NotNull
    AnAction getOpenAvdManagerAction() {
        AnAction anAction = this.myOpenAvdManagerAction;
        if (anAction == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(2);
        }
        return anAction;
    }

    @NotNull
    List<Device> getDevices() {
        List<Device> list = this.myDevices;
        if (list == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    Device getSelectedDevice() {
        return this.mySelectedDevice;
    }

    void setSelectedDevice(@Nullable Device selectedDevice) {
        this.mySelectedDevice = selectedDevice;
    }

    @Nullable
    String getSelectedSnapshot() {
        return this.mySelectedSnapshot;
    }

    void setSelectedSnapshot(@Nullable String selectedSnapshot) {
        this.mySelectedSnapshot = selectedSnapshot;
    }

    @NotNull
    protected ComboBoxAction.ComboBoxButton createComboBoxButton(@NotNull Presentation presentation) {
        if (presentation == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(4);
        }
        ComboBoxAction.ComboBoxButton comboBoxButton = new ComboBoxAction.ComboBoxButton(presentation){

            protected JBPopup createPopup(@NotNull Runnable runnable) {
                if (runnable == null) {
                    1.$$$reportNull$$$0(0);
                }
                DataContext context = this.getDataContext();
                DefaultActionGroup group = DeviceAndSnapshotComboBoxAction.this.createPopupActionGroup((JComponent)((Object)this), context);
                boolean show = DeviceAndSnapshotComboBoxAction.this.shouldShowDisabledActions();
                int count = DeviceAndSnapshotComboBoxAction.this.getMaxRows();
                Condition condition = DeviceAndSnapshotComboBoxAction.this.getPreselectCondition();
                PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, (ActionGroup)group, context, false, true, show, false, runnable, count, condition, null, true);
                popup2.setMinimumSize(new Dimension(DeviceAndSnapshotComboBoxAction.this.getMinWidth(), DeviceAndSnapshotComboBoxAction.this.getMinHeight()));
                return popup2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/run/deployment/DeviceAndSnapshotComboBoxAction$1", "createPopup"));
            }
        };
        if (comboBoxButton == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(5);
        }
        return comboBoxButton;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button) {
        if (button == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(6);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        Collection<AnAction> actions2 = this.newSelectDeviceAndSnapshotActions();
        group.addAll(actions2);
        if (!actions2.isEmpty()) {
            group.addSeparator();
        }
        group.add(this.myOpenAvdManagerAction);
        AnAction action2 = DeviceAndSnapshotComboBoxAction.getTroubleshootDeviceConnectionsAction();
        if (action2 == null) {
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(7);
            }
            return defaultActionGroup;
        }
        group.addSeparator();
        group.add(action2);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(8);
        }
        return defaultActionGroup;
    }

    @NotNull
    private Collection<AnAction> newSelectDeviceAndSnapshotActions() {
        ArrayList virtualDevices = new ArrayList(this.myDevices.size());
        ArrayList physicalDevices = new ArrayList(this.myDevices.size());
        this.myDevices.forEach(device -> {
            if (device instanceof VirtualDevice) {
                virtualDevices.add((VirtualDevice)device);
            } else if (device instanceof PhysicalDevice) {
                physicalDevices.add(device);
            } else assert (false);
        });
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(virtualDevices.size() + 1 + physicalDevices.size());
        virtualDevices.stream().map(this::newSelectDeviceAndSnapshotAction).forEach(actions2::add);
        if (!virtualDevices.isEmpty() && !physicalDevices.isEmpty()) {
            actions2.add((AnAction)Separator.create());
        }
        physicalDevices.stream().map(device -> new SelectDeviceAndSnapshotAction(this, (Device)device)).forEach(actions2::add);
        ArrayList<AnAction> arrayList = actions2;
        if (arrayList == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private AnAction newSelectDeviceAndSnapshotAction(@NotNull VirtualDevice device) {
        ImmutableCollection<String> snapshots;
        if (device == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(10);
        }
        if ((snapshots = device.getSnapshots()).isEmpty() || snapshots.equals(VirtualDevice.DEFAULT_SNAPSHOT_COLLECTION)) {
            SelectDeviceAndSnapshotAction selectDeviceAndSnapshotAction = new SelectDeviceAndSnapshotAction(this, device);
            if (selectDeviceAndSnapshotAction == null) {
                DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(11);
            }
            return selectDeviceAndSnapshotAction;
        }
        SnapshotActionGroup snapshotActionGroup = new SnapshotActionGroup(device, this);
        if (snapshotActionGroup == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(12);
        }
        return snapshotActionGroup;
    }

    @Nullable
    private static AnAction getTroubleshootDeviceConnectionsAction() {
        AnAction action2 = ActionManager.getInstance().getAction("DeveloperServices.ConnectionAssistant");
        if (action2 == null) {
            return null;
        }
        Presentation presentation = action2.getTemplatePresentation();
        presentation.setIcon(null);
        presentation.setText("Troubleshoot device connections");
        return action2;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(13);
        }
        Presentation presentation = event.getPresentation();
        if (!this.mySelectDeviceSnapshotComboBoxVisible.get().booleanValue()) {
            presentation.setVisible(false);
            return;
        }
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        presentation.setVisible(true);
        this.myDevices = this.myDevicesGetter.get(project);
        if (this.myDevices.isEmpty()) {
            this.mySelectedDevice = null;
            this.mySelectedSnapshot = null;
            presentation.setIcon(null);
            presentation.setText("No devices");
            return;
        }
        this.updateSelectedDevice();
        this.updateSelectedSnapshot();
        presentation.setIcon(this.mySelectedDevice.getIcon());
        presentation.setText(this.mySelectedSnapshot == null ? this.mySelectedDevice.getName() : this.mySelectedDevice + " - " + this.mySelectedSnapshot);
    }

    private void updateSelectedDevice() {
        if (this.mySelectedDevice == null) {
            this.mySelectedDevice = this.myDevices.get(0);
            return;
        }
        String selectedDeviceName = this.mySelectedDevice.getName();
        Optional<Device> selectedDevice = this.myDevices.stream().filter(device -> device.getName().equals(selectedDeviceName)).findFirst();
        this.mySelectedDevice = selectedDevice.orElseGet(() -> this.myDevices.get(0));
    }

    private void updateSelectedSnapshot() {
        ImmutableCollection<String> snapshots = this.mySelectedDevice.getSnapshots();
        if (this.mySelectedSnapshot == null) {
            Optional selectedDeviceSnapshot = snapshots.stream().findFirst();
            selectedDeviceSnapshot.ifPresent(snapshot -> {
                this.mySelectedSnapshot = snapshot;
            });
            return;
        }
        if (snapshots.contains(this.mySelectedSnapshot)) {
            return;
        }
        Optional selectedSnapshot = snapshots.stream().findFirst();
        this.mySelectedSnapshot = selectedSnapshot.orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectDeviceSnapshotComboBoxVisible";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devicesGetter";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/DeviceAndSnapshotComboBoxAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/DeviceAndSnapshotComboBoxAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenAvdManagerAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createComboBoxButton";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newSelectDeviceAndSnapshotActions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newSelectDeviceAndSnapshotAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createComboBoxButton";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newSelectDeviceAndSnapshotAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

