/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.idea.stats.RunStats;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchTaskRunner
extends Task.Backgroundable {
    @NotNull
    private final String myConfigName;
    @NotNull
    private final LaunchInfo myLaunchInfo;
    @NotNull
    private final ProcessHandler myProcessHandler;
    @NotNull
    private final DeviceFutures myDeviceFutures;
    @NotNull
    private final LaunchTasksProvider myLaunchTasksProvider;
    @NotNull
    private final RunStats myStats;
    @Nullable
    private String myError;

    public LaunchTaskRunner(@NotNull Project project, @NotNull String configName, @NotNull LaunchInfo launchInfo, @NotNull ProcessHandler processHandler, @NotNull DeviceFutures deviceFutures, @NotNull LaunchTasksProvider launchTasksProvider, @NotNull RunStats stats) {
        if (project == null) {
            LaunchTaskRunner.$$$reportNull$$$0(0);
        }
        if (configName == null) {
            LaunchTaskRunner.$$$reportNull$$$0(1);
        }
        if (launchInfo == null) {
            LaunchTaskRunner.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            LaunchTaskRunner.$$$reportNull$$$0(3);
        }
        if (deviceFutures == null) {
            LaunchTaskRunner.$$$reportNull$$$0(4);
        }
        if (launchTasksProvider == null) {
            LaunchTaskRunner.$$$reportNull$$$0(5);
        }
        if (stats == null) {
            LaunchTaskRunner.$$$reportNull$$$0(6);
        }
        super(project, "Launching " + configName);
        this.myConfigName = configName;
        this.myLaunchInfo = launchInfo;
        this.myProcessHandler = processHandler;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchTasksProvider = launchTasksProvider;
        this.myStats = stats;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            LaunchTaskRunner.$$$reportNull$$$0(7);
        }
        indicator.setText(this.getTitle());
        indicator.setIndeterminate(false);
        this.myStats.beginLaunchTasks();
        ProcessHandlerLaunchStatus launchStatus = new ProcessHandlerLaunchStatus(this.myProcessHandler);
        ProcessHandlerConsolePrinter consolePrinter = new ProcessHandlerConsolePrinter(this.myProcessHandler);
        List<ListenableFuture<IDevice>> listenableDeviceFutures = this.myDeviceFutures.get();
        AndroidVersion androidVersion = this.myDeviceFutures.getDevices().size() == 1 ? this.myDeviceFutures.getDevices().get(0).getVersion() : null;
        DebugConnectorTask debugSessionTask = this.myLaunchTasksProvider.getConnectDebuggerTask(launchStatus, androidVersion);
        if (debugSessionTask != null && listenableDeviceFutures.size() != 1) {
            launchStatus.terminateLaunch("Cannot launch a debug session on more than 1 device.");
        }
        if (debugSessionTask != null) {
            AndroidProcessText.attach(this.myProcessHandler);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd HH:mm:ss");
        consolePrinter.stdout("\n" + dateFormat.format(new Date()) + ": Launching " + this.myConfigName);
        for (ListenableFuture<IDevice> deviceFuture : listenableDeviceFutures) {
            indicator.setText("Waiting for target device to come online");
            this.myStats.beginWaitForDevice();
            IDevice device = LaunchTaskRunner.waitForDevice(deviceFuture, indicator, launchStatus);
            this.myStats.endWaitForDevice(device);
            if (device == null) break;
            List<LaunchTask> launchTasks = null;
            try {
                launchTasks = this.myLaunchTasksProvider.getTasks(device, launchStatus, consolePrinter);
            }
            catch (com.intellij.execution.ExecutionException e) {
                launchStatus.terminateLaunch(e.getMessage());
                break;
            }
            catch (IllegalStateException e) {
                launchStatus.terminateLaunch(e.getMessage());
                Logger.getInstance(LaunchTaskRunner.class).error((Throwable)e);
                break;
            }
            int totalDuration = listenableDeviceFutures.size() * LaunchTaskRunner.getTotalDuration(launchTasks, debugSessionTask);
            int elapsed = 0;
            boolean success = true;
            for (LaunchTask task : launchTasks) {
                LaunchTaskDetail.Builder details = this.myStats.beginLaunchTask(task);
                indicator.setText(task.getDescription());
                success = task.perform(device, launchStatus, consolePrinter);
                this.myStats.endLaunchTask(details, success);
                if (!success) {
                    this.myError = "Error " + task.getDescription();
                    launchStatus.terminateLaunch("Error while " + task.getDescription());
                    break;
                }
                indicator.setFraction((double)(elapsed += task.getDuration()) / (double)totalDuration);
                if (indicator.isCanceled()) {
                    launchStatus.terminateLaunch("User cancelled launch");
                    success = false;
                    break;
                }
                if (!launchStatus.isLaunchTerminated()) continue;
                success = false;
                break;
            }
            if (!success) break;
            if (debugSessionTask != null) {
                debugSessionTask.perform(this.myLaunchInfo, device, launchStatus, consolePrinter);
                continue;
            }
            if (!this.myLaunchTasksProvider.createsNewProcess() || !(this.myProcessHandler instanceof AndroidProcessHandler)) continue;
            AndroidProcessHandler procHandler = (AndroidProcessHandler)this.myProcessHandler;
            procHandler.addTargetDevice(device);
        }
        this.myStats.endLaunchTasks();
    }

    public void onSuccess() {
        if (this.myError == null) {
            this.myStats.success();
        } else {
            this.myStats.fail();
            LaunchUtils.showNotification(this.myProject, this.myLaunchInfo.executor, this.myConfigName, this.myError, NotificationType.ERROR);
        }
    }

    @Nullable
    private static IDevice waitForDevice(@NotNull ListenableFuture<IDevice> deviceFuture, @NotNull ProgressIndicator indicator, @NotNull LaunchStatus launchStatus) {
        if (deviceFuture == null) {
            LaunchTaskRunner.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            LaunchTaskRunner.$$$reportNull$$$0(9);
        }
        if (launchStatus == null) {
            LaunchTaskRunner.$$$reportNull$$$0(10);
        }
        do {
            try {
                return (IDevice)deviceFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException e) {
                launchStatus.terminateLaunch("Interrupted while waiting for device");
                return null;
            }
            catch (ExecutionException e) {
                launchStatus.terminateLaunch("Error while waiting for device: " + e.getCause().getMessage());
                return null;
            }
            if (!indicator.isCanceled()) continue;
            launchStatus.terminateLaunch("User cancelled launch");
            return null;
        } while (!launchStatus.isLaunchTerminated());
        return null;
    }

    private static int getTotalDuration(@NotNull List<LaunchTask> launchTasks, @Nullable DebugConnectorTask debugSessionTask) {
        if (launchTasks == null) {
            LaunchTaskRunner.$$$reportNull$$$0(11);
        }
        int total = 0;
        for (LaunchTask task : launchTasks) {
            total += task.getDuration();
        }
        if (debugSessionTask != null) {
            total += debugSessionTask.getDuration();
        }
        return total;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFutures";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchTasksProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stats";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFuture";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchTasks";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/LaunchTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForDevice";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getTotalDuration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

