/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import icons.StudioIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyChangesAction
extends AnAction {
    public static final Logger LOG = Logger.getInstance(ApplyChangesAction.class);
    public static final Key<Boolean> APPLY_CHANGES = Key.create((String)"android.apply.changes");
    private static final CustomShortcutSet SHORTCUT_SET = CustomShortcutSet.fromString((String[])new String[]{SystemInfo.isMac ? "control meta R" : "control F10"});

    public ApplyChangesAction() {
        super("Apply Changes", "Apply Changes", StudioIcons.Shell.Toolbar.INSTANT_RUN);
        this.setShortcutSet((ShortcutSet)SHORTCUT_SET);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ApplyChangesAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ApplyChangesAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            LOG.warn("Apply Changes action performed with no project");
            return;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (settings == null) {
            LOG.warn("Apply Changes action could not locate current run config settings");
            return;
        }
        Executor executor = ApplyChangesAction.getExecutor(DefaultRunExecutor.EXECUTOR_ID);
        if (executor == null) {
            LOG.warn("Apply Changes action could not identify executor");
            return;
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
        if (builder == null) {
            LOG.warn("Apply Changes action could not construct an env");
            return;
        }
        ExecutionEnvironment env = builder.activeTarget().dataContext(e.getDataContext()).build();
        env.putCopyableUserData(APPLY_CHANGES, (Object)true);
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
    }

    @Nullable
    private static Executor getExecutor(@NotNull String executorId) {
        if (executorId == null) {
            ApplyChangesAction.$$$reportNull$$$0(2);
        }
        for (Executor executor : (Executor[])Executor.EXECUTOR_EXTENSION_NAME.getExtensions()) {
            if (!executorId.equals(executor.getId())) continue;
            return executor;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/ApplyChangesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getExecutor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

