/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.gradle.InstantRunGradleSupport;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.LaunchTaskRunner;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.LaunchTasksProviderFactory;
import com.android.tools.idea.stats.RunStats;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunState
implements RunProfileState {
    @NotNull
    private final ExecutionEnvironment myEnv;
    @NotNull
    private final String myLaunchConfigName;
    @NotNull
    private final Module myModule;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    @NotNull
    private final ConsoleProvider myConsoleProvider;
    @NotNull
    private final DeviceFutures myDeviceFutures;
    @NotNull
    private final LaunchTasksProviderFactory myLaunchTasksProviderFactory;
    @Nullable
    private final ProcessHandler myPreviousSessionProcessHandler;

    public AndroidRunState(@NotNull ExecutionEnvironment env, @NotNull String launchConfigName, @NotNull Module module, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ConsoleProvider consoleProvider, @NotNull DeviceFutures deviceFutures, @NotNull LaunchTasksProviderFactory launchTasksProviderFactory, @Nullable ProcessHandler processHandler) {
        if (env == null) {
            AndroidRunState.$$$reportNull$$$0(0);
        }
        if (launchConfigName == null) {
            AndroidRunState.$$$reportNull$$$0(1);
        }
        if (module == null) {
            AndroidRunState.$$$reportNull$$$0(2);
        }
        if (applicationIdProvider == null) {
            AndroidRunState.$$$reportNull$$$0(3);
        }
        if (consoleProvider == null) {
            AndroidRunState.$$$reportNull$$$0(4);
        }
        if (deviceFutures == null) {
            AndroidRunState.$$$reportNull$$$0(5);
        }
        if (launchTasksProviderFactory == null) {
            AndroidRunState.$$$reportNull$$$0(6);
        }
        this.myEnv = env;
        this.myLaunchConfigName = launchConfigName;
        this.myModule = module;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myConsoleProvider = consoleProvider;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchTasksProviderFactory = launchTasksProviderFactory;
        this.myPreviousSessionProcessHandler = processHandler;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        ConsoleView console;
        ProcessHandler processHandler;
        LaunchTasksProvider launchTasksProvider;
        String applicationId2;
        if (runner == null) {
            AndroidRunState.$$$reportNull$$$0(7);
        }
        RunStats stats = RunStats.from(this.myEnv);
        try {
            applicationId2 = this.myApplicationIdProvider.getPackageName();
        }
        catch (ApkProvisionException e) {
            throw new ExecutionException("Unable to obtain application id", (Throwable)e);
        }
        stats.setPackage(applicationId2);
        AndroidModuleModel model = AndroidModuleModel.get(this.myModule);
        if (InstantRunSettings.isInstantRunEnabled() && InstantRunGradleUtils.getIrSupportStatus(model, null) == InstantRunGradleSupport.SUPPORTED) {
            assert (model != null);
            InstantRunBuildInfo info = InstantRunGradleUtils.getBuildInfo(model);
            if (info != null && !info.isCompatibleFormat()) {
                throw new ExecutionException("This version of Android Studio is incompatible with the Gradle Plugin used. Try disabling Instant Run (or updating either the IDE or the Gradle plugin to the latest version)");
            }
        }
        if ((launchTasksProvider = this.myLaunchTasksProviderFactory.get()).createsNewProcess()) {
            if (this.myPreviousSessionProcessHandler != null) {
                this.myPreviousSessionProcessHandler.detachProcess();
            }
            processHandler = new AndroidProcessHandler.Builder().setApplicationId(applicationId2).monitorRemoteProcesses(launchTasksProvider.monitorRemoteProcess()).build();
            console = this.attachConsole(processHandler, executor);
        } else {
            assert (this.myPreviousSessionProcessHandler != null) : "No process handler from previous session, yet current tasks don't create one";
            processHandler = this.myPreviousSessionProcessHandler;
            console = null;
        }
        LaunchInfo launchInfo = new LaunchInfo(executor, runner, this.myEnv, this.myConsoleProvider);
        LaunchTaskRunner task = new LaunchTaskRunner(this.myModule.getProject(), this.myLaunchConfigName, launchInfo, processHandler, this.myDeviceFutures, launchTasksProvider, stats);
        ProgressManager.getInstance().run((Task)task);
        return console == null ? null : new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    @NotNull
    public ConsoleView attachConsole(@NotNull ProcessHandler processHandler, @NotNull Executor executor) throws ExecutionException {
        if (processHandler == null) {
            AndroidRunState.$$$reportNull$$$0(8);
        }
        if (executor == null) {
            AndroidRunState.$$$reportNull$$$0(9);
        }
        ConsoleView consoleView = this.myConsoleProvider.createAndAttach((Disposable)this.myModule.getProject(), processHandler, executor);
        if (consoleView == null) {
            AndroidRunState.$$$reportNull$$$0(10);
        }
        return consoleView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchConfigName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFutures";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchTasksProviderFactory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AndroidRunState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AndroidRunState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "attachConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "attachConsole";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

