/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.fd.gradle.InstantRunGradleSupport;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProvider;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidLaunchTasksProviderFactory;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.AndroidRunState;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.GradleApkProvider;
import com.android.tools.idea.run.GradleApplicationIdProvider;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.LaunchOptionsProvider;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.NonGradleApplicationIdProvider;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.ValidationUtil;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.editor.ShowChooserTargetProvider;
import com.android.tools.idea.run.tasks.InstantRunNotificationTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProviderFactory;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.run.util.MultiUserUtils;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.stats.RunStats;
import com.android.tools.idea.stats.RunStatsService;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidRunConfigurationBase
extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>
implements PreferGradleMake {
    private static final Logger LOG = Logger.getInstance(AndroidRunConfigurationBase.class);
    private static final String GRADLE_SYNC_FAILED_ERR_MSG = "Gradle project sync failed. Please fix your project and try again.";
    private static final String PROFILERS_ELEMENT_NAME = "Profilers";
    private static final DialogWrapper.DoNotAskOption ourKillLaunchOption = new MyDoNotPromptOption();
    public boolean CLEAR_LOGCAT = false;
    public boolean SHOW_LOGCAT_AUTOMATICALLY = false;
    public boolean SKIP_NOOP_APK_INSTALLATIONS = true;
    public boolean FORCE_STOP_RUNNING_APP = true;
    private final ProfilerState myProfilerState;
    private final boolean myAndroidTests;
    private final DeployTargetContext myDeployTargetContext = new DeployTargetContext();
    private final AndroidDebuggerContext myAndroidDebuggerContext = new AndroidDebuggerContext("Java");
    @Transient
    @NotNull
    protected final transient DefaultPostBuildModelProvider myOutputProvider = new DefaultPostBuildModelProvider();

    public AndroidRunConfigurationBase(Project project, ConfigurationFactory factory, boolean androidTests) {
        super((RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
        this.myProfilerState = new ProfilerState();
        this.myAndroidTests = androidTests;
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        List<ValidationError> errors = this.validate(null);
        if (errors.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors);
        switch (topError.getSeverity()) {
            case FATAL: {
                throw new RuntimeConfigurationError(topError.getMessage(), topError.getQuickfix());
            }
            case WARNING: {
                throw new RuntimeConfigurationWarning(topError.getMessage(), topError.getQuickfix());
            }
        }
    }

    public List<ValidationError> validate(@Nullable Executor executor) {
        AndroidFacet facet;
        ArrayList errors = Lists.newArrayList();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            configurationModule.checkForWarning();
        }
        catch (RuntimeConfigurationException e) {
            errors.add(ValidationError.fromException(e));
        }
        Module module = configurationModule.getModule();
        if (module == null) {
            return errors;
        }
        Project project = module.getProject();
        if (AndroidProjectInfo.getInstance(project).requiredAndroidModelMissing()) {
            errors.add(ValidationError.fatal(GRADLE_SYNC_FAILED_ERR_MSG));
        }
        if ((facet = AndroidFacet.getInstance(module)) == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("no.facet.error", module.getName())));
        }
        if (!((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject() && ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() != 2) {
            if (((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject() || ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 5) {
                Pair<Boolean, String> result2 = this.supportsRunningLibraryProjects(facet);
                if (!((Boolean)result2.getFirst()).booleanValue()) {
                    errors.add(ValidationError.fatal((String)result2.getSecond()));
                }
            } else {
                errors.add(ValidationError.fatal(AndroidBundle.message("run.error.apk.not.valid", new Object[0])));
            }
        }
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform() == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("select.platform.error", new Object[0])));
        }
        if (facet.getManifest() == null && ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() != 4) {
            errors.add(ValidationError.fatal(AndroidBundle.message("android.manifest.not.found.error", new Object[0])));
        }
        errors.addAll(this.getDeployTargetContext().getCurrentDeployTargetState().validate(facet));
        errors.addAll(this.getApkProvider(facet, this.getApplicationIdProvider(facet), new ArrayList<AndroidDevice>()).validate());
        errors.addAll(this.checkConfiguration(facet));
        Object androidDebuggerState = this.myAndroidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            errors.addAll(((AndroidDebuggerState)androidDebuggerState).validate(facet, executor));
        }
        errors.addAll(this.myProfilerState.validate());
        return errors;
    }

    protected abstract Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet var1);

    @NotNull
    protected abstract List<ValidationError> checkConfiguration(@NotNull AndroidFacet var1);

    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        LaunchOptions.Builder builder = LaunchOptions.builder().setClearLogcatBeforeStart(this.CLEAR_LOGCAT).setSkipNoopApkInstallations(this.SKIP_NOOP_APK_INSTALLATIONS).setForceStopRunningApp(this.FORCE_STOP_RUNNING_APP);
        if (builder == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(0);
        }
        return builder;
    }

    public Collection<Module> getValidModules() {
        Module[] modules;
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (AndroidFacet.getInstance(module) == null) continue;
            result2.add(module);
        }
        return result2;
    }

    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders() {
        ArrayList targets = Lists.newArrayList();
        for (DeployTargetProvider target : this.getDeployTargetContext().getDeployTargetProviders()) {
            if (!target.isApplicable(this.myAndroidTests)) continue;
            targets.add(target);
        }
        ArrayList arrayList = targets;
        if (arrayList == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    protected void validateBeforeRun(@NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(2);
        }
        List<ValidationError> errors = this.validate(executor);
        ValidationUtil.promptAndQuickFixErrors(this.getProject(), errors);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(3);
        }
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(4);
        }
        RunStats stats = RunStatsService.get(this.getProject()).create();
        try {
            stats.start();
            RunProfileState state = this.doGetState(executor, env, stats);
            stats.markStateCreated();
            return state;
        }
        catch (Throwable t) {
            stats.abort();
            throw t;
        }
    }

    @Nullable
    public RunProfileState doGetState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull RunStats stats) throws ExecutionException {
        String error;
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(5);
        }
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(6);
        }
        if (stats == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(7);
        }
        this.validateBeforeRun(executor);
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        assert (module != null) : "Enforced by fatal validation check in checkConfiguration.";
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null) : "Enforced by fatal validation check in checkConfiguration.";
        Project project = env.getProject();
        boolean forceColdswap = !InstantRunUtils.isInvokedViaHotswapAction(env);
        boolean instantRunEnabled = InstantRunSettings.isInstantRunEnabled();
        AndroidSessionInfo existingSessionInfo = AndroidSessionInfo.findOldSession(project, null, this.getUniqueID());
        stats.setDebuggable(LaunchUtils.canDebugApp(facet));
        stats.setInstantRunEnabled(instantRunEnabled);
        stats.setExecutor(executor.getId());
        stats.setApplyChanges(!forceColdswap);
        this.updateExtraRunStats(stats);
        boolean couldHaveHotswapped = false;
        DeviceFutures deviceFutures = null;
        boolean isDebugging = executor instanceof DefaultDebugExecutor;
        boolean userSelectedDeployTarget = this.requiresUserSelection(executor, isDebugging, facet);
        stats.setUserSelectedTarget(userSelectedDeployTarget);
        if (forceColdswap || ((Boolean)StudioFlags.JVMTI_REFRESH.get()).booleanValue()) {
            DeployTarget deployTarget = this.getDeployTarget(executor, env, isDebugging, facet);
            if (deployTarget == null) {
                return null;
            }
            DeployTargetState deployTargetState = this.getDeployTargetContext().getCurrentDeployTargetState();
            if (deployTarget.hasCustomRunProfileState(executor)) {
                return deployTarget.getRunProfileState(executor, env, deployTargetState);
            }
            deviceFutures = deployTarget.getDevices(deployTargetState, facet, this.getDeviceCount(isDebugging), isDebugging, this.getUniqueID());
            if (deviceFutures == null) {
                return null;
            }
            for (AndroidDevice device : deviceFutures.getDevices()) {
                if (!(device instanceof LaunchableAndroidDevice)) continue;
                stats.setLaunchedDevices(true);
            }
        }
        if (this.supportsInstantRun() && instantRunEnabled && existingSessionInfo != null) {
            PrepareSessionResult result2 = this.prepareInstantRunSession(existingSessionInfo, executor, facet, project, deviceFutures, forceColdswap);
            if (result2 == null) {
                return null;
            }
            if (deviceFutures == null && !forceColdswap) {
                deviceFutures = result2.futures;
            }
            couldHaveHotswapped = result2.couldHaveHotswapped;
        }
        if (deviceFutures == null || deviceFutures.get().isEmpty()) {
            throw new ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        InstantRunContext instantRunContext = null;
        if (this.supportsInstantRun() && instantRunEnabled) {
            instantRunContext = this.ensureGradleSupport(executor, env, module, facet, project, existingSessionInfo, deviceFutures);
        } else {
            this.logInstantRunOffReason(instantRunEnabled);
        }
        if (isDebugging && (error = AndroidRunConfigurationBase.canDebug(deviceFutures, facet, module.getName())) != null) {
            throw new ExecutionException(error);
        }
        ProcessHandler processHandler = null;
        if (existingSessionInfo != null && existingSessionInfo.getExecutorId().equals(executor.getId())) {
            processHandler = existingSessionInfo.getProcessHandler();
        }
        env.putCopyableUserData(AndroidRunConfigContext.KEY, (Object)this.createAndroidRunConfigContext(executor, forceColdswap, existingSessionInfo, couldHaveHotswapped, deviceFutures));
        env.putCopyableUserData(InstantRunContext.KEY, (Object)instantRunContext);
        env.putUserData(RunStats.KEY, (Object)stats);
        ApplicationIdProvider applicationIdProvider = this.getApplicationIdProvider(facet);
        LaunchOptions.Builder launchOptions = this.getLaunchOptions().setDebug(isDebugging);
        if (executor instanceof LaunchOptionsProvider) {
            launchOptions.addExtraOptions(((LaunchOptionsProvider)executor).getLaunchOptions());
        }
        LaunchTasksProviderFactory providerFactory = this.createLaunchTasksProviderFactory(env, facet, deviceFutures, applicationIdProvider, launchOptions.build(), instantRunContext, processHandler);
        InstantRunStatsService.get(project).notifyBuildStarted();
        return new AndroidRunState(env, this.getName(), module, applicationIdProvider, this.getConsoleProvider(), deviceFutures, providerFactory, processHandler);
    }

    @Nullable
    private InstantRunContext ensureGradleSupport(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull Module module, @NotNull AndroidFacet facet, @NotNull Project project, @Nullable AndroidSessionInfo info, @NotNull DeviceFutures deviceFutures) {
        InstantRunGradleSupport gradleSupport;
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(8);
        }
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(9);
        }
        if (module == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(10);
        }
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(11);
        }
        if (project == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(12);
        }
        if (deviceFutures == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(13);
        }
        if ((gradleSupport = this.canInstantRun(module, deviceFutures.getDevices())) == InstantRunGradleSupport.TARGET_PLATFORM_NOT_INSTALLED && this.promptInstallTargetPlatform(project, deviceFutures)) {
            gradleSupport = InstantRunGradleSupport.SUPPORTED;
        }
        if (gradleSupport == InstantRunGradleSupport.SUPPORTED) {
            InstantRunUtils.setInstantRunEnabled(env, true);
            return InstantRunGradleUtils.createGradleProjectContext(facet);
        }
        this.notifyInstantRunDisabled(executor, env, info, gradleSupport);
        return null;
    }

    @NotNull
    private LaunchTasksProviderFactory createLaunchTasksProviderFactory(@NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull DeviceFutures deviceFutures, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull LaunchOptions launchOptions, @Nullable InstantRunContext instantRunContext, @Nullable ProcessHandler processHandler) {
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(14);
        }
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(15);
        }
        if (deviceFutures == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(16);
        }
        if (applicationIdProvider == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(17);
        }
        if (launchOptions == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(18);
        }
        AndroidLaunchTasksProviderFactory androidLaunchTasksProviderFactory = new AndroidLaunchTasksProviderFactory(this, env, facet, applicationIdProvider, this.getApkProvider(facet, applicationIdProvider, deviceFutures.getDevices()), deviceFutures, launchOptions, processHandler, instantRunContext);
        if (androidLaunchTasksProviderFactory == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(19);
        }
        return androidLaunchTasksProviderFactory;
    }

    @NotNull
    private AndroidRunConfigContext createAndroidRunConfigContext(@NotNull Executor executor, boolean forceColdswap, @Nullable AndroidSessionInfo existingSessionInfo, boolean couldHaveHotswapped, @NotNull DeviceFutures deviceFutures) {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(20);
        }
        if (deviceFutures == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(21);
        }
        AndroidRunConfigContext runConfigContext = new AndroidRunConfigContext();
        runConfigContext.setTargetDevices(deviceFutures);
        runConfigContext.setSameExecutorAsPreviousSession(this.isSameExecutorAsPreviousSession(executor, existingSessionInfo));
        runConfigContext.setForceColdSwap(forceColdswap, couldHaveHotswapped);
        AndroidRunConfigContext androidRunConfigContext = runConfigContext;
        if (androidRunConfigContext == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(22);
        }
        return androidRunConfigContext;
    }

    @Nullable
    PrepareSessionResult prepareInstantRunSession(@NotNull AndroidSessionInfo info, @NotNull Executor executor, @NotNull AndroidFacet facet, @NotNull Project project, @Nullable DeviceFutures chosenDeviceFutues, boolean forceColdswap) {
        if (info == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(23);
        }
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(24);
        }
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(25);
        }
        if (project == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(26);
        }
        DeviceFutures sessionDeviceFutures = AndroidRunConfigurationBase.getFastDeployDevices(executor, AndroidModuleModel.get(facet), info);
        boolean couldHaveHotswapped = false;
        if (sessionDeviceFutures == null && !forceColdswap) {
            if (!this.promptAndKillSession(executor, project, info)) {
                return null;
            }
        } else if (sessionDeviceFutures != null && sessionDeviceFutures.allMatch(chosenDeviceFutues)) {
            couldHaveHotswapped = true;
            AndroidRunConfigurationBase.killSession(info);
        }
        return new PrepareSessionResult(sessionDeviceFutures, couldHaveHotswapped);
    }

    private void notifyInstantRunDisabled(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @Nullable AndroidSessionInfo info, @NotNull InstantRunGradleSupport gradleSupport) {
        String notificationText;
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(27);
        }
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(28);
        }
        if (gradleSupport == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(29);
        }
        InstantRunManager.LOG.warn("Instant Run enabled, but not doing an instant run build since: " + (Object)((Object)gradleSupport));
        if (!this.isSameExecutorAsPreviousSession(executor, info) && (notificationText = gradleSupport.getUserNotification()) != null) {
            InstantRunNotificationTask.showNotification(env.getProject(), null, notificationText);
        }
    }

    private boolean promptInstallTargetPlatform(@NotNull Project project, @NotNull DeviceFutures deviceFutures) {
        if (project == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(30);
        }
        if (deviceFutures == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(31);
        }
        AndroidVersion version2 = deviceFutures.getDevices().get(0).getVersion();
        String message = AndroidBundle.message("instant.run.quickfix.missing.platform", SdkVersionInfo.getVersionWithCodename((AndroidVersion)version2));
        int result2 = Messages.showYesNoDialog((Project)project, (String)message, (String)"Instant Run", (String)"Install and Continue", (String)"Proceed without Instant Run", (Icon)Messages.getQuestionIcon());
        if (result2 == 0) {
            ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)ImmutableList.of((Object)DetailsTypes.getPlatformPath((AndroidVersion)version2)));
            if (dialog == null) {
                LOG.warn("Unable to get quick fix wizard to install missing platform required for instant run.");
            } else if (dialog.showAndGet()) {
                return true;
            }
        }
        return false;
    }

    private void logInstantRunOffReason(boolean instantRunEnabled) {
        String msg = "Not using instant run for this launch: ";
        msg = instantRunEnabled ? msg + this.getType().getDisplayName() + " does not support instant run" : msg + "instant run is disabled";
        InstantRunManager.LOG.info(msg);
    }

    private boolean isSameExecutorAsPreviousSession(@NotNull Executor executor, @Nullable AndroidSessionInfo info) {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(32);
        }
        return info != null && executor.getId().equals(info.getExecutorId());
    }

    private static void killSession(@NotNull AndroidSessionInfo info) {
        if (info == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(33);
        }
        info.getProcessHandler().destroyProcess();
    }

    @Nullable
    protected static DeviceFutures getFastDeployDevices(@NotNull Executor executor, @Nullable AndroidModuleModel model, @NotNull AndroidSessionInfo info) {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(34);
        }
        if (info == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(35);
        }
        if (!info.getExecutorId().equals(executor.getId())) {
            String msg = String.format("Cannot Instant Run since old executor (%1$s) doesn't match current executor (%2$s)", info.getExecutorId(), executor.getId());
            InstantRunManager.LOG.info(msg);
            return null;
        }
        List<IDevice> devices = info.getDevices();
        if (devices.isEmpty()) {
            InstantRunManager.LOG.info("Cannot Instant Run since we could not locate the devices from the existing launch session");
            return null;
        }
        if (devices.size() > 1) {
            InstantRunManager.LOG.info("Last run was on > 1 device, not reusing devices and prompting again");
            return null;
        }
        AndroidVersion version2 = devices.get(0).getVersion();
        InstantRunGradleSupport status = InstantRunGradleUtils.getIrSupportStatus(model, version2);
        if (status != InstantRunGradleSupport.SUPPORTED) {
            InstantRunManager.LOG.info("Cannot Instant Run: " + (Object)((Object)status));
            return null;
        }
        return DeviceFutures.forDevices(devices);
    }

    private static String canDebug(@NotNull DeviceFutures deviceFutures, @NotNull AndroidFacet facet, @NotNull String moduleName) {
        if (deviceFutures == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(36);
        }
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(37);
        }
        if (moduleName == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(38);
        }
        for (ListenableFuture<IDevice> future2 : deviceFutures.get()) {
            IDevice device;
            if (!future2.isDone() || LaunchUtils.canDebugAppOnDevice(facet, device = (IDevice)Futures.getUnchecked(future2))) continue;
            return AndroidBundle.message("android.cannot.debug.noDebugPermissions", moduleName, device.getName());
        }
        return null;
    }

    private boolean requiresUserSelection(@NotNull Executor executor, boolean debug, @NotNull AndroidFacet facet) {
        DeployTargetProvider currentTargetProvider;
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(39);
        }
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(40);
        }
        if ((currentTargetProvider = this.getDeployTargetContext().getCurrentDeployTargetProvider()) instanceof ShowChooserTargetProvider) {
            return currentTargetProvider.requiresRuntimePrompt() && ((ShowChooserTargetProvider)currentTargetProvider).getCachedDeployTarget(executor, facet, this.getDeviceCount(debug), this.getDeployTargetContext().getDeployTargetStates(), this.getUniqueID()) == null;
        }
        return currentTargetProvider.requiresRuntimePrompt();
    }

    @Nullable
    private DeployTarget getDeployTarget(@NotNull Executor executor, @NotNull ExecutionEnvironment env, boolean debug, @NotNull AndroidFacet facet) {
        DeployTarget deployTarget;
        DeployTargetProvider currentTargetProvider;
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(41);
        }
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(42);
        }
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(43);
        }
        if ((currentTargetProvider = this.getDeployTargetContext().getCurrentDeployTargetProvider()).requiresRuntimePrompt()) {
            deployTarget = currentTargetProvider.showPrompt(executor, env, facet, this.getDeviceCount(debug), this.myAndroidTests, this.getDeployTargetContext().getDeployTargetStates(), this.getUniqueID(), LaunchCompatibilityCheckerImpl.create(facet));
            if (deployTarget == null) {
                return null;
            }
        } else {
            deployTarget = currentTargetProvider.getDeployTarget();
        }
        return deployTarget;
    }

    private boolean promptAndKillSession(@NotNull Executor executor, @NotNull Project project, @NotNull AndroidSessionInfo info) {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(44);
        }
        if (project == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(45);
        }
        if (info == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(46);
        }
        String previousExecutorId = info.getExecutorId();
        String currentExecutorId = executor.getId();
        if (ourKillLaunchOption.isToBeShown()) {
            String noText;
            String msg;
            if (previousExecutorId.equals(currentExecutorId)) {
                msg = "Restart App?\nThe app is already running. Would you like to kill it and restart the session?";
                noText = "Cancel";
            } else {
                String previousExecutorActionName = info.getExecutorActionName();
                String currentExecutorActionName = executor.getActionName();
                msg = String.format("To switch from %1$s to %2$s, the app has to restart. Continue?", previousExecutorActionName, currentExecutorActionName);
                noText = "Cancel " + currentExecutorActionName;
            }
            String title = "Launching " + this.getName();
            String yesText = "Restart " + this.getName();
            if (1 == Messages.showYesNoDialog((Project)project, (String)msg, (String)title, (String)yesText, (String)noText, (Icon)AllIcons.General.QuestionDialog, (DialogWrapper.DoNotAskOption)ourKillLaunchOption)) {
                return false;
            }
        }
        LOG.info("Disconnecting existing session of the same launch configuration");
        AndroidRunConfigurationBase.killSession(info);
        return true;
    }

    @NotNull
    protected ApplicationIdProvider getApplicationIdProvider(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(47);
        }
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getModel() != null && ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() instanceof AndroidModuleModel) {
            GradleApplicationIdProvider gradleApplicationIdProvider = new GradleApplicationIdProvider(facet, this.myOutputProvider);
            if (gradleApplicationIdProvider == null) {
                AndroidRunConfigurationBase.$$$reportNull$$$0(48);
            }
            return gradleApplicationIdProvider;
        }
        NonGradleApplicationIdProvider nonGradleApplicationIdProvider = new NonGradleApplicationIdProvider(facet);
        if (nonGradleApplicationIdProvider == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(49);
        }
        return nonGradleApplicationIdProvider;
    }

    @NotNull
    protected abstract ApkProvider getApkProvider(@NotNull AndroidFacet var1, @NotNull ApplicationIdProvider var2, @NotNull List<AndroidDevice> var3);

    @NotNull
    protected abstract ConsoleProvider getConsoleProvider();

    @Nullable
    protected abstract LaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider var1, @NotNull AndroidFacet var2, @NotNull String var3, boolean var4, @NotNull LaunchStatus var5);

    @NotNull
    protected ApkProvider createGradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, boolean test, @NotNull List<AndroidDevice> targetDevices) {
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(50);
        }
        if (applicationIdProvider == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(51);
        }
        if (targetDevices == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(52);
        }
        Computable outputKindProvider = () -> {
            if (DynamicAppUtils.useSelectApksFromBundleBuilder(facet.getModule(), (RunConfiguration)this, targetDevices)) {
                return GradleApkProvider.OutputKind.AppBundleOutputModel;
            }
            return GradleApkProvider.OutputKind.Default;
        };
        GradleApkProvider gradleApkProvider = new GradleApkProvider(facet, applicationIdProvider, this.myOutputProvider, test, (Computable<GradleApkProvider.OutputKind>)outputKindProvider);
        if (gradleApkProvider == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(53);
        }
        return gradleApkProvider;
    }

    public boolean monitorRemoteProcess() {
        return true;
    }

    @NotNull
    public final DeviceCount getDeviceCount(boolean debug) {
        DeviceCount deviceCount = DeviceCount.fromBoolean(this.supportMultipleDevices() && !debug);
        if (deviceCount == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(54);
        }
        return deviceCount;
    }

    protected abstract boolean supportMultipleDevices();

    public boolean supportsInstantRun() {
        return false;
    }

    public void updateExtraRunStats(RunStats runStats) {
    }

    public int getUserIdFromAmParameters() {
        return 0;
    }

    @NotNull
    InstantRunGradleSupport canInstantRun(@NotNull Module module, @NotNull List<AndroidDevice> targetDevices) {
        if (module == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(55);
        }
        if (targetDevices == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(56);
        }
        if (targetDevices.size() != 1) {
            InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.CANNOT_BUILD_FOR_MULTIPLE_DEVICES;
            if (instantRunGradleSupport == null) {
                AndroidRunConfigurationBase.$$$reportNull$$$0(57);
            }
            return instantRunGradleSupport;
        }
        AndroidDevice device = targetDevices.get(0);
        AndroidVersion version2 = device.getVersion();
        if (!InstantRunManager.isInstantRunCapableDeviceVersion(version2)) {
            InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.API_TOO_LOW_FOR_INSTANT_RUN;
            if (instantRunGradleSupport == null) {
                AndroidRunConfigurationBase.$$$reportNull$$$0(58);
            }
            return instantRunGradleSupport;
        }
        if (DynamicAppUtils.useSelectApksFromBundleBuilder(module, (RunConfiguration)this, targetDevices)) {
            InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.USES_APP_BUNDLE_OUTPUT;
            if (instantRunGradleSupport == null) {
                AndroidRunConfigurationBase.$$$reportNull$$$0(59);
            }
            return instantRunGradleSupport;
        }
        IDevice targetDevice = MakeBeforeRunTaskProvider.getLaunchedDevice(device);
        if (targetDevice != null && MultiUserUtils.hasMultipleUsers(targetDevice, 200L, TimeUnit.MILLISECONDS, false) && (this.getUserIdFromAmParameters() != 0 || !MultiUserUtils.isCurrentUserThePrimaryUser(targetDevice, 200L, TimeUnit.MILLISECONDS, true))) {
            InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.CANNOT_DEPLOY_FOR_SECONDARY_USER;
            if (instantRunGradleSupport == null) {
                AndroidRunConfigurationBase.$$$reportNull$$$0(60);
            }
            return instantRunGradleSupport;
        }
        InstantRunGradleSupport irSupportStatus = InstantRunGradleUtils.getIrSupportStatus(InstantRunGradleUtils.getAppModel(module), version2);
        if (irSupportStatus != InstantRunGradleSupport.SUPPORTED) {
            InstantRunGradleSupport instantRunGradleSupport = irSupportStatus;
            if (instantRunGradleSupport == null) {
                AndroidRunConfigurationBase.$$$reportNull$$$0(61);
            }
            return instantRunGradleSupport;
        }
        if (!InstantRunGradleUtils.appHasCode(AndroidFacet.getInstance(module))) {
            InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.HAS_CODE_FALSE;
            if (instantRunGradleSupport == null) {
                AndroidRunConfigurationBase.$$$reportNull$$$0(62);
            }
            return instantRunGradleSupport;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.SUPPORTED;
            if (instantRunGradleSupport == null) {
                AndroidRunConfigurationBase.$$$reportNull$$$0(63);
            }
            return instantRunGradleSupport;
        }
        IAndroidTarget[] targets = platform.getSdkData().getTargets();
        for (int i2 = targets.length - 1; i2 >= 0; --i2) {
            if (!targets[i2].isPlatform() || !targets[i2].getVersion().equals((Object)version2)) continue;
            InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.SUPPORTED;
            if (instantRunGradleSupport == null) {
                AndroidRunConfigurationBase.$$$reportNull$$$0(64);
            }
            return instantRunGradleSupport;
        }
        InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.TARGET_PLATFORM_NOT_INSTALLED;
        if (instantRunGradleSupport == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(65);
        }
        return instantRunGradleSupport;
    }

    public void setOutputModel(@NotNull PostBuildModel outputModel) {
        if (outputModel == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(66);
        }
        this.myOutputProvider.setOutputModel(outputModel);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(67);
        }
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.myDeployTargetContext.readExternal(element);
        this.myAndroidDebuggerContext.readExternal(element);
        Element profilersElement = element.getChild(PROFILERS_ELEMENT_NAME);
        if (profilersElement != null) {
            this.myProfilerState.readExternal(profilersElement);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(68);
        }
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        this.myDeployTargetContext.writeExternal(element);
        this.myAndroidDebuggerContext.writeExternal(element);
        Element profilersElement = new Element(PROFILERS_ELEMENT_NAME);
        element.addContent(profilersElement);
        this.myProfilerState.writeExternal(profilersElement);
    }

    public boolean isNativeLaunch() {
        AndroidDebugger androidDebugger = this.myAndroidDebuggerContext.getAndroidDebugger();
        if (androidDebugger == null) {
            return false;
        }
        return !androidDebugger.getId().equals("Java");
    }

    @NotNull
    public DeployTargetContext getDeployTargetContext() {
        DeployTargetContext deployTargetContext = this.myDeployTargetContext;
        if (deployTargetContext == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(69);
        }
        return deployTargetContext;
    }

    @NotNull
    public AndroidDebuggerContext getAndroidDebuggerContext() {
        AndroidDebuggerContext androidDebuggerContext = this.myAndroidDebuggerContext;
        if (androidDebuggerContext == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(70);
        }
        return androidDebuggerContext;
    }

    @NotNull
    public ProfilerState getProfilerState() {
        ProfilerState profilerState = this.myProfilerState;
        if (profilerState == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(71);
        }
        return profilerState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 66: 
            case 67: 
            case 68: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 66: 
            case 67: 
            case 68: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AndroidRunConfigurationBase";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 20: 
            case 24: 
            case 27: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 28: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stats";
                break;
            }
            case 10: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: 
            case 15: 
            case 25: 
            case 37: 
            case 40: 
            case 43: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 12: 
            case 26: 
            case 30: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 16: 
            case 21: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFutures";
                break;
            }
            case 17: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchOptions";
                break;
            }
            case 23: 
            case 33: 
            case 35: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleSupport";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDevices";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputModel";
                break;
            }
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableDeployTargetProviders";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AndroidRunConfigurationBase";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createLaunchTasksProviderFactory";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndroidRunConfigContext";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationIdProvider";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createGradleApkProvider";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceCount";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "canInstantRun";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTargetContext";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidDebuggerContext";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilerState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validateBeforeRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGetState";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ensureGradleSupport";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createLaunchTasksProviderFactory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createAndroidRunConfigContext";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "prepareInstantRunSession";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "notifyInstantRunDisabled";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "promptInstallTargetPlatform";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isSameExecutorAsPreviousSession";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "killSession";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFastDeployDevices";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "canDebug";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "requiresUserSelection";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDeployTarget";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "promptAndKillSession";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationIdProvider";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createGradleApkProvider";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "canInstantRun";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setOutputModel";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 66: 
            case 67: 
            case 68: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PrepareSessionResult {
        DeviceFutures futures;
        boolean couldHaveHotswapped;

        PrepareSessionResult(DeviceFutures futures, boolean couldHaveHotswapped) {
            this.futures = futures;
            this.couldHaveHotswapped = couldHaveHotswapped;
        }
    }

    private static class DefaultPostBuildModelProvider
    implements PostBuildModelProvider {
        @Transient
        @Nullable
        private transient PostBuildModel myBuildOutputs = null;

        private DefaultPostBuildModelProvider() {
        }

        public void setOutputModel(@NotNull PostBuildModel postBuildModel) {
            if (postBuildModel == null) {
                DefaultPostBuildModelProvider.$$$reportNull$$$0(0);
            }
            this.myBuildOutputs = postBuildModel;
        }

        @Override
        @Nullable
        public PostBuildModel getPostBuildModel() {
            return this.myBuildOutputs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postBuildModel", "com/android/tools/idea/run/AndroidRunConfigurationBase$DefaultPostBuildModelProvider", "setOutputModel"));
        }
    }

    private static class MyDoNotPromptOption
    implements DialogWrapper.DoNotAskOption {
        public static final String PROMPT_KEY = "android.show.prompt.kill.session";
        private boolean myShow = PropertiesComponent.getInstance().getBoolean("android.show.prompt.kill.session", false);

        private MyDoNotPromptOption() {
        }

        public boolean isToBeShown() {
            return !this.myShow;
        }

        public void setToBeShown(boolean toBeShown, int exitCode) {
            this.myShow = !toBeShown;
            PropertiesComponent.getInstance().setValue(PROMPT_KEY, this.myShow);
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        @NotNull
        public String getDoNotShowMessage() {
            if ("Do not ask again" == null) {
                MyDoNotPromptOption.$$$reportNull$$$0(0);
            }
            return "Do not ask again";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase$MyDoNotPromptOption", "getDoNotShowMessage"));
        }
    }
}

