/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.view;

import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.resourceExplorer.model.DesignAssetSet;
import com.android.tools.idea.resourceExplorer.view.DesignAssetExplorer;
import com.android.tools.idea.resourceExplorer.view.DesignAssetsListKt;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005RN\u0010\u0006\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/resourceExplorer/view/DesignAssetsList;", "Ljavax/swing/JList;", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetSet;", "browserViewModel", "Lcom/android/tools/idea/resourceExplorer/view/DesignAssetExplorer;", "(Lcom/android/tools/idea/resourceExplorer/view/DesignAssetExplorer;)V", "assetToImage", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "Ljava/awt/Image;", "itemMargin", "", "getItemMargin", "()I", "setItemMargin", "(I)V", "Renderer", "intellij.android.core"})
public final class DesignAssetsList
extends JList<DesignAssetSet> {
    private int itemMargin;
    private final Cache<DesignAssetSet, Image> assetToImage;
    private final DesignAssetExplorer browserViewModel;

    public final int getItemMargin() {
        return this.itemMargin;
    }

    public final void setItemMargin(int n) {
        this.itemMargin = n;
    }

    public DesignAssetsList(@NotNull DesignAssetExplorer browserViewModel) {
        Intrinsics.checkParameterIsNotNull((Object)browserViewModel, (String)"browserViewModel");
        super(browserViewModel.getDesignAssetListModel());
        this.browserViewModel = browserViewModel;
        this.itemMargin = 16;
        this.assetToImage = CacheBuilder.newBuilder().softValues().build();
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(0);
        this.setCellRenderer(new Renderer());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0002J*\u0010\r\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u000fH\u0002J:\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0003\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/resourceExplorer/view/DesignAssetsList$Renderer;", "Ljavax/swing/JPanel;", "Ljavax/swing/ListCellRenderer;", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetSet;", "(Lcom/android/tools/idea/resourceExplorer/view/DesignAssetsList;)V", "imageIcon", "Ljavax/swing/ImageIcon;", "nameLabel", "Ljavax/swing/JLabel;", "statusLabel", "fetchImage", "Ljava/awt/Image;", "asset", "getDesignAssetView", "name", "", "selected", "", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "assetSet", "index", "", "isSelected", "cellHasFocus", "intellij.android.core"})
    public final class Renderer
    extends JPanel
    implements ListCellRenderer<DesignAssetSet> {
        private final ImageIcon imageIcon;
        private final JLabel nameLabel;
        private final JLabel statusLabel;

        @Override
        @NotNull
        public Component getListCellRendererComponent(@Nullable JList<? extends DesignAssetSet> list, @NotNull DesignAssetSet assetSet, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkParameterIsNotNull((Object)assetSet, (String)"assetSet");
            return this.getDesignAssetView(assetSet, assetSet.getName(), isSelected, DesignAssetsList.this.browserViewModel.getStatusLabel(assetSet));
        }

        private final JPanel getDesignAssetView(DesignAssetSet asset, String name, boolean selected, String statusLabel) {
            Border border;
            if (selected) {
                this.setOpaque(true);
                this.setBackground(UIUtil.getListUnfocusedSelectionBackground());
                int emptyBorderWidth = DesignAssetsList.this.getItemMargin() - 1;
                border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIUtil.getListSelectionBackground(), 1, true), BorderFactory.createEmptyBorder(emptyBorderWidth, emptyBorderWidth, emptyBorderWidth, emptyBorderWidth));
            } else {
                this.setOpaque(false);
                border = BorderFactory.createEmptyBorder(DesignAssetsList.this.getItemMargin(), DesignAssetsList.this.getItemMargin(), DesignAssetsList.this.getItemMargin(), DesignAssetsList.this.getItemMargin());
            }
            this.setBorder(border);
            this.statusLabel.setText(statusLabel);
            this.nameLabel.setText(name);
            Image image = (Image)DesignAssetsList.this.assetToImage.getIfPresent((Object)asset);
            if (image == null) {
                image = this.fetchImage(asset);
            }
            this.imageIcon.setImage(image);
            return this;
        }

        static /* synthetic */ JPanel getDesignAssetView$default(Renderer renderer, DesignAssetSet designAssetSet, String string, boolean bl, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return renderer.getDesignAssetView(designAssetSet, string, bl, string2);
        }

        private final Image fetchImage(DesignAssetSet asset) {
            ListenableFuture<? extends Image> previewFuture2 = DesignAssetsList.this.browserViewModel.getPreview(asset.getHighestDensityAsset(), (Dimension)DesignAssetsListKt.access$getICON_SIZE$p());
            Runnable listener2 = new Runnable(this, previewFuture2, asset){
                final /* synthetic */ Renderer this$0;
                final /* synthetic */ ListenableFuture $previewFuture;
                final /* synthetic */ DesignAssetSet $asset;

                public final void run() {
                    Image image = (Image)this.$previewFuture.get();
                    if (image != null) {
                        DesignAssetsList.access$getAssetToImage$p(this.this$0.DesignAssetsList.this).put((Object)this.$asset, (Object)image);
                    } else {
                        DesignAssetsList.access$getAssetToImage$p(this.this$0.DesignAssetsList.this).put((Object)this.$asset, (Object)DesignAssetsListKt.access$getEMPTY_ICON$p());
                    }
                    this.this$0.repaint();
                }
                {
                    this.this$0 = renderer;
                    this.$previewFuture = listenableFuture;
                    this.$asset = designAssetSet;
                }
            };
            previewFuture2.addListener(listener2, (Executor)EdtExecutor.INSTANCE);
            return DesignAssetsListKt.access$getEMPTY_ICON$p();
        }

        public Renderer() {
            super(new BorderLayout());
            this.imageIcon = new ImageIcon(DesignAssetsListKt.access$getEMPTY_ICON$p());
            this.nameLabel = new JLabel("", 0);
            this.statusLabel = new JLabel("", 0);
            JLabel jLabel = new JLabel(this.imageIcon);
            Renderer renderer = this;
            JLabel $receiver = jLabel;
            boolean bl = false;
            $receiver.setBorder(JBUI.Borders.empty((int)18));
            JLabel jLabel2 = jLabel;
            renderer.add(jLabel2);
            this.add((Component)this.nameLabel, "South");
            this.add((Component)this.statusLabel, "North");
        }
    }
}

