/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.sketchImporter.converter.models;

import com.android.tools.idea.resourceExplorer.sketchImporter.converter.models.InheritedProperties;
import com.android.tools.idea.resourceExplorer.sketchImporter.converter.models.ResizingConstraint;
import com.android.tools.idea.resourceExplorer.sketchImporter.converter.models.ShapeModel;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.pages.SketchSymbolInstance;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.pages.SketchSymbolMaster;
import com.google.common.collect.ImmutableList;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;

public class SymbolModel {
    @NotNull
    ImmutableList<ShapeModel> myShapeModels;
    @NotNull
    SketchSymbolMaster mySymbolMaster;
    @NotNull
    SketchSymbolInstance mySymbolInstance;

    public SymbolModel(@NotNull ImmutableList<ShapeModel> shapeModels, @NotNull SketchSymbolMaster symbolMaster) {
        if (shapeModels == null) {
            SymbolModel.$$$reportNull$$$0(0);
        }
        if (symbolMaster == null) {
            SymbolModel.$$$reportNull$$$0(1);
        }
        this.myShapeModels = shapeModels;
        this.mySymbolMaster = symbolMaster;
    }

    public void applyProperties(@NotNull InheritedProperties properties) {
        if (properties == null) {
            SymbolModel.$$$reportNull$$$0(2);
        }
        for (ShapeModel shapeModel : this.myShapeModels) {
            shapeModel.applyOpacity(properties.getInheritedOpacity());
            shapeModel.applyTransformations(properties);
        }
    }

    @NotNull
    public ImmutableList<ShapeModel> getShapeModels() {
        ImmutableList<ShapeModel> immutableList = this.myShapeModels;
        if (immutableList == null) {
            SymbolModel.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    private double getScaleRatioX() {
        return this.mySymbolInstance.getFrame().getWidth() / this.mySymbolMaster.getFrame().getWidth();
    }

    private double getScaleRatioY() {
        return this.mySymbolInstance.getFrame().getHeight() / this.mySymbolMaster.getFrame().getHeight();
    }

    private boolean isInstanceScaled() {
        return Double.compare(this.getScaleRatioX(), 1.0) != 0 || Double.compare(this.getScaleRatioY(), 1.0) != 0;
    }

    public void setSymbolInstance(@NotNull SketchSymbolInstance symbolInstance) {
        if (symbolInstance == null) {
            SymbolModel.$$$reportNull$$$0(4);
        }
        this.mySymbolInstance = symbolInstance;
    }

    public void scaleShapes() {
        if (this.isInstanceScaled()) {
            for (ShapeModel shapeModel : this.myShapeModels) {
                ResizingConstraint constraint = shapeModel.getResizingConstraint();
                if (constraint.isNoConstraint()) {
                    shapeModel.scale(this.getScaleRatioX(), this.getScaleRatioY());
                } else if (constraint.isOnlyConstraintWidth()) {
                    shapeModel.scale(1.0, this.getScaleRatioY());
                } else if (constraint.isOnlyConstraintHeight()) {
                    shapeModel.scale(this.getScaleRatioX(), 1.0);
                }
                AffineTransform transform2 = new AffineTransform();
                transform2.scale(this.getScaleRatioX(), this.getScaleRatioY());
                Point2D.Double newPoint = new Point2D.Double();
                transform2.transform(shapeModel.getShapeFrameLocation(), newPoint);
                shapeModel.translateTo(newPoint.getX(), newPoint.getY());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shapeModels";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolMaster";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resourceExplorer/sketchImporter/converter/models/SymbolModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resourceExplorer/sketchImporter/converter/models/SymbolModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShapeModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyProperties";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSymbolInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

