/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.plugin;

import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.resourceExplorer.plugin.DesignAssetRenderer;
import com.android.tools.idea.resourceExplorer.plugin.DrawableAssetRendererKt;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.ParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/resourceExplorer/plugin/DrawableAssetRenderer;", "Lcom/android/tools/idea/resourceExplorer/plugin/DesignAssetRenderer;", "()V", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "kotlin.jvm.PlatformType", "drawableRenderer", "Lcom/android/tools/idea/npw/assetstudio/DrawableRenderer;", "ensureDrawableRendererInitialized", "", "module", "Lcom/intellij/openapi/module/Module;", "failedFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "Ljava/awt/Image;", "exception", "", "getImage", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dimension", "Ljava/awt/Dimension;", "isFileSupported", "", "intellij.android.core"})
public final class DrawableAssetRenderer
implements DesignAssetRenderer {
    private DrawableRenderer drawableRenderer;
    private final DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

    @Override
    public boolean isFileSupported(@NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)XmlFileType.INSTANCE) ^ true || file.getLength() == 0L) {
            return false;
        }
        try {
            Document document = this.documentBuilder.parse(file.getInputStream());
            Object[] objectArray = DrawableAssetRendererKt.access$getSUPPORTED_DRAWABLE_TAG$p();
            Document document2 = document;
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
            Element element = document2.getDocumentElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"document.documentElement");
            bl = ArraysKt.contains((Object[])objectArray, (Object)element.getNodeName());
        }
        catch (Exception ex) {
            DrawableAssetRendererKt.access$getLOG$p().warn((Throwable)ex);
            return false;
        }
        return bl;
    }

    @Override
    @NotNull
    public ListenableFuture<? extends Image> getImage(@NotNull VirtualFile file, @Nullable Module module, @NotNull Dimension dimension2) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)dimension2, (String)"dimension");
        try {
            if (module == null) {
                throw (Throwable)new NullPointerException("Module cannot be null to render a Drawable.");
            }
            if (!this.isFileSupported(file)) {
                throw (Throwable)new ParseException(file.getPath() + " couldn't be parsed as a drawable.", 0);
            }
            this.ensureDrawableRendererInitialized(module);
            byte[] byArray = file.contentsToByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"file.contentsToByteArray()");
            byte[] byArray2 = byArray;
            String xmlContent = new String(byArray2, Charsets.UTF_8);
            ListenableFuture<BufferedImage> listenableFuture = this.drawableRenderer;
            if (listenableFuture == null || (listenableFuture = listenableFuture.renderDrawable(xmlContent, dimension2)) == null) {
                throw (Throwable)new RenderingException(file.getPath() + " couldn't be rendered.", new Throwable[0]);
            }
            return listenableFuture;
        }
        catch (Exception ex) {
            return this.failedFuture(ex);
        }
    }

    private final void ensureDrawableRendererInitialized(Module module) {
        block5: {
            block4: {
                DrawableRenderer drawableRenderer;
                DrawableRenderer drawableRenderer2 = this.drawableRenderer;
                if (drawableRenderer2 == null) break block4;
                DrawableRenderer it = drawableRenderer = drawableRenderer2;
                boolean bl = false;
                if (!Disposer.isDisposed((Disposable)it)) break block5;
            }
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null) {
                throw (Throwable)new NullPointerException("Facet couldn't be found for use in DrawableRenderer.");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)androidFacet), (String)"AndroidFacet.getInstance\u2026se in DrawableRenderer.\")");
            AndroidFacet facet = androidFacet;
            DrawableRenderer renderer = new DrawableRenderer(facet);
            Disposer.register((Disposable)((Disposable)facet), (Disposable)renderer);
            this.drawableRenderer = renderer;
        }
    }

    private final ListenableFuture<? extends Image> failedFuture(Throwable exception) {
        DrawableAssetRendererKt.access$getLOG$p().warn(exception);
        ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)exception);
        Intrinsics.checkExpressionValueIsNotNull((Object)listenableFuture, (String)"Futures.immediateFailedFuture(exception)");
        return listenableFuture;
    }
}

