/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.importer;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.resourceExplorer.importer.SynchronizationListener;
import com.android.tools.idea.resourceExplorer.importer.SynchronizationManagerKt;
import com.android.tools.idea.resourceExplorer.importer.SynchronizationStatus;
import com.android.tools.idea.resourceExplorer.model.DesignAsset;
import com.android.tools.idea.resourceExplorer.model.DesignAssetSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\"\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 H\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\tH\u0002J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\tH\u0002J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/resourceExplorer/importer/SynchronizationManager;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "Lcom/intellij/openapi/Disposable;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "hashToFile", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "listeners", "", "Lcom/android/tools/idea/resourceExplorer/importer/SynchronizationListener;", "resourcesRepository", "Lcom/android/tools/idea/res/LocalResourceRepository;", "addListener", "", "listener", "dispose", "fileCreated", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "fileDeleted", "getSynchronizationStatus", "Lcom/android/tools/idea/resourceExplorer/importer/SynchronizationStatus;", "assetSet", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetSet;", "isModuleResourceFile", "", "virtualFile", "mapAllModuleResources", "resourcesDirectories", "", "notifyResourceCreated", "file", "notifyResourceRemoved", "removeListener", "intellij.android.core"})
public final class SynchronizationManager
implements VirtualFileListener,
Disposable {
    private LocalResourceRepository resourcesRepository;
    private Map<String, VirtualFile> hashToFile;
    private final List<SynchronizationListener> listeners;

    /*
     * WARNING - void declaration
     */
    private final Map<String, VirtualFile> mapAllModuleResources(Set<VirtualFile> resourcesDirectories) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        List<VirtualFile> list = AndroidResourceUtil.getResourceSubdirs(ResourceFolderType.DRAWABLE, (Collection<VirtualFile>)resourcesDirectories);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"AndroidResourceUtil\n    \u2026LE, resourcesDirectories)");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
            Iterable list$iv$iv = SynchronizationManagerKt.access$allChildren(virtualFile);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map2 = destination$iv$iv2;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)SynchronizationManagerKt.access$sha1(it), (Object)it);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return MapsKt.toMutableMap((Map)destination$iv$iv2);
    }

    @NotNull
    public final SynchronizationStatus getSynchronizationStatus(@NotNull DesignAssetSet assetSet) {
        int syncedFilesCount;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)assetSet, (String)"assetSet");
        Iterable $receiver$iv = assetSet.getDesignAssets();
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $receiver$iv) {
                int n2;
                DesignAsset it = (DesignAsset)element$iv;
                boolean bl = false;
                if (!this.hashToFile.containsKey(SynchronizationManagerKt.access$sha1(it.getFile())) || (n2 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = syncedFilesCount = n;
        return n3 == assetSet.getDesignAssets().size() ? SynchronizationStatus.SYNCED : (n3 == 0 ? SynchronizationStatus.NOT_SYNCED : SynchronizationStatus.PARTIALLY_SYNCED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isModuleResourceFile(VirtualFile virtualFile) {
        VirtualFile it;
        if (virtualFile.isDirectory()) return false;
        Set<VirtualFile> set = this.resourcesRepository.getResourceDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"resourcesRepository.resourceDirs");
        Iterable $receiver$iv = set;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (VirtualFile)element$iv;
            boolean bl = false;
        } while (!VfsUtilCore.isAncestor((VirtualFile)it, (VirtualFile)virtualFile, (boolean)false));
        return true;
    }

    private final void notifyResourceCreated(VirtualFile file) {
        Iterable $receiver$iv = this.listeners;
        for (Object element$iv : $receiver$iv) {
            SynchronizationListener it = (SynchronizationListener)element$iv;
            boolean bl = false;
            it.resourceAdded(file);
        }
    }

    private final void notifyResourceRemoved(VirtualFile file) {
        Iterable $receiver$iv = this.listeners;
        for (Object element$iv : $receiver$iv) {
            SynchronizationListener it = (SynchronizationListener)element$iv;
            boolean bl = false;
            it.resourceRemoved(file);
        }
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        if (this.isModuleResourceFile(virtualFile)) {
            VirtualFile virtualFile2 = event.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"event.file");
            String string = SynchronizationManagerKt.access$sha1(virtualFile2);
            VirtualFile virtualFile3 = event.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"event.file");
            this.hashToFile.put(string, virtualFile3);
            VirtualFile virtualFile4 = event.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"event.file");
            this.notifyResourceCreated(virtualFile4);
        }
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        if (this.isModuleResourceFile(virtualFile)) {
            Object object;
            Object v1;
            block3: {
                Iterable $receiver$iv = this.hashToFile.entrySet();
                for (Object element$iv : $receiver$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((VirtualFile)it.getValue()), (Object)event.getFile())) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            if ((object = (Map.Entry)v1) != null && (object = (String)object.getKey()) != null) {
                Object object2 = object;
                Map<String, VirtualFile> map2 = this.hashToFile;
                Object p1 = object2;
                boolean bl = false;
                VirtualFile cfr_ignored_0 = (VirtualFile)map2.remove(p1);
            }
            VirtualFile virtualFile2 = event.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"event.file");
            this.notifyResourceRemoved(virtualFile2);
        }
    }

    public final void addListener(@NotNull SynchronizationListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull SynchronizationListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    public void dispose() {
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this);
    }

    public SynchronizationManager(@NotNull AndroidFacet facet) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)((Object)facet), (String)"facet");
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getModuleResources(facet);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)localResourceRepository), (String)"ResourceRepositoryManage\u2026getModuleResources(facet)");
        this.resourcesRepository = localResourceRepository;
        Set<VirtualFile> set = this.resourcesRepository.getResourceDirs();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"resourcesRepository.resourceDirs");
        this.hashToFile = this.mapAllModuleResources(set);
        SynchronizationManager synchronizationManager = this;
        synchronizationManager.listeners = list = (List)new ArrayList();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this);
        Disposer.register((Disposable)this, (Disposable)this.resourcesRepository);
    }
}

