/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.resourceExplorer.ResourceExplorerToolFactory;
import com.android.tools.idea.resourceExplorer.editor.ResourceExplorer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001d\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00132\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00132\u0006\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/resourceExplorer/ResourceExplorerToolFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/util/Condition;", "", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "displayInToolWindow", "Lcom/android/tools/idea/resourceExplorer/editor/ResourceExplorer;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "disposable", "Lcom/intellij/openapi/Disposable;", "shouldBeAvailable", "", "kotlin.jvm.PlatformType", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Boolean;", "value", "o", "(Ljava/lang/Object;)Ljava/lang/Boolean;", "MyFileEditorListener", "intellij.android.core"})
public final class ResourceExplorerToolFactory
implements ToolWindowFactory,
DumbAware,
Condition<Object> {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)toolWindow, (String)"toolWindow");
        AndroidFacet facet = null;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
        Object[] objectArray = fileEditorManager.getSelectedFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"FileEditorManager.getIns\u2026ce(project).selectedFiles");
        facet = (AndroidFacet)((Object)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<VirtualFile, Module>(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final Module invoke(VirtualFile it) {
                return ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)this.$project);
            }
            {
                this.$project = project;
                super(1);
            }
        })), (Function1)createToolWindowContent.2.INSTANCE)));
        if (facet == null) {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Object[] objectArray2 = moduleManager.getModules();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"ModuleManager.getInstance(project).modules");
            facet = (AndroidFacet)((Object)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])objectArray2), (Function1)createToolWindowContent.3.INSTANCE)));
        }
        if (facet != null) {
            ResourceExplorer resourceExplorer = this.displayInToolWindow(facet, (Disposable)project, toolWindow);
            MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect(project)");
            MessageBusConnection connection = messageBusConnection;
            connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorListener(project, toolWindow, resourceExplorer));
        }
    }

    public Boolean shouldBeAvailable(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return (Boolean)StudioFlags.RESOURCE_MANAGER_ENABLED.get();
    }

    public Boolean value(@NotNull Object o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        return (Boolean)StudioFlags.RESOURCE_MANAGER_ENABLED.get();
    }

    private final ResourceExplorer displayInToolWindow(AndroidFacet facet, Disposable disposable, ToolWindow toolWindow) {
        ResourceExplorer resourceExplorer = ResourceExplorer.Companion.createForToolWindow(disposable, facet);
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.removeAllContents(true);
        ContentManager contentManager2 = contentManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)contentManager2, (String)"contentManager");
        ContentFactory contentFactory = contentManager2.getFactory();
        JComponent jComponent = resourceExplorer;
        Module module = facet.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"facet.module");
        Content content = contentFactory.createContent(jComponent, module.getName(), false);
        Intrinsics.checkExpressionValueIsNotNull((Object)content, (String)"contentManager.factory.c\u2026facet.module.name, false)");
        Content content2 = content;
        contentManager.addContent(content2);
        return resourceExplorer;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/resourceExplorer/ResourceExplorerToolFactory$MyFileEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "resourceExplorer", "Lcom/android/tools/idea/resourceExplorer/editor/ResourceExplorer;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;Lcom/android/tools/idea/resourceExplorer/editor/ResourceExplorer;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResourceExplorer", "()Lcom/android/tools/idea/resourceExplorer/editor/ResourceExplorer;", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "editorFocused", "", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "fileOpened", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.android.core"})
    private static final class MyFileEditorListener
    implements FileEditorManagerListener {
        @NotNull
        private final Project project;
        @NotNull
        private final ToolWindow toolWindow;
        @Nullable
        private final ResourceExplorer resourceExplorer;

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            FileEditor fileEditor = event.getNewEditor();
            if (fileEditor == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor, (String)"event.newEditor ?: return");
            FileEditor editor2 = fileEditor;
            this.editorFocused(editor2, this.project, this.resourceExplorer);
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            FileEditor fileEditor = source.getSelectedEditor(file);
            if (fileEditor == null) {
                return;
            }
            this.editorFocused(fileEditor, this.project, this.resourceExplorer);
        }

        private final void editorFocused(FileEditor editor2, Project project, ResourceExplorer resourceExplorer) {
            block9: {
                VirtualFile virtualFile;
                block8: {
                    block7: {
                        VirtualFile virtualFile2;
                        virtualFile = editor2.getFile();
                        if (virtualFile == null) break block7;
                        VirtualFile it = virtualFile2 = virtualFile;
                        boolean bl = false;
                        virtualFile = ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)project);
                        if (virtualFile != null) break block8;
                    }
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"editor.file?.let {\n     \u2026roject)\n      } ?: return");
                VirtualFile module = virtualFile;
                Content content = this.toolWindow.getContentManager().getContent(0);
                if (content != null) {
                    content.setDisplayName(module.getName());
                }
                AndroidFacet facet = AndroidFacet.getInstance((Module)module);
                if (facet == null) break block9;
                ResourceExplorer resourceExplorer2 = resourceExplorer;
                if (Intrinsics.areEqual((Object)((Object)facet), (Object)((Object)(resourceExplorer2 != null ? resourceExplorer2.getFacet() : null))) ^ true) {
                    ResourceExplorer resourceExplorer3 = resourceExplorer;
                    if (resourceExplorer3 != null) {
                        resourceExplorer3.setFacet(facet);
                    }
                }
            }
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final ToolWindow getToolWindow() {
            return this.toolWindow;
        }

        @Nullable
        public final ResourceExplorer getResourceExplorer() {
            return this.resourceExplorer;
        }

        public MyFileEditorListener(@NotNull Project project, @NotNull ToolWindow toolWindow, @Nullable ResourceExplorer resourceExplorer) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)toolWindow, (String)"toolWindow");
            this.project = project;
            this.toolWindow = toolWindow;
            this.resourceExplorer = resourceExplorer;
        }
    }
}

