/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.psi;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.sampledata.SampleDataManager;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResolvableResourceItem;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElementWithRequiredName;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class ResourceManagerToPsiResolver
implements AndroidResourceToPsiResolver {
    @NotNull
    public static final ResourceManagerToPsiResolver INSTANCE = new ResourceManagerToPsiResolver();

    private ResourceManagerToPsiResolver() {
    }

    @Override
    @NotNull
    public ResolveResult[] resolveToPsi(@NotNull ResourceValue resourceValue2, @NotNull XmlElement element, @NotNull AndroidFacet facet) {
        ResourceManager manager;
        ResourceNamespace resolvedNamespace;
        if (resourceValue2 == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(2);
        }
        if ((resolvedNamespace = ResourceHelper.resolveResourceNamespace(element, resourceValue2.getPackage())) == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ResourceManagerToPsiResolver.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        boolean attrReference = resourceValue2.getPrefix() == '?';
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        if (resourceValue2.getType() != null && resourceValue2.getResourceName() != null && (manager = ModuleResourceManagers.getInstance(facet).getResourceManager(resolvedNamespace.getPackageName(), (PsiElement)element)) != null) {
            manager.collectLazyResourceElements(resolvedNamespace, resourceValue2.getType().getName(), resourceValue2.getResourceName(), attrReference, (PsiElement)element, elements);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (elements.isEmpty() && resourceValue2.getResourceName() != null && resolvedNamespace != ResourceNamespace.ANDROID) {
            LocalResourceRepository resources = ResourceRepositoryManager.getAppResources(facet.getModule());
            ResourceType resourceType = resourceValue2.getType();
            if (resourceType != null && (resourceType != ResourceType.ATTR || attrReference)) {
                XmlAttribute attribute;
                assert (resources != null);
                String resourceName = resourceValue2.getResourceName();
                if (resourceType == ResourceType.SAMPLE_DATA) {
                    resourceName = SampleDataManager.getResourceNameFromSampleReference((String)resourceName);
                }
                List items2 = resources.getResources(resolvedNamespace, resourceType, resourceName);
                if (FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType).contains(ResourceFolderType.VALUES)) {
                    for (ResourceItem item : items2) {
                        if (item instanceof ResolvableResourceItem) {
                            result2.add(((ResolvableResourceItem)item).createResolveResult());
                            continue;
                        }
                        XmlTag tag = LocalResourceRepository.getItemTag(facet.getModule().getProject(), item);
                        if (tag == null) continue;
                        elements.add((PsiElement)tag);
                    }
                } else if (resourceType == ResourceType.SAMPLE_DATA && element.getParent() instanceof XmlAttribute && "http://schemas.android.com/tools".equals((attribute = (XmlAttribute)element.getParent()).getNamespace())) {
                    items2.stream().filter(SampleDataResourceItem.class::isInstance).map(SampleDataResourceItem.class::cast).forEach(sampleDataItem -> result2.add(sampleDataItem.createResolveResult()));
                }
            }
        }
        if (elements.size() > 1) {
            elements.sort(AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        for (PsiElement target : elements) {
            result2.add(new PsiElementResolveResult(target));
        }
        ResolveResult[] resolveResultArray = result2.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    public PsiElement[] getGotoDeclarationTargets(@NotNull AndroidResourceUtil.MyReferredResourceFieldInfo info, @NotNull PsiReferenceExpression refExpr) {
        AndroidFacet facet;
        if (info == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(5);
        }
        if (refExpr == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(6);
        }
        if ((facet = AndroidFacet.getInstance((PsiElement)refExpr)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                ResourceManagerToPsiResolver.$$$reportNull$$$0(7);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        String nestedClassName = info.getClassName();
        String fieldName = info.getFieldName();
        ArrayList<PsiElement> resourceList = new ArrayList<PsiElement>();
        if (info.isFromManifest()) {
            ResourceManagerToPsiResolver.collectManifestElements(nestedClassName, fieldName, facet, resourceList);
        } else {
            ResourceManager manager;
            ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet);
            ResourceManager resourceManager = manager = info.getNamespace() == ResourceNamespace.ANDROID ? resourceManagers.getFrameworkResourceManager(false) : resourceManagers.getLocalResourceManager();
            if (manager == null) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    ResourceManagerToPsiResolver.$$$reportNull$$$0(8);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            manager.collectLazyResourceElements(info.getNamespace(), nestedClassName, fieldName, false, (PsiElement)refExpr, resourceList);
            if (manager instanceof LocalResourceManager) {
                LocalResourceManager localManager = (LocalResourceManager)manager;
                if (nestedClassName.equals(ResourceType.ATTR.getName())) {
                    for (Attr attr : localManager.findAttrs(info.getNamespace(), fieldName)) {
                        resourceList.add((PsiElement)attr.getName().getXmlAttributeValue());
                    }
                } else if (nestedClassName.equals(ResourceType.STYLEABLE.getName())) {
                    for (DeclareStyleable declareStyleable : localManager.findStyleables(info.getNamespace(), fieldName)) {
                        resourceList.add((PsiElement)declareStyleable.getName().getXmlAttributeValue());
                    }
                    for (Attr attr : localManager.findStyleableAttributesByFieldName(info.getNamespace(), fieldName)) {
                        resourceList.add((PsiElement)attr.getName().getXmlAttributeValue());
                    }
                }
            }
        }
        if (resourceList.size() > 1) {
            resourceList.sort(AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        PsiElement[] psiElementArray = resourceList.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    private static void collectManifestElements(@NotNull String nestedClassName, @NotNull String fieldName, @NotNull AndroidFacet facet, @NotNull List<PsiElement> result2) {
        List<ManifestElementWithRequiredName> list;
        Manifest manifest;
        if (nestedClassName == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(10);
        }
        if (fieldName == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(11);
        }
        if (facet == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            ResourceManagerToPsiResolver.$$$reportNull$$$0(13);
        }
        if ((manifest = facet.getManifest()) == null) {
            return;
        }
        if ("permission".equals(nestedClassName)) {
            list = manifest.getPermissions();
        } else if ("permission_group".equals(nestedClassName)) {
            list = manifest.getPermissionGroups();
        } else {
            return;
        }
        for (ManifestElementWithRequiredName manifestElementWithRequiredName : list) {
            XmlAttributeValue psiElement;
            AndroidAttributeValue<String> nameAttribute = manifestElementWithRequiredName.getName();
            String unqualifiedName = StringUtil.getShortName((String)StringUtil.notNullize((String)((String)nameAttribute.getValue())));
            if (!AndroidUtils.equal(unqualifiedName, fieldName, false) || (psiElement = nameAttribute.getXmlAttributeValue()) == null) continue;
            result2.add((PsiElement)psiElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/psi/ResourceManagerToPsiResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedClassName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/psi/ResourceManagerToPsiResolver";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToPsi";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoDeclarationTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveToPsi";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGotoDeclarationTargets";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectManifestElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

