/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.res.aar.AarConfiguration;
import com.android.tools.idea.res.aar.AbstractAarValueResourceItem;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AarStyleResourceItem
extends AbstractAarValueResourceItem
implements StyleResourceValue {
    @Nullable
    private final String myParentStyle;
    @NotNull
    private final List<StyleItemResourceValue> myStyleItems;
    @NotNull
    private final Table<ResourceNamespace, String, StyleItemResourceValue> myStyleItemTable;

    public AarStyleResourceItem(@NotNull String name, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility, @Nullable String parentStyle, @NotNull Collection<StyleItemResourceValue> styleItems) {
        if (name == null) {
            AarStyleResourceItem.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            AarStyleResourceItem.$$$reportNull$$$0(1);
        }
        if (visibility == null) {
            AarStyleResourceItem.$$$reportNull$$$0(2);
        }
        if (styleItems == null) {
            AarStyleResourceItem.$$$reportNull$$$0(3);
        }
        super(name, configuration, visibility);
        this.myParentStyle = parentStyle;
        this.myStyleItems = ImmutableList.copyOf(styleItems);
        this.myStyleItemTable = HashBasedTable.create();
        for (StyleItemResourceValue item : styleItems) {
            this.myStyleItemTable.put((Object)item.getNamespace(), (Object)item.getAttrName(), (Object)item);
        }
    }

    @NotNull
    public ResourceType getResourceType() {
        ResourceType resourceType = ResourceType.STYLE;
        if (resourceType == null) {
            AarStyleResourceItem.$$$reportNull$$$0(4);
        }
        return resourceType;
    }

    @Nullable
    public String getParentStyleName() {
        return this.myParentStyle;
    }

    @Nullable
    public StyleItemResourceValue getItem(@NotNull ResourceNamespace namespace, @NotNull String name) {
        if (namespace == null) {
            AarStyleResourceItem.$$$reportNull$$$0(5);
        }
        if (name == null) {
            AarStyleResourceItem.$$$reportNull$$$0(6);
        }
        return (StyleItemResourceValue)this.myStyleItemTable.get((Object)namespace, (Object)name);
    }

    @Nullable
    public StyleItemResourceValue getItem(@NotNull ResourceReference attr) {
        if (attr == null) {
            AarStyleResourceItem.$$$reportNull$$$0(7);
        }
        assert (attr.getResourceType() == ResourceType.ATTR);
        return (StyleItemResourceValue)this.myStyleItemTable.get((Object)attr.getNamespace(), (Object)attr.getName());
    }

    @NotNull
    public Collection<StyleItemResourceValue> getDefinedItems() {
        List<StyleItemResourceValue> list = this.myStyleItems;
        if (list == null) {
            AarStyleResourceItem.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AarStyleResourceItem other = (AarStyleResourceItem)obj;
        return Objects.equals(this.myParentStyle, other.myParentStyle) && this.myStyleItemTable.equals(other.myStyleItemTable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleItems";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/aar/AarStyleResourceItem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/aar/AarStyleResourceItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

