/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.aar;

import com.android.tools.idea.res.aar.AarProtoResourceRepository;
import com.android.tools.idea.res.aar.AarSourceResourceRepository;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AarResourceRepositoryCache {
    private final Cache<File, AarProtoResourceRepository> myProtoRepositories = CacheBuilder.newBuilder().softValues().build();
    private final Cache<File, AarSourceResourceRepository> mySourceRepositories = CacheBuilder.newBuilder().softValues().build();

    public static AarResourceRepositoryCache getInstance() {
        return (AarResourceRepositoryCache)ServiceManager.getService(AarResourceRepositoryCache.class);
    }

    @NotNull
    public AarSourceResourceRepository getSourceRepository(@NotNull File aarDirectory, @Nullable String libraryName) {
        if (aarDirectory == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(0);
        }
        AarSourceResourceRepository aarSourceResourceRepository = AarResourceRepositoryCache.getRepository(aarDirectory, libraryName, this.mySourceRepositories, () -> AarSourceResourceRepository.create(aarDirectory, libraryName));
        if (aarSourceResourceRepository == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(1);
        }
        return aarSourceResourceRepository;
    }

    @NotNull
    public AarProtoResourceRepository getProtoRepository(@NotNull File resApkFile, @Nullable String libraryName) {
        if (resApkFile == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(2);
        }
        AarProtoResourceRepository aarProtoResourceRepository = AarResourceRepositoryCache.getRepository(resApkFile, libraryName, this.myProtoRepositories, () -> AarProtoResourceRepository.createProtoRepository(resApkFile, libraryName));
        if (aarProtoResourceRepository == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(3);
        }
        return aarProtoResourceRepository;
    }

    @NotNull
    private static <T extends AarSourceResourceRepository> T getRepository(@NotNull File file, @Nullable String libraryName, @NotNull Cache<File, T> cache, @NotNull Supplier<T> factory) {
        if (file == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(4);
        }
        if (cache == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(5);
        }
        if (factory == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(6);
        }
        AarSourceResourceRepository aarRepository = (AarSourceResourceRepository)((Object)CacheUtils.getAndUnwrap(cache, (Object)file, factory::get));
        if (!Objects.equals(libraryName, aarRepository.getLibraryName())) {
            assert (false) : "Library name mismatch: " + libraryName + " vs " + aarRepository.getLibraryName();
            Logger logger = Logger.getInstance(AarResourceRepositoryCache.class);
            logger.error((Throwable)new Exception("Library name mismatch: " + libraryName + " vs " + aarRepository.getLibraryName()));
        }
        AarSourceResourceRepository aarSourceResourceRepository = aarRepository;
        if (aarSourceResourceRepository == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(7);
        }
        return (T)((Object)aarSourceResourceRepository);
    }

    public void remove(@NotNull File aarDirectory) {
        if (aarDirectory == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(8);
        }
        this.myProtoRepositories.invalidate((Object)aarDirectory);
        this.mySourceRepositories.invalidate((Object)aarDirectory);
    }

    public void clear() {
        this.myProtoRepositories.invalidateAll();
        this.mySourceRepositories.invalidateAll();
    }

    private AarResourceRepositoryCache() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aarDirectory";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/aar/AarResourceRepositoryCache";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resApkFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/aar/AarResourceRepositoryCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRepository";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtoRepository";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRepository";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProtoRepository";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRepository";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

